/*
 * Decompiled with CFR 0.152.
 */
package net.levelz.network;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.levelz.access.PlayerStatsManagerAccess;
import net.levelz.access.PlayerSyncAccess;
import net.levelz.data.LevelLists;
import net.levelz.entity.LevelExperienceOrbEntity;
import net.levelz.init.ConfigInit;
import net.levelz.init.CriteriaInit;
import net.levelz.stats.PlayerStatsManager;
import net.levelz.stats.Skill;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5134;

public class PlayerStatsServerPacket {
    public static final class_2960 STATS_INCREASE_PACKET = new class_2960("levelz", "player_increase_stats");
    public static final class_2960 STATS_SYNC_PACKET = new class_2960("levelz", "player_sync_stats");
    public static final class_2960 XP_PACKET = new class_2960("levelz", "player_level_xp");
    public static final class_2960 LEVEL_PACKET = new class_2960("levelz", "player_level_stats");
    public static final class_2960 LIST_PACKET = new class_2960("levelz", "unlocking_list");
    public static final class_2960 STRENGTH_PACKET = new class_2960("levelz", "strength_sync");
    public static final class_2960 RESET_PACKET = new class_2960("levelz", "reset_skill");
    public static final class_2960 LEVEL_EXPERIENCE_ORB_PACKET = new class_2960("levelz", "level_experience_orb");
    public static final class_2960 SEND_CONFIG_SYNC_PACKET = new class_2960("levelz", "send_config_sync_packet");
    public static final class_2960 CONFIG_SYNC_PACKET = new class_2960("levelz", "config_sync_packet");
    public static final class_2960 TAG_PACKET = new class_2960("levelz", "tag_packet");
    public static final class_2960 SEND_TAG_PACKET = new class_2960("levelz", "send_tag_packet");
    public static final class_2960 LEVEL_UP_BUTTON_PACKET = new class_2960("levelz", "level_up_button");

    public static void init() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)STATS_INCREASE_PACKET, (server, player, handler, buffer, sender) -> {
            String skillString = buffer.method_19772().toUpperCase();
            int level = buffer.readInt();
            server.execute(() -> {
                PlayerStatsManager playerStatsManager = ((PlayerStatsManagerAccess)player).getPlayerStatsManager();
                if (playerStatsManager.getSkillPoints() - level >= 0) {
                    Skill skill = Skill.valueOf(skillString);
                    for (int i = 1; i <= level; ++i) {
                        CriteriaInit.SKILL_UP.trigger(player, skillString.toLowerCase(), playerStatsManager.getSkillLevel(skill) + level);
                    }
                    playerStatsManager.setSkillLevel(skill, playerStatsManager.getSkillLevel(skill) + level);
                    playerStatsManager.setSkillPoints(playerStatsManager.getSkillPoints() - level);
                    switch (skill) {
                        case HEALTH: {
                            player.method_5996(class_5134.field_23716).method_6192(player.method_26826(class_5134.field_23716) + ConfigInit.CONFIG.healthBonus * (double)level);
                            player.method_6033(player.method_6032() + (float)ConfigInit.CONFIG.healthBonus * (float)level);
                            break;
                        }
                        case STRENGTH: {
                            player.method_5996(class_5134.field_23721).method_6192(player.method_26826(class_5134.field_23721) + ConfigInit.CONFIG.attackBonus * (double)level);
                            break;
                        }
                        case AGILITY: {
                            player.method_5996(class_5134.field_23719).method_6192(player.method_26826(class_5134.field_23719) + ConfigInit.CONFIG.movementBonus * (double)level);
                            break;
                        }
                        case DEFENSE: {
                            player.method_5996(class_5134.field_23724).method_6192(player.method_26826(class_5134.field_23724) + ConfigInit.CONFIG.defenseBonus * (double)level);
                            break;
                        }
                        case LUCK: {
                            player.method_5996(class_5134.field_23726).method_6192(player.method_26826(class_5134.field_23726) + ConfigInit.CONFIG.luckBonus * (double)level);
                            break;
                        }
                        case MINING: {
                            PlayerStatsServerPacket.syncLockedBlockList(playerStatsManager);
                            break;
                        }
                        case ALCHEMY: {
                            PlayerStatsServerPacket.syncLockedBrewingItemList(playerStatsManager);
                            break;
                        }
                        case SMITHING: {
                            PlayerStatsServerPacket.syncLockedSmithingItemList(playerStatsManager);
                            break;
                        }
                    }
                    PlayerStatsServerPacket.syncLockedCraftingItemList(playerStatsManager);
                    PlayerStatsServerPacket.writeS2CSyncLevelPacket(playerStatsManager, player, skill);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SEND_CONFIG_SYNC_PACKET, (server, player, handler, buffer, sender) -> PlayerStatsServerPacket.writeS2CConfigSyncPacket(player, ConfigInit.CONFIG.getConfigList()));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SEND_TAG_PACKET, (server, player, handler, buffer, sender) -> PlayerStatsServerPacket.writeS2CTagPacket(player, buffer.method_10810()));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)LEVEL_UP_BUTTON_PACKET, (server, player, handler, buffer, sender) -> {
            int levelUp = buffer.readInt();
            server.execute(() -> ((PlayerSyncAccess)player).levelUp(levelUp, true, false));
        });
    }

    public static void writeS2CSyncLevelPacket(PlayerStatsManager playerStatsManager, class_3222 serverPlayerEntity, Skill skill) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10814(skill.name());
        buf.writeInt(playerStatsManager.getSkillLevel(skill));
        buf.writeInt(playerStatsManager.getSkillPoints());
        class_2658 packet = new class_2658(STATS_SYNC_PACKET, buf);
        serverPlayerEntity.field_13987.method_14364((class_2596)packet);
    }

    public static void writeS2CXPPacket(PlayerStatsManager playerStatsManager, class_3222 serverPlayerEntity) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeFloat(playerStatsManager.getLevelProgress());
        buf.writeInt(playerStatsManager.getTotalLevelExperience());
        buf.writeInt(playerStatsManager.getOverallLevel());
        class_2658 packet = new class_2658(XP_PACKET, buf);
        serverPlayerEntity.field_13987.method_14364((class_2596)packet);
    }

    public static void writeS2CSkillPacket(PlayerStatsManager playerStatsManager, class_3222 serverPlayerEntity) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeFloat(playerStatsManager.getLevelProgress());
        buf.writeInt(playerStatsManager.getTotalLevelExperience());
        buf.writeInt(playerStatsManager.getOverallLevel());
        buf.writeInt(playerStatsManager.getSkillPoints());
        for (Skill skill : Skill.values()) {
            buf.writeInt(playerStatsManager.getSkillLevel(skill));
        }
        PlayerStatsServerPacket.syncLockedBlockList(playerStatsManager);
        PlayerStatsServerPacket.syncLockedBrewingItemList(playerStatsManager);
        PlayerStatsServerPacket.syncLockedSmithingItemList(playerStatsManager);
        PlayerStatsServerPacket.syncLockedCraftingItemList(playerStatsManager);
        class_2658 packet = new class_2658(LEVEL_PACKET, buf);
        serverPlayerEntity.field_13987.method_14364((class_2596)packet);
    }

    public static void writeS2CStrengthPacket(class_3222 serverPlayerEntity) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeDouble(serverPlayerEntity.method_5996(class_5134.field_23721).method_6201());
        class_2658 packet = new class_2658(STRENGTH_PACKET, buf);
        serverPlayerEntity.field_13987.method_14364((class_2596)packet);
    }

    public static void syncLockedBlockList(PlayerStatsManager playerStatsManager) {
        playerStatsManager.lockedBlockIds.clear();
        for (int i = 0; i < LevelLists.miningLevelList.size(); ++i) {
            if (LevelLists.miningLevelList.get(i) <= playerStatsManager.getSkillLevel(Skill.MINING)) continue;
            for (int u = 0; u < LevelLists.miningBlockList.get(i).size(); ++u) {
                if (playerStatsManager.lockedBlockIds.contains(LevelLists.miningBlockList.get(i).get(u))) continue;
                playerStatsManager.lockedBlockIds.add(LevelLists.miningBlockList.get(i).get(u));
            }
        }
    }

    public static void syncLockedBrewingItemList(PlayerStatsManager playerStatsManager) {
        playerStatsManager.lockedbrewingItemIds.clear();
        for (int i = 0; i < LevelLists.brewingLevelList.size(); ++i) {
            if (LevelLists.brewingLevelList.get(i) <= playerStatsManager.getSkillLevel(Skill.ALCHEMY)) continue;
            for (int u = 0; u < LevelLists.brewingItemList.get(i).size(); ++u) {
                if (playerStatsManager.lockedbrewingItemIds.contains(LevelLists.brewingItemList.get(i).get(u))) continue;
                playerStatsManager.lockedbrewingItemIds.add(LevelLists.brewingItemList.get(i).get(u));
            }
        }
    }

    public static void syncLockedSmithingItemList(PlayerStatsManager playerStatsManager) {
        playerStatsManager.lockedSmithingItemIds.clear();
        for (int i = 0; i < LevelLists.smithingLevelList.size(); ++i) {
            if (LevelLists.smithingLevelList.get(i) <= playerStatsManager.getSkillLevel(Skill.SMITHING)) continue;
            for (int u = 0; u < LevelLists.smithingItemList.get(i).size(); ++u) {
                if (playerStatsManager.lockedSmithingItemIds.contains(LevelLists.smithingItemList.get(i).get(u))) continue;
                playerStatsManager.lockedSmithingItemIds.add(LevelLists.smithingItemList.get(i).get(u));
            }
        }
    }

    public static void syncLockedCraftingItemList(PlayerStatsManager playerStatsManager) {
        playerStatsManager.lockedCraftingItemIds.clear();
        for (int i = 0; i < LevelLists.craftingLevelList.size(); ++i) {
            if (LevelLists.craftingLevelList.get(i) <= playerStatsManager.getSkillLevel(Skill.valueOf(LevelLists.craftingSkillList.get(i).toString().toUpperCase()))) continue;
            for (int u = 0; u < LevelLists.craftingItemList.get(i).size(); ++u) {
                if (playerStatsManager.lockedCraftingItemIds.contains(LevelLists.craftingItemList.get(i).get(u))) continue;
                playerStatsManager.lockedCraftingItemIds.add(LevelLists.craftingItemList.get(i).get(u));
            }
        }
    }

    public static void writeS2CConfigSyncPacket(class_3222 serverPlayerEntity, List<Object> list) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) instanceof Integer) {
                buf.writeInt(((Integer)list.get(i)).intValue());
                continue;
            }
            if (list.get(i) instanceof Float) {
                buf.writeFloat(((Float)list.get(i)).floatValue());
                continue;
            }
            if (list.get(i) instanceof Double) {
                buf.writeDouble(((Double)list.get(i)).doubleValue());
                continue;
            }
            if (!(list.get(i) instanceof Boolean)) continue;
            buf.writeBoolean(((Boolean)list.get(i)).booleanValue());
        }
        class_2658 packet = new class_2658(CONFIG_SYNC_PACKET, buf);
        serverPlayerEntity.field_13987.method_14364((class_2596)packet);
    }

    public static void writeS2CTagPacket(class_3222 serverPlayerEntity, class_2960 identifier) {
    }

    public static void writeS2CListPacket(class_3222 serverPlayerEntity) {
        int k;
        class_2540 buf = new class_2540(Unpooled.buffer());
        for (int i = 0; i < LevelLists.getListNames().size(); ++i) {
            String listName = LevelLists.getListNames().get(i);
            ArrayList<Object> list = LevelLists.getList(listName);
            for (int u = 0; u < list.size(); ++u) {
                buf.method_10814(list.get(u).toString());
            }
        }
        for (k = 0; k < LevelLists.miningLevelList.size(); ++k) {
            buf.method_10814("mining:level");
            buf.method_10814(LevelLists.miningLevelList.get(k).toString());
            for (int u = 0; u < LevelLists.miningBlockList.get(k).size(); ++u) {
                buf.method_10814(LevelLists.miningBlockList.get(k).get(u).toString());
            }
        }
        for (k = 0; k < LevelLists.brewingLevelList.size(); ++k) {
            buf.method_10814("brewing:level");
            buf.method_10814(LevelLists.brewingLevelList.get(k).toString());
            for (int u = 0; u < LevelLists.brewingItemList.get(k).size(); ++u) {
                buf.method_10814(LevelLists.brewingItemList.get(k).get(u).toString());
            }
        }
        for (k = 0; k < LevelLists.smithingLevelList.size(); ++k) {
            buf.method_10814("smithing:level");
            buf.method_10814(LevelLists.smithingLevelList.get(k).toString());
            for (int u = 0; u < LevelLists.smithingItemList.get(k).size(); ++u) {
                buf.method_10814(LevelLists.smithingItemList.get(k).get(u).toString());
            }
        }
        for (k = 0; k < LevelLists.craftingLevelList.size(); ++k) {
            buf.method_10814("crafting:level");
            buf.method_10814(LevelLists.craftingLevelList.get(k).toString());
            buf.method_10814(LevelLists.craftingSkillList.get(k).toString());
            for (int u = 0; u < LevelLists.craftingItemList.get(k).size(); ++u) {
                buf.method_10814(LevelLists.craftingItemList.get(k).get(u).toString());
            }
        }
        class_2658 packet = new class_2658(LIST_PACKET, buf);
        serverPlayerEntity.field_13987.method_14364((class_2596)packet);
    }

    public static void writeS2CResetSkillPacket(class_3222 serverPlayerEntity, Skill skill) {
        PlayerStatsManager playerStatsManager = ((PlayerStatsManagerAccess)serverPlayerEntity).getPlayerStatsManager();
        int skillLevel = playerStatsManager.getSkillLevel(skill);
        switch (skill) {
            case HEALTH: {
                serverPlayerEntity.method_5996(class_5134.field_23716).method_6192(ConfigInit.CONFIG.healthBase + (double)skillLevel * ConfigInit.CONFIG.healthBonus);
                serverPlayerEntity.method_6033(serverPlayerEntity.method_6063());
                break;
            }
            case STRENGTH: {
                serverPlayerEntity.method_5996(class_5134.field_23721).method_6192(ConfigInit.CONFIG.attackBase + (double)skillLevel * ConfigInit.CONFIG.attackBonus);
                break;
            }
            case AGILITY: {
                serverPlayerEntity.method_5996(class_5134.field_23719).method_6192(ConfigInit.CONFIG.movementBase + (double)skillLevel * ConfigInit.CONFIG.movementBonus);
                break;
            }
            case DEFENSE: {
                serverPlayerEntity.method_5996(class_5134.field_23724).method_6192(ConfigInit.CONFIG.defenseBase + (double)skillLevel * ConfigInit.CONFIG.defenseBonus);
                break;
            }
            case LUCK: {
                serverPlayerEntity.method_5996(class_5134.field_23726).method_6192(ConfigInit.CONFIG.luckBase + (double)skillLevel * ConfigInit.CONFIG.luckBonus);
                break;
            }
        }
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10814(skill.name());
        class_2658 packet = new class_2658(RESET_PACKET, buf);
        serverPlayerEntity.field_13987.method_14364((class_2596)packet);
    }

    public class_2596<?> createS2CLevelExperienceOrbPacket(LevelExperienceOrbEntity levelExperienceOrbEntity) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10804(levelExperienceOrbEntity.method_5628());
        buf.writeDouble(levelExperienceOrbEntity.method_23317());
        buf.writeDouble(levelExperienceOrbEntity.method_23318());
        buf.writeDouble(levelExperienceOrbEntity.method_23321());
        buf.writeShort(levelExperienceOrbEntity.getExperienceAmount());
        return ServerPlayNetworking.createS2CPacket((class_2960)LEVEL_EXPERIENCE_ORB_PACKET, (class_2540)buf);
    }
}

