/*
 * Decompiled with CFR 0.152.
 */
package net.levelz.mixin.player;

import com.mojang.authlib.GameProfile;
import net.levelz.access.PlayerStatsManagerAccess;
import net.levelz.access.PlayerSyncAccess;
import net.levelz.init.ConfigInit;
import net.levelz.init.CriteriaInit;
import net.levelz.network.PlayerStatsServerPacket;
import net.levelz.stats.PlayerStatsManager;
import net.levelz.stats.Skill;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2596;
import net.minecraft.class_267;
import net.minecraft.class_2703;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_7428;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerEntityMixin
extends class_1657
implements PlayerSyncAccess {
    private PlayerStatsManager playerStatsManager = ((PlayerStatsManagerAccess)((Object)this)).getPlayerStatsManager();
    private int syncedLevelExperience = -99999999;
    private boolean syncTeleportStats = false;
    private int tinySyncTicker = 0;

    public ServerPlayerEntityMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile, class_7428 publicKey) {
        super(world, pos, yaw, gameProfile, publicKey);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void initMixin(MinecraftServer server, class_3218 world, GameProfile profile, @Nullable class_7428 publicKey, CallbackInfo info) {
        class_3222 serverPlayerEntity = (class_3222)this;
        serverPlayerEntity.method_5996(class_5134.field_23716).method_6192(ConfigInit.CONFIG.healthBase + (double)this.playerStatsManager.getSkillLevel(Skill.HEALTH) * ConfigInit.CONFIG.healthBonus);
        serverPlayerEntity.method_5996(class_5134.field_23719).method_6192(ConfigInit.CONFIG.movementBase + (double)this.playerStatsManager.getSkillLevel(Skill.AGILITY) * ConfigInit.CONFIG.movementBonus);
        serverPlayerEntity.method_5996(class_5134.field_23721).method_6192(ConfigInit.CONFIG.attackBase + (double)this.playerStatsManager.getSkillLevel(Skill.STRENGTH) * ConfigInit.CONFIG.attackBonus);
        serverPlayerEntity.method_5996(class_5134.field_23724).method_6192(ConfigInit.CONFIG.defenseBase + (double)this.playerStatsManager.getSkillLevel(Skill.DEFENSE) * ConfigInit.CONFIG.defenseBonus);
        serverPlayerEntity.method_5996(class_5134.field_23726).method_6192(ConfigInit.CONFIG.luckBase + (double)this.playerStatsManager.getSkillLevel(Skill.LUCK) * ConfigInit.CONFIG.luckBonus);
    }

    @Override
    public void addLevelExperience(int experience) {
        class_3222 playerEntity = (class_3222)this;
        if (!ConfigInit.CONFIG.useIndependentExp) {
            playerEntity.method_7255(experience);
            return;
        }
        if (!this.playerStatsManager.isMaxLevel()) {
            this.playerStatsManager.setLevelProgress(this.playerStatsManager.getLevelProgress() + Math.max((float)experience / (float)this.playerStatsManager.getNextLevelExperience(), 0.0f));
            this.playerStatsManager.setTotalLevelExperience(class_3532.method_15340((int)(this.playerStatsManager.getTotalLevelExperience() + experience), (int)0, (int)Integer.MAX_VALUE));
            this.levelUp(ConfigInit.CONFIG.overallMaxLevel, true, false);
        }
    }

    @Override
    public void levelUp(int levels, boolean deductXp, boolean ignoreMaxLevel) {
        if (levels == 0) {
            levels = Integer.MAX_VALUE;
        }
        class_3222 playerEntity = (class_3222)this;
        for (int i = 0; i < levels && (ignoreMaxLevel || !this.playerStatsManager.isMaxLevel()); ++i) {
            if (deductXp) {
                if (this.playerStatsManager.getLevelProgress() < 1.0f) break;
                int nextLevelExperience = this.playerStatsManager.getNextLevelExperience();
                if (!ConfigInit.CONFIG.useIndependentExp) {
                    playerEntity.method_7255(-nextLevelExperience);
                } else {
                    this.playerStatsManager.setLevelProgress((this.playerStatsManager.getLevelProgress() - 1.0f) * (float)nextLevelExperience);
                }
            }
            this.playerStatsManager.addExperienceLevels(1);
            this.playerStatsManager.setLevelProgress(this.playerStatsManager.getLevelProgress() / (float)this.playerStatsManager.getNextLevelExperience());
            PlayerStatsServerPacket.writeS2CSkillPacket(this.playerStatsManager, playerEntity);
            PlayerStatsManager.onLevelUp((class_1657)playerEntity, this.playerStatsManager.getOverallLevel());
            CriteriaInit.LEVEL_UP.trigger(playerEntity, this.playerStatsManager.getOverallLevel());
            playerEntity.field_13995.method_3760().method_14581((class_2596)new class_2703(class_2703.class_5893.field_29137, new class_3222[]{playerEntity}));
            playerEntity.method_7327().method_1162(CriteriaInit.LEVELZ, this.method_5820(), class_267::method_1130);
            if (this.playerStatsManager.getOverallLevel() <= 0) continue;
            playerEntity.field_6002.method_43128(null, playerEntity.method_23317(), playerEntity.method_23318(), playerEntity.method_23321(), class_3417.field_14709, playerEntity.method_5634(), 1.0f, 1.0f);
        }
        this.syncedLevelExperience = -1;
    }

    @Inject(method={"playerTick"}, at={@At(value="FIELD", target="Lnet/minecraft/server/network/ServerPlayerEntity;totalExperience:I", ordinal=0, shift=At.Shift.BEFORE)})
    private void playerTickMixin(CallbackInfo info) {
        if (this.playerStatsManager.getTotalLevelExperience() != this.syncedLevelExperience) {
            this.syncedLevelExperience = this.playerStatsManager.getTotalLevelExperience();
            PlayerStatsServerPacket.writeS2CXPPacket(this.playerStatsManager, (class_3222)this);
            if (this.syncTeleportStats) {
                PlayerStatsServerPacket.writeS2CSkillPacket(this.playerStatsManager, (class_3222)this);
                this.syncTeleportStats = false;
            }
        }
        if (this.tinySyncTicker > 0) {
            --this.tinySyncTicker;
            if (this.tinySyncTicker % 20 == 0) {
                this.syncStats(false);
            }
        }
    }

    @Inject(method={"onSpawn"}, at={@At(value="TAIL")})
    private void onSpawnMixin(CallbackInfo info) {
        PlayerStatsServerPacket.writeS2CSkillPacket(this.playerStatsManager, (class_3222)this);
    }

    @Inject(method={"copyFrom"}, at={@At(value="FIELD", target="Lnet/minecraft/server/network/ServerPlayerEntity;syncedExperience:I", ordinal=0)})
    private void copyFromMixin(class_3222 oldPlayer, boolean alive, CallbackInfo info) {
        this.syncStats(false);
    }

    @Override
    public void syncStats(boolean syncDelay) {
        this.syncTeleportStats = true;
        this.syncedLevelExperience = -1;
        if (syncDelay) {
            this.tinySyncTicker = 40;
        }
    }
}

