/*
 * Decompiled with CFR 0.152.
 */
package net.levelz.mixin.player;

import java.util.ArrayList;
import net.levelz.access.PlayerDropAccess;
import net.levelz.access.PlayerStatsManagerAccess;
import net.levelz.data.LevelLists;
import net.levelz.entity.LevelExperienceOrbEntity;
import net.levelz.init.ConfigInit;
import net.levelz.stats.PlayerStatsManager;
import net.levelz.stats.Skill;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1810;
import net.minecraft.class_1821;
import net.minecraft.class_1829;
import net.minecraft.class_1831;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import net.minecraft.class_4174;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309
implements PlayerStatsManagerAccess,
PlayerDropAccess {
    private final class_1657 playerEntity = (class_1657)this;
    private final PlayerStatsManager playerStatsManager = new PlayerStatsManager(this.playerEntity);
    private boolean isCrit;
    private int killedMobsInChunk;
    @Nullable
    private class_2791 killedMobChunk;

    public PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    public void readCustomDataFromNbtMixin(class_2487 tag, CallbackInfo info) {
        this.playerStatsManager.readNbt(tag);
        this.playerEntity.method_5996(class_5134.field_23719).method_6192(ConfigInit.CONFIG.movementBase + (double)this.playerStatsManager.getSkillLevel(Skill.AGILITY) * ConfigInit.CONFIG.movementBonus);
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    public void writeCustomDataToNbtMixin(class_2487 tag, CallbackInfo info) {
        this.playerStatsManager.writeNbt(tag);
    }

    @Redirect(method={"addExhaustion"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/HungerManager;addExhaustion(F)V"), require=0)
    private void addExhaustion(class_1702 hungerManager, float exhaustion) {
        hungerManager.method_7583(exhaustion *= ConfigInit.CONFIG.staminaBase - (float)this.playerStatsManager.getSkillLevel(Skill.STAMINA) * ConfigInit.CONFIG.staminaBonus);
    }

    @ModifyVariable(method={"attack"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/enchantment/EnchantmentHelper;getKnockback(Lnet/minecraft/entity/LivingEntity;)I"), ordinal=0, require=0)
    private boolean attacGetKnockbackkMixin(boolean original) {
        if (this.playerEntity.field_6002.field_9229.method_43057() < (float)this.playerStatsManager.getSkillLevel(Skill.LUCK) * ConfigInit.CONFIG.luckCritBonus) {
            this.isCrit = true;
            return true;
        }
        this.isCrit = false;
        return original;
    }

    @ModifyVariable(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;isSprinting()Z", ordinal=0), ordinal=1, require=0)
    private boolean attackIsSprintingMixin(boolean original) {
        if (this.isCrit) {
            return true;
        }
        return original;
    }

    @ModifyVariable(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/enchantment/EnchantmentHelper;getFireAspect(Lnet/minecraft/entity/LivingEntity;)I"), ordinal=2, require=0)
    private boolean attackGetFireAspectMixin(boolean original) {
        if (this.isCrit) {
            return true;
        }
        return original;
    }

    @ModifyVariable(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;getItem()Lnet/minecraft/item/Item;", shift=At.Shift.AFTER), ordinal=0, require=0)
    private float attackGetItemMixin(float original) {
        if (this.playerStatsManager.getSkillLevel(Skill.STRENGTH) >= ConfigInit.CONFIG.maxLevel && ConfigInit.CONFIG.attackDoubleDamageChance > this.playerEntity.field_6002.field_9229.method_43057()) {
            return original * 2.0f;
        }
        return this.isCrit ? original * ConfigInit.CONFIG.attackCritDmgBonus : original;
    }

    @ModifyVariable(method={"attack"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/entity/player/PlayerEntity;getAttackCooldownProgress(F)F"), ordinal=0, require=0)
    private float attackGetAttackCooldownProgressMixin(float original) {
        return this.getUnlockedDamage(original, false);
    }

    @ModifyVariable(method={"attack"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/entity/player/PlayerEntity;getAttackCooldownProgress(F)F"), ordinal=1, require=0)
    private float attackGetAttackCooldownProgressMixinTwo(float original) {
        return this.getUnlockedDamage(original, true);
    }

    @ModifyVariable(method={"attack"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/enchantment/EnchantmentHelper;getFireAspect(Lnet/minecraft/entity/LivingEntity;)I"), ordinal=1, require=0)
    private int attackGetFireAspectMixin(int original) {
        return (int)this.getUnlockedDamage(original, true);
    }

    @ModifyVariable(method={"attack"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/enchantment/EnchantmentHelper;getKnockback(Lnet/minecraft/entity/LivingEntity;)I"), ordinal=0, require=0)
    private int attackGetKnockbackMixin(int original) {
        return (int)this.getUnlockedDamage(original, true);
    }

    @ModifyVariable(method={"attack"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/World;getNonSpectatingEntities(Ljava/lang/Class;Lnet/minecraft/util/math/Box;)Ljava/util/List;"), ordinal=3)
    private float attackGetSweepingMultiplierMixin(float original) {
        return this.getUnlockedDamage(original, true);
    }

    private float getUnlockedDamage(float original, boolean zero) {
        class_1792 item = this.playerEntity.method_6047().method_7909();
        if (!item.equals(class_1802.field_8162)) {
            ArrayList<Object> levelList = LevelLists.customItemList;
            if (!levelList.isEmpty() && levelList.contains(class_2378.field_11142.method_10221((Object)item).toString())) {
                if (!PlayerStatsManager.playerLevelisHighEnough(this.playerEntity, levelList, class_2378.field_11142.method_10221((Object)item).toString(), true)) {
                    return zero ? 0.0f : 1.0f;
                }
            } else if (item instanceof class_1831) {
                levelList = null;
                if (item instanceof class_1829) {
                    levelList = LevelLists.swordList;
                } else if (item instanceof class_1743) {
                    levelList = ConfigInit.CONFIG.bindAxeDamageToSwordRestriction ? LevelLists.swordList : LevelLists.axeList;
                } else if (item instanceof class_1794) {
                    levelList = LevelLists.hoeList;
                } else if (item instanceof class_1810 || item instanceof class_1821) {
                    levelList = LevelLists.toolList;
                }
                if (levelList != null && !PlayerStatsManager.playerLevelisHighEnough(this.playerEntity, levelList, ((class_1831)item).method_8022().toString().toLowerCase(), true)) {
                    return zero ? 0.0f : 1.0f;
                }
            }
        }
        return original;
    }

    @Inject(method={"damage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;dropShoulderEntities()V", shift=At.Shift.AFTER)}, cancellable=true)
    private void damageMixin(class_1282 source, float amount, CallbackInfoReturnable<Boolean> info) {
        if (this.playerStatsManager.getSkillLevel(Skill.DEFENSE) >= ConfigInit.CONFIG.maxLevel && source.method_5529() != null && this.playerEntity.field_6002.field_9229.method_43057() <= ConfigInit.CONFIG.defenseReflectChance) {
            source.method_5529().method_5643(source, amount);
        }
        if (this.playerStatsManager.getSkillLevel(Skill.AGILITY) >= ConfigInit.CONFIG.maxLevel && this.playerEntity.field_6002.field_9229.method_43057() <= ConfigInit.CONFIG.movementMissChance) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"eatFood"}, at={@At(value="HEAD")})
    private void eatFoodMixin(class_1937 world, class_1799 stack, CallbackInfoReturnable<class_1799> info) {
        if (stack.method_7909().method_19263() && this.playerStatsManager.getSkillLevel(Skill.STAMINA) >= ConfigInit.CONFIG.maxLevel) {
            class_4174 foodComponent = stack.method_7909().method_19264();
            float multiplier = ConfigInit.CONFIG.staminaFoodBonus;
            this.playerEntity.method_7344().method_7585((int)((float)foodComponent.method_19230() * multiplier), foodComponent.method_19231() * multiplier);
        }
    }

    @Override
    public PlayerStatsManager getPlayerStatsManager() {
        return this.playerStatsManager;
    }

    @Override
    public void increaseKilledMobStat(class_2791 chunk) {
        if (this.killedMobChunk != null && this.killedMobChunk == chunk) {
            ++this.killedMobsInChunk;
        } else {
            this.killedMobChunk = chunk;
            this.killedMobsInChunk = 0;
        }
    }

    @Override
    public void resetKilledMobStat() {
        this.killedMobsInChunk = 0;
    }

    @Override
    public boolean allowMobDrop() {
        return this.killedMobsInChunk < ConfigInit.CONFIG.mobKillCount;
    }

    protected void method_23883() {
        if (this.field_6002 instanceof class_3218 && (this.method_6071() || this.field_6238 > 0 && this.method_6054() && this.field_6002.method_8450().method_8355(class_1928.field_19391))) {
            if (ConfigInit.CONFIG.dropPlayerXP && (ConfigInit.CONFIG.resetCurrentXP || ConfigInit.CONFIG.hardMode)) {
                LevelExperienceOrbEntity.spawn((class_3218)this.field_6002, this.method_19538(), (int)(this.playerStatsManager.getLevelProgress() * (float)this.playerStatsManager.getNextLevelExperience()));
            }
            class_1303.method_31493((class_3218)((class_3218)this.field_6002), (class_243)this.method_19538(), (int)this.method_6110());
        }
    }
}

