/*
 * Decompiled with CFR 0.152.
 */
package net.levelz.mixin.misc;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.levelz.access.PlayerStatsManagerAccess;
import net.levelz.init.ConfigInit;
import net.levelz.stats.Skill;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1706;
import net.minecraft.class_1799;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_3917;
import net.minecraft.class_4861;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1706.class})
public abstract class AnvilScreenHandlerMixin
extends class_4861 {
    @Shadow
    @Final
    private class_3915 field_7770;
    private int smithingLevel;

    public AnvilScreenHandlerMixin(@Nullable class_3917<?> type, int syncId, class_1661 playerInventory, class_3914 context) {
        super(type, syncId, playerInventory, context);
        this.smithingLevel = ((PlayerStatsManagerAccess)this.field_22482).getPlayerStatsManager().getSkillLevel(Skill.SMITHING);
    }

    @Inject(method={"canTakeOutput"}, at={@At(value="HEAD")}, cancellable=true)
    protected void canTakeOutputMixin(class_1657 player, boolean present, CallbackInfoReturnable<Boolean> info) {
        if (this.field_7770.method_17407() <= 0 && (this.smithingLevel >= ConfigInit.CONFIG.maxLevel || (int)(1.0f - (float)this.smithingLevel * ConfigInit.CONFIG.smithingCostBonus) <= 0)) {
            info.setReturnValue((Object)true);
        }
    }

    @Inject(method={"Lnet/minecraft/screen/AnvilScreenHandler;updateResult()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/inventory/CraftingResultInventory;setStack(ILnet/minecraft/item/ItemStack;)V", ordinal=4)})
    private void updateResultMixin(CallbackInfo info) {
        if (this.field_7770.method_17407() > 1) {
            int levelCost = (int)((float)this.field_7770.method_17407() * (1.0f - (float)this.smithingLevel * ConfigInit.CONFIG.smithingCostBonus));
            if (levelCost > 30 && this.smithingLevel >= ConfigInit.CONFIG.maxLevel) {
                this.field_7770.method_17404(30);
            } else {
                this.field_7770.method_17404(levelCost < 0 ? 0 : levelCost);
            }
        }
    }

    @Inject(method={"onTakeOutput"}, at={@At(value="INVOKE", target="Lnet/minecraft/screen/Property;get()I")}, require=0)
    private void onTakeOutputMixin(class_1657 playerEntity, class_1799 stack, CallbackInfo ci) {
        if (this.smithingLevel >= ConfigInit.CONFIG.maxLevel && ConfigInit.CONFIG.smithingAnvilChance > playerEntity.field_6002.field_9229.method_43057()) {
            this.field_7770.method_17404(0);
        }
    }

    @Inject(method={"getLevelCost"}, at={@At(value="HEAD")}, cancellable=true)
    @Environment(value=EnvType.CLIENT)
    public void getLevelCostMixin(CallbackInfoReturnable<Integer> info) {
        if (this.field_7770.method_17407() > 30 && this.smithingLevel >= ConfigInit.CONFIG.maxLevel) {
            info.setReturnValue((Object)30);
        }
    }
}

