/*
 * Decompiled with CFR 0.152.
 */
package net.levelz.data;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.levelz.data.LevelLists;
import net.levelz.init.ConfigInit;
import net.libz.util.SortList;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LevelLoader
implements SimpleSynchronousResourceReloadListener {
    private static final Logger LOGGER = LogManager.getLogger((String)"LevelZ");
    private List<List<Integer>> objectList = new ArrayList<List<Integer>>();
    private List<Integer> levelList = new ArrayList<Integer>();
    private List<Boolean> replaceList = new ArrayList<Boolean>();
    private List<String> skillList = new ArrayList<String>();

    public class_2960 getFabricId() {
        return new class_2960("levelz", "level_loader");
    }

    public void method_14491(class_3300 manager) {
        LevelLoader.clearEveryList();
        if (ConfigInit.CONFIG.miningProgression) {
            manager.method_14488("mining", id -> id.method_12832().endsWith(".json")).forEach((id, resourceRef) -> {
                try {
                    InputStream stream = resourceRef.method_14482();
                    JsonObject data = JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject();
                    if (this.levelList.contains(data.get("level").getAsInt())) {
                        int index = this.levelList.indexOf(data.get("level").getAsInt());
                        if (class_3518.method_15258((JsonObject)data, (String)"replace", (boolean)false)) {
                            this.levelList.remove(index);
                            this.objectList.remove(index);
                            this.replaceList.remove(index);
                            this.fillLists(data, false, 1, -1);
                        } else if (!this.replaceList.get(index).booleanValue()) {
                            this.fillLists(data, true, 1, -1);
                        }
                    } else {
                        this.fillLists(data, false, 1, -1);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error occurred while loading resource {}. {}", (Object)id.toString(), (Object)e.toString());
                }
            });
            this.sortAndFillLists(this.levelList, this.objectList, 1);
        }
        if (ConfigInit.CONFIG.itemProgression) {
            manager.method_14488("item", id -> id.method_12832().endsWith(".json")).forEach((id, resourceRef) -> {
                try {
                    InputStream stream = resourceRef.method_14482();
                    JsonObject data = JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject();
                    ArrayList<Object> list = LevelLists.getList(data.get("item").getAsString());
                    if (data.get("item").getAsString().equals("minecraft:armor") || data.get("item").getAsString().equals("minecraft:tool") || data.get("item").getAsString().equals("minecraft:hoe") || data.get("item").getAsString().equals("minecraft:sword") || data.get("item").getAsString().equals("minecraft:axe")) {
                        if (list.contains(data.get("material").getAsString())) {
                            if (class_3518.method_15258((JsonObject)data, (String)"replace", (boolean)false)) {
                                int removeLines = list.indexOf(data.get("material").getAsString());
                                for (int i = 0; i < 5; ++i) {
                                    list.remove(removeLines);
                                }
                            } else {
                                if (!((Boolean)list.get(list.indexOf(data.get("material").getAsString()) + 4)).booleanValue()) {
                                    LOGGER.info("Resource {} was not loaded cause it already existed", (Object)id.toString());
                                }
                                return;
                            }
                        }
                        list.add(data.get("material").getAsString());
                        list.add(data.get("skill").getAsString());
                        list.add(data.get("level").getAsInt());
                        list.add(data.get("item").getAsString());
                        list.add(class_3518.method_15258((JsonObject)data, (String)"replace", (boolean)false));
                    } else if (data.get("item").getAsString().equals("minecraft:custom_item")) {
                        ArrayList<Object> customList = LevelLists.getList(data.get("item").getAsString());
                        if (customList.contains(data.get("object").getAsString())) {
                            if (class_3518.method_15258((JsonObject)data, (String)"replace", (boolean)false)) {
                                int removeLines = list.indexOf(data.get("object").getAsString());
                                for (int i = 0; i < 5; ++i) {
                                    list.remove(removeLines);
                                }
                            } else {
                                if (!((Boolean)list.get(list.indexOf(data.get("object").getAsString()) + 4)).booleanValue()) {
                                    LOGGER.info("Resource {} was not loaded cause it already existed", (Object)id.toString());
                                }
                                return;
                            }
                        }
                        if (((class_1792)class_2378.field_11142.method_10223(new class_2960(data.get("object").getAsString()))).toString().equals("air") && class_3518.method_15258((JsonObject)data, (String)"required", (boolean)true)) {
                            LOGGER.info("Resource {} was not loaded cause {} is not a valid item identifier", (Object)id.toString(), (Object)data.get("object").getAsString());
                            return;
                        }
                        customList.add(data.get("object").getAsString());
                        customList.add(data.get("skill").getAsString());
                        customList.add(data.get("level").getAsInt());
                        customList.add(data.get("item").getAsString());
                        customList.add(class_3518.method_15258((JsonObject)data, (String)"replace", (boolean)false));
                    } else {
                        if (!list.isEmpty()) {
                            if (class_3518.method_15258((JsonObject)data, (String)"replace", (boolean)false)) {
                                list.clear();
                            } else {
                                if (!((Boolean)list.get(3)).booleanValue()) {
                                    LOGGER.info("Resource {} was not loaded cause it already existed", (Object)id.toString());
                                }
                                return;
                            }
                        }
                        if (((class_1792)class_2378.field_11142.method_10223(new class_2960(data.get("item").getAsString()))).toString().equals("air") && class_3518.method_15258((JsonObject)data, (String)"required", (boolean)true)) {
                            LOGGER.info("Resource {} was not loaded cause {} is not a valid item identifier", (Object)id.toString(), (Object)data.get("item").getAsString());
                            return;
                        }
                        list.add(data.get("skill").getAsString());
                        list.add(data.get("level").getAsInt());
                        list.add(data.get("item").getAsString());
                        list.add(class_3518.method_15258((JsonObject)data, (String)"replace", (boolean)false));
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error occurred while loading resource {}. {}", (Object)id.toString(), (Object)e.toString());
                }
            });
        }
        if (ConfigInit.CONFIG.blockProgression) {
            manager.method_14488("block", id -> id.method_12832().endsWith(".json")).forEach((id, resourceRef) -> {
                try {
                    InputStream stream = resourceRef.method_14482();
                    JsonObject data = JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject();
                    ArrayList<Object> list = LevelLists.getList(data.get("block").getAsString());
                    if (data.get("block").getAsString().equals("minecraft:custom_block")) {
                        ArrayList<Object> customList = LevelLists.getList(data.get("block").getAsString());
                        if (customList.contains(data.get("object").getAsString())) {
                            if (class_3518.method_15258((JsonObject)data, (String)"replace", (boolean)false)) {
                                int removeLines = list.indexOf(data.get("object").getAsString());
                                for (int i = 0; i < 5; ++i) {
                                    list.remove(removeLines);
                                }
                            } else {
                                if (!((Boolean)list.get(list.indexOf(data.get("object").getAsString()) + 4)).booleanValue()) {
                                    LOGGER.info("Resource {} was not loaded cause it already existed", (Object)id.toString());
                                }
                                return;
                            }
                        }
                        if (((class_2248)class_2378.field_11146.method_10223(new class_2960(data.get("object").getAsString()))).toString().equals("Block{minecraft:air}")) {
                            LOGGER.info("Resource {} was not loaded cause {} is not a valid block identifier", (Object)id.toString(), (Object)data.get("object").getAsString());
                            return;
                        }
                        customList.add(data.get("object").getAsString());
                        customList.add(data.get("skill").getAsString());
                        customList.add(data.get("level").getAsInt());
                        customList.add(data.get("block").getAsString());
                        customList.add(class_3518.method_15258((JsonObject)data, (String)"replace", (boolean)false));
                    } else {
                        if (!list.isEmpty()) {
                            if (class_3518.method_15258((JsonObject)data, (String)"replace", (boolean)false)) {
                                list.clear();
                            } else {
                                if (!((Boolean)list.get(3)).booleanValue()) {
                                    LOGGER.info("Resource {} was not loaded cause it already existed", (Object)id.toString());
                                }
                                return;
                            }
                        }
                        if (((class_2248)class_2378.field_11146.method_10223(new class_2960(data.get("block").getAsString()))).toString().equals("Block{minecraft:air}")) {
                            LOGGER.info("Resource {} was not loaded cause {} is not a valid block identifier", (Object)id.toString(), (Object)data.get("block").getAsString());
                            return;
                        }
                        list.add(data.get("skill").getAsString());
                        list.add(data.get("level").getAsInt());
                        list.add(data.get("block").getAsString());
                        list.add(class_3518.method_15258((JsonObject)data, (String)"replace", (boolean)false));
                        if (data.get("enchanting_tier") != null) {
                            for (int i = 0; i < data.getAsJsonArray("enchanting_tier").size(); ++i) {
                                list.add(data.get("enchanting_tier").getAsJsonArray().get(i).getAsInt());
                            }
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error occurred while loading resource {}. {}", (Object)id.toString(), (Object)e.toString());
                }
            });
        }
        if (ConfigInit.CONFIG.entityProgression) {
            manager.method_14488("entity", id -> id.method_12832().endsWith(".json")).forEach((id, resourceRef) -> {
                try {
                    InputStream stream = resourceRef.method_14482();
                    JsonObject data = JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject();
                    ArrayList<Object> list = LevelLists.getList(data.get("entity").getAsString());
                    if (data.get("entity").getAsString().equals("minecraft:custom_entity")) {
                        ArrayList<Object> customList = LevelLists.getList(data.get("entity").getAsString());
                        if (customList.contains(data.get("object").getAsString())) {
                            if (class_3518.method_15258((JsonObject)data, (String)"replace", (boolean)false)) {
                                int removeLines = list.indexOf(data.get("object").getAsString());
                                for (int i = 0; i < 5; ++i) {
                                    list.remove(removeLines);
                                }
                            } else {
                                if (!((Boolean)list.get(list.indexOf(data.get("object").getAsString()) + 4)).booleanValue()) {
                                    LOGGER.info("Resource {} was not loaded cause it already existed", (Object)id.toString());
                                }
                                return;
                            }
                        }
                        if (((class_1299)class_2378.field_11145.method_10223(new class_2960(data.get("object").getAsString()))).toString().equals("entity.minecraft.pig")) {
                            LOGGER.info("Resource {} was not loaded cause {} is not a valid entity identifier", (Object)id.toString(), (Object)data.get("object").getAsString());
                            return;
                        }
                        customList.add(data.get("object").getAsString());
                        customList.add(data.get("skill").getAsString());
                        customList.add(data.get("level").getAsInt());
                        customList.add(data.get("entity").getAsString());
                        customList.add(class_3518.method_15258((JsonObject)data, (String)"replace", (boolean)false));
                    } else {
                        if (!list.isEmpty()) {
                            if (class_3518.method_15258((JsonObject)data, (String)"replace", (boolean)false)) {
                                list.clear();
                            } else {
                                if (!((Boolean)list.get(3)).booleanValue()) {
                                    LOGGER.info("Resource {} was not loaded cause it already existed", (Object)id.toString());
                                }
                                return;
                            }
                        }
                        if (!data.get("entity").getAsString().equals("minecraft:breeding") && ((class_1299)class_2378.field_11145.method_10223(new class_2960(data.get("entity").getAsString()))).toString().equals("entity.minecraft.pig")) {
                            LOGGER.info("Resource {} was not loaded cause {} is not a valid entity identifier", (Object)id.toString(), (Object)data.get("entity").getAsString());
                            return;
                        }
                        list.add(data.get("skill").getAsString());
                        list.add(data.get("level").getAsInt());
                        list.add(data.get("entity").getAsString());
                        list.add(class_3518.method_15258((JsonObject)data, (String)"replace", (boolean)false));
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error occurred while loading resource {}. {}", (Object)id.toString(), (Object)e.toString());
                }
            });
        }
        if (ConfigInit.CONFIG.brewingProgression) {
            manager.method_14488("brewing", id -> id.method_12832().endsWith(".json")).forEach((id, resourceRef) -> {
                try {
                    InputStream stream = resourceRef.method_14482();
                    JsonObject data = JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject();
                    if (this.levelList.contains(data.get("level").getAsInt())) {
                        int index = this.levelList.indexOf(data.get("level").getAsInt());
                        if (class_3518.method_15258((JsonObject)data, (String)"replace", (boolean)false)) {
                            this.levelList.remove(index);
                            this.objectList.remove(index);
                            this.replaceList.remove(index);
                            this.fillLists(data, false, 2, -1);
                        } else if (!this.replaceList.get(index).booleanValue()) {
                            this.fillLists(data, true, 2, -1);
                        }
                    } else {
                        this.fillLists(data, false, 2, -1);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error occurred while loading resource {}. {}", (Object)id.toString(), (Object)e.toString());
                }
            });
            this.sortAndFillLists(this.levelList, this.objectList, 2);
        }
        if (ConfigInit.CONFIG.smithingProgression) {
            manager.method_14488("smithing", id -> id.method_12832().endsWith(".json")).forEach((id, resourceRef) -> {
                try {
                    InputStream stream = resourceRef.method_14482();
                    JsonObject data = JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject();
                    if (this.levelList.contains(data.get("level").getAsInt())) {
                        int index = this.levelList.indexOf(data.get("level").getAsInt());
                        if (class_3518.method_15258((JsonObject)data, (String)"replace", (boolean)false)) {
                            this.levelList.remove(index);
                            this.objectList.remove(index);
                            this.replaceList.remove(index);
                            this.fillLists(data, false, 2, -1);
                        } else if (!this.replaceList.get(index).booleanValue()) {
                            this.fillLists(data, true, 2, -1);
                        }
                    } else {
                        this.fillLists(data, false, 2, -1);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error occurred while loading resource {}. {}", (Object)id.toString(), (Object)e.toString());
                }
            });
            this.sortAndFillLists(this.levelList, this.objectList, 3);
        }
        manager.method_14488("crafting", id -> id.method_12832().endsWith(".json")).forEach((id, resourceRef) -> {
            try {
                InputStream stream = resourceRef.method_14482();
                JsonObject data = JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject();
                int index = -1;
                if (this.skillList.contains(data.get("skill").getAsString())) {
                    for (int i = 0; i < this.skillList.size(); ++i) {
                        if (!this.skillList.get(i).equals(data.get("skill").getAsString()) || this.levelList.size() < i || !this.levelList.get(i).equals(data.get("level").getAsInt())) continue;
                        index = i;
                        break;
                    }
                }
                if (index != -1) {
                    if (class_3518.method_15258((JsonObject)data, (String)"replace", (boolean)false)) {
                        this.skillList.remove(index);
                        this.levelList.remove(index);
                        this.objectList.remove(index);
                        this.replaceList.remove(index);
                        this.fillLists(data, false, 3, index);
                    } else if (!this.replaceList.get(index).booleanValue()) {
                        this.fillLists(data, true, 3, index);
                    }
                } else {
                    this.fillLists(data, false, 3, index);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error occurred while loading resource {}. {}", (Object)id.toString(), (Object)e.toString());
            }
        });
        this.sortAndFillLists(this.levelList, this.objectList, 4);
        LevelLoader.addAllInOneList();
    }

    private void fillLists(JsonObject data, boolean addToExisting, int type, int index) {
        ArrayList<Integer> idList = new ArrayList<Integer>();
        if (type == 1) {
            for (i = 0; i < data.getAsJsonArray("block").size(); ++i) {
                if (data.getAsJsonArray("block").get(i).getAsString().contains("#")) {
                    LOGGER.info("{} might be a block tag but tags are not supported (yet?)", (Object)data.getAsJsonArray("block").get(i).getAsString());
                    continue;
                }
                if (((class_2248)class_2378.field_11146.method_10223(new class_2960(data.getAsJsonArray("block").get(i).getAsString()))).toString().equals("Block{minecraft:air}")) {
                    LOGGER.info("{} is not a valid block identifier", (Object)data.getAsJsonArray("block").get(i).getAsString());
                    continue;
                }
                idList.add(class_2378.field_11146.method_10206((Object)((class_2248)class_2378.field_11146.method_10223(new class_2960(data.getAsJsonArray("block").get(i).getAsString())))));
            }
        } else if (type == 2 || type == 3) {
            for (i = 0; i < data.getAsJsonArray("item").size(); ++i) {
                if (((class_1792)class_2378.field_11142.method_10223(new class_2960(data.getAsJsonArray("item").get(i).getAsString()))).toString().equals("air")) {
                    LOGGER.info("{} is not a valid item identifier", (Object)data.getAsJsonArray("item").get(i).getAsString());
                    continue;
                }
                idList.add(class_2378.field_11142.method_10206((Object)((class_1792)class_2378.field_11142.method_10223(new class_2960(data.getAsJsonArray("item").get(i).getAsString())))));
            }
        }
        if (addToExisting) {
            if (index == -1) {
                index = this.levelList.indexOf(data.get("level").getAsInt());
            }
            for (int u = 0; u < idList.size(); ++u) {
                this.objectList.get(index).add((Integer)idList.get(u));
            }
        } else {
            if (type == 3) {
                this.skillList.add(data.get("skill").getAsString());
            }
            this.levelList.add(data.get("level").getAsInt());
            this.objectList.add(idList);
            this.replaceList.add(class_3518.method_15258((JsonObject)data, (String)"replace", (boolean)false));
        }
    }

    private void sortAndFillLists(List<Integer> levelList, List<List<Integer>> objectList, int type) {
        this.replaceList.clear();
        if (type != 0) {
            if (type == 1) {
                LevelLists.miningLevelList.addAll(levelList);
                LevelLists.miningLevelList.sort(Comparator.naturalOrder());
                for (int i = 0; i < levelList.size(); ++i) {
                    LevelLists.miningBlockList.add(i, objectList.get(levelList.indexOf(LevelLists.miningLevelList.get(i))));
                }
            } else if (type == 2) {
                LevelLists.brewingLevelList.addAll(levelList);
                LevelLists.brewingLevelList.sort(Comparator.naturalOrder());
                for (int i = 0; i < levelList.size(); ++i) {
                    LevelLists.brewingItemList.add(i, objectList.get(levelList.indexOf(LevelLists.brewingLevelList.get(i))));
                }
            } else if (type == 3) {
                LevelLists.smithingLevelList.addAll(levelList);
                LevelLists.smithingLevelList.sort(Comparator.naturalOrder());
                for (int i = 0; i < levelList.size(); ++i) {
                    LevelLists.smithingItemList.add(i, objectList.get(levelList.indexOf(LevelLists.smithingLevelList.get(i))));
                }
            } else if (type == 4) {
                LevelLists.craftingLevelList.addAll(levelList);
                LevelLists.craftingSkillList.addAll(this.skillList);
                LevelLists.craftingItemList.addAll(objectList);
                SortList.concurrentSort(LevelLists.craftingLevelList, (List[])new List[]{LevelLists.craftingLevelList, LevelLists.craftingSkillList, LevelLists.craftingItemList});
                this.skillList.clear();
            }
            this.objectList.clear();
            this.levelList.clear();
        }
    }

    public static void addAllInOneList() {
        LevelLists.listOfAllLists.add(LevelLists.anvilList);
        LevelLists.listOfAllLists.add(LevelLists.armorList);
        LevelLists.listOfAllLists.add(LevelLists.axeList);
        LevelLists.listOfAllLists.add(LevelLists.barrelList);
        LevelLists.listOfAllLists.add(LevelLists.beehiveList);
        LevelLists.listOfAllLists.add(LevelLists.blastFurnaceList);
        LevelLists.listOfAllLists.add(LevelLists.bowList);
        LevelLists.listOfAllLists.add(LevelLists.brewingStandList);
        LevelLists.listOfAllLists.add(LevelLists.bucketList);
        LevelLists.listOfAllLists.add(LevelLists.cartographyList);
        LevelLists.listOfAllLists.add(LevelLists.cauldronList);
        LevelLists.listOfAllLists.add(LevelLists.composterList);
        LevelLists.listOfAllLists.add(LevelLists.cowList);
        LevelLists.listOfAllLists.add(LevelLists.crossbowList);
        LevelLists.listOfAllLists.add(LevelLists.dragonBreathList);
        LevelLists.listOfAllLists.add(LevelLists.elytraList);
        LevelLists.listOfAllLists.add(LevelLists.enchantingTableList);
        LevelLists.listOfAllLists.add(LevelLists.fishingList);
        LevelLists.listOfAllLists.add(LevelLists.flintAndSteelList);
        LevelLists.listOfAllLists.add(LevelLists.grindstoneList);
        LevelLists.listOfAllLists.add(LevelLists.hoeList);
        LevelLists.listOfAllLists.add(LevelLists.lecternList);
        LevelLists.listOfAllLists.add(LevelLists.loomList);
        LevelLists.listOfAllLists.add(LevelLists.mooshroomList);
        LevelLists.listOfAllLists.add(LevelLists.pumpkinList);
        LevelLists.listOfAllLists.add(LevelLists.sheepList);
        LevelLists.listOfAllLists.add(LevelLists.shieldList);
        LevelLists.listOfAllLists.add(LevelLists.smithingTableList);
        LevelLists.listOfAllLists.add(LevelLists.smokerList);
        LevelLists.listOfAllLists.add(LevelLists.snowGolemList);
        LevelLists.listOfAllLists.add(LevelLists.stonecutterList);
        LevelLists.listOfAllLists.add(LevelLists.swordList);
        LevelLists.listOfAllLists.add(LevelLists.toolList);
        LevelLists.listOfAllLists.add(LevelLists.totemList);
        LevelLists.listOfAllLists.add(LevelLists.tridentList);
        LevelLists.listOfAllLists.add(LevelLists.villagerList);
        LevelLists.listOfAllLists.add(LevelLists.wanderingTraderList);
        LevelLists.listOfAllLists.add(LevelLists.wolfList);
        LevelLists.listOfAllLists.add(LevelLists.breedingList);
        LevelLists.listOfAllLists.add(LevelLists.furnaceList);
        LevelLists.listOfAllLists.add(LevelLists.beaconList);
        LevelLists.listOfAllLists.add(LevelLists.axolotlList);
        LevelLists.listOfAllLists.add(LevelLists.piglinList);
        LevelLists.listOfAllLists.add(LevelLists.shearsList);
        LevelLists.listOfAllLists.add(LevelLists.tadpoleList);
        LevelLists.listOfAllLists.add(LevelLists.allayList);
        LevelLists.listOfAllLists.add(LevelLists.compassList);
        LevelLists.listOfAllLists.add(LevelLists.goatList);
        LevelLists.listOfAllLists.add(LevelLists.craftingTableList);
        LevelLists.listOfAllLists.add(LevelLists.fletchingTableList);
        LevelLists.listOfAllLists.add(LevelLists.customBlockList);
        LevelLists.listOfAllLists.add(LevelLists.customItemList);
        LevelLists.listOfAllLists.add(LevelLists.customEntityList);
    }

    public static void clearEveryList() {
        LevelLists.anvilList.clear();
        LevelLists.armorList.clear();
        LevelLists.axeList.clear();
        LevelLists.barrelList.clear();
        LevelLists.beehiveList.clear();
        LevelLists.blastFurnaceList.clear();
        LevelLists.bowList.clear();
        LevelLists.brewingStandList.clear();
        LevelLists.bucketList.clear();
        LevelLists.cartographyList.clear();
        LevelLists.cauldronList.clear();
        LevelLists.composterList.clear();
        LevelLists.cowList.clear();
        LevelLists.crossbowList.clear();
        LevelLists.dragonBreathList.clear();
        LevelLists.elytraList.clear();
        LevelLists.enchantingTableList.clear();
        LevelLists.fishingList.clear();
        LevelLists.flintAndSteelList.clear();
        LevelLists.grindstoneList.clear();
        LevelLists.hoeList.clear();
        LevelLists.lecternList.clear();
        LevelLists.loomList.clear();
        LevelLists.mooshroomList.clear();
        LevelLists.pumpkinList.clear();
        LevelLists.sheepList.clear();
        LevelLists.shieldList.clear();
        LevelLists.smithingTableList.clear();
        LevelLists.smokerList.clear();
        LevelLists.snowGolemList.clear();
        LevelLists.stonecutterList.clear();
        LevelLists.swordList.clear();
        LevelLists.toolList.clear();
        LevelLists.totemList.clear();
        LevelLists.tridentList.clear();
        LevelLists.villagerList.clear();
        LevelLists.wanderingTraderList.clear();
        LevelLists.wolfList.clear();
        LevelLists.breedingList.clear();
        LevelLists.furnaceList.clear();
        LevelLists.beaconList.clear();
        LevelLists.axolotlList.clear();
        LevelLists.piglinList.clear();
        LevelLists.shearsList.clear();
        LevelLists.tadpoleList.clear();
        LevelLists.allayList.clear();
        LevelLists.compassList.clear();
        LevelLists.goatList.clear();
        LevelLists.craftingTableList.clear();
        LevelLists.fletchingTableList.clear();
        LevelLists.customBlockList.clear();
        LevelLists.customItemList.clear();
        LevelLists.customEntityList.clear();
        LevelLists.miningBlockList.clear();
        LevelLists.miningLevelList.clear();
        LevelLists.brewingItemList.clear();
        LevelLists.brewingLevelList.clear();
        LevelLists.smithingItemList.clear();
        LevelLists.smithingLevelList.clear();
        LevelLists.craftingItemList.clear();
        LevelLists.craftingLevelList.clear();
        LevelLists.craftingSkillList.clear();
    }
}

