/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.polymorph.server;

import com.illusivesoulworks.polymorph.PolymorphConstants;
import com.illusivesoulworks.polymorph.mixin.core.AccessorUpgradeRecipe;
import com.illusivesoulworks.polymorph.platform.Services;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3956;

public class PolymorphCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        int opPermissionLevel = 2;
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)class_2170.method_9247((String)"polymorph").requires(player -> player.method_9259(2));
        command.then(class_2170.method_9247((String)"conflicts").executes(context -> PolymorphCommands.findConflicts((class_2168)context.getSource())));
        dispatcher.register(command);
    }

    private static int findConflicts(class_2168 source) {
        CompletableFuture.runAsync(() -> {
            source.method_9226((class_2561)class_2561.method_43471((String)"commands.polymorph.conflicts.starting"), true);
            class_3218 world = source.method_9225();
            class_1863 recipeManager = world.method_8433();
            ArrayList<String> output = new ArrayList<String>();
            int count = 0;
            count += PolymorphCommands.scanRecipes(class_3956.field_17545, output, recipeManager, CraftingRecipeWrapper::new);
            count += PolymorphCommands.scanRecipes(class_3956.field_17546, output, recipeManager, RecipeWrapper::new);
            count += PolymorphCommands.scanRecipes(class_3956.field_17547, output, recipeManager, RecipeWrapper::new);
            count += PolymorphCommands.scanRecipes(class_3956.field_17548, output, recipeManager, RecipeWrapper::new);
            if ((count += PolymorphCommands.scanRecipes(class_3956.field_25388, output, recipeManager, SmithingRecipeWrapper::new)) > 0) {
                try {
                    Files.write(Paths.get(Services.PLATFORM.getGameDir() + "/logs/conflicts.log", new String[0]), output, StandardCharsets.UTF_8, new OpenOption[0]);
                }
                catch (IOException e) {
                    PolymorphConstants.LOG.error("Whoops! Something went wrong writing down your conflicts :(");
                    e.printStackTrace();
                }
            }
            source.method_9226((class_2561)class_2561.method_43469((String)"commands.polymorph.conflicts.success", (Object[])new Object[]{count}), true);
        });
        return 1;
    }

    private static <C extends class_1263, T extends class_1860<C>> int scanRecipes(class_3956<T> pType, List<String> pOutput, class_1863 pRecipeManager, Function<class_1860<?>, RecipeWrapper> pFactory) {
        Collection recipes = pRecipeManager.method_30027(pType).stream().map(pFactory).collect(Collectors.toList());
        ArrayList conflicts = new ArrayList();
        TreeSet<class_2960> skipped = new TreeSet<class_2960>();
        HashSet<class_2960> processed = new HashSet<class_2960>();
        for (RecipeWrapper recipe : recipes) {
            class_2960 class_29602 = recipe.getId();
            if (processed.contains(class_29602)) continue;
            processed.add(class_29602);
            if (recipe.getRecipe() instanceof class_1852) {
                skipped.add(class_29602);
                continue;
            }
            TreeSet<class_2960> currentGroup = new TreeSet<class_2960>();
            for (RecipeWrapper otherRecipe : recipes) {
                if (processed.contains(otherRecipe.getId()) || !otherRecipe.conflicts(recipe)) continue;
                currentGroup.add(class_29602);
                currentGroup.add(otherRecipe.getId());
                processed.add(otherRecipe.getId());
            }
            if (currentGroup.isEmpty()) continue;
            conflicts.add(currentGroup);
        }
        pOutput.add("===================================================================");
        pOutput.add(class_2378.field_17597.method_10221(pType) + " recipe conflicts (" + conflicts.size() + ")");
        pOutput.add("===================================================================");
        pOutput.add("");
        int count = 1;
        for (Set set : conflicts) {
            StringJoiner joiner = new StringJoiner(", ");
            set.stream().map(class_2960::toString).forEach(joiner::add);
            pOutput.add(count + ": " + joiner);
            pOutput.add("");
            ++count;
        }
        if (skipped.size() > 0) {
            pOutput.add("Skipped special recipes: ");
            for (class_2960 class_29603 : skipped) {
                pOutput.add(class_29603.toString());
            }
            pOutput.add("");
        }
        return conflicts.size();
    }

    private static class RecipeWrapper {
        private final class_1860<?> recipe;
        private final List<IngredientWrapper> ingredients;

        private RecipeWrapper(class_1860<?> pRecipe) {
            this.recipe = pRecipe;
            this.ingredients = new ArrayList<IngredientWrapper>();
            for (class_1856 ingredient : this.recipe.method_8117()) {
                IngredientWrapper wrapped = new IngredientWrapper(ingredient);
                this.ingredients.add(wrapped);
            }
        }

        public class_1860<?> getRecipe() {
            return this.recipe;
        }

        public class_2960 getId() {
            return this.recipe.method_8114();
        }

        public List<IngredientWrapper> getIngredients() {
            return this.ingredients;
        }

        public boolean conflicts(RecipeWrapper pOther) {
            if (pOther == null) {
                return false;
            }
            if (this.getId().equals((Object)pOther.getId())) {
                return true;
            }
            if (this.ingredients.size() != pOther.getIngredients().size()) {
                return false;
            }
            List<IngredientWrapper> otherIngredients = pOther.getIngredients();
            for (int i = 0; i < otherIngredients.size(); ++i) {
                if (otherIngredients.get(i).matches(this.getIngredients().get(i))) continue;
                return false;
            }
            return true;
        }
    }

    private static class CraftingRecipeWrapper
    extends RecipeWrapper {
        private final boolean shaped;

        private CraftingRecipeWrapper(class_1860<?> recipe) {
            super(recipe);
            this.shaped = Services.PLATFORM.isShaped(recipe);
        }

        public boolean isShaped() {
            return this.shaped;
        }

        @Override
        public boolean conflicts(RecipeWrapper pOther) {
            return super.conflicts(pOther) && this.isSameShape((CraftingRecipeWrapper)pOther);
        }

        private boolean isSameShape(CraftingRecipeWrapper other) {
            if (this.shaped && other.isShaped()) {
                return Services.PLATFORM.isSameShape(this.getRecipe(), other.getRecipe());
            }
            return true;
        }
    }

    private static class SmithingRecipeWrapper
    extends RecipeWrapper {
        private SmithingRecipeWrapper(class_1860<?> pRecipe) {
            super(pRecipe);
        }

        @Override
        public boolean conflicts(RecipeWrapper pOther) {
            AccessorUpgradeRecipe smithingRecipe = (AccessorUpgradeRecipe)this.getRecipe();
            AccessorUpgradeRecipe otherSmithingRecipe = (AccessorUpgradeRecipe)pOther.getRecipe();
            IngredientWrapper baseWrapper = new IngredientWrapper(smithingRecipe.getBase());
            IngredientWrapper otherBaseWrapper = new IngredientWrapper(otherSmithingRecipe.getBase());
            IngredientWrapper additionWrapper = new IngredientWrapper(smithingRecipe.getAddition());
            IngredientWrapper otherAdditionWrapper = new IngredientWrapper(otherSmithingRecipe.getAddition());
            return super.conflicts(pOther) && baseWrapper.matches(otherBaseWrapper) & additionWrapper.matches(otherAdditionWrapper);
        }
    }

    private static class IngredientWrapper {
        private final class_1856 ingredient;

        private IngredientWrapper(class_1856 pIngredient) {
            this.ingredient = pIngredient;
        }

        public class_1856 getIngredient() {
            return this.ingredient;
        }

        public boolean matches(IngredientWrapper pIngredient) {
            if (pIngredient == null) {
                return false;
            }
            class_1856 otherIngredient = pIngredient.getIngredient();
            if (otherIngredient == null) {
                return false;
            }
            if (otherIngredient == class_1856.field_9017) {
                return this.ingredient == class_1856.field_9017;
            }
            class_1799[] stacks = this.ingredient.method_8105();
            for (class_1799 otherStack : pIngredient.getIngredient().method_8105()) {
                for (class_1799 stack : stacks) {
                    if (!class_1799.method_7973((class_1799)stack, (class_1799)otherStack)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

