/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.polymorph.common.components;

import com.illusivesoulworks.polymorph.common.components.AbstractBlockEntityRecipeDataComponent;
import com.illusivesoulworks.polymorph.common.components.AbstractStackRecipeDataComponent;
import com.illusivesoulworks.polymorph.common.components.FurnaceRecipeDataComponent;
import com.illusivesoulworks.polymorph.common.components.PlayerRecipeDataComponent;
import dev.onyxstudios.cca.api.v3.block.BlockComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.block.BlockComponentInitializer;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentRegistry;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentInitializer;
import dev.onyxstudios.cca.api.v3.item.ItemComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.item.ItemComponentInitializer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2586;
import net.minecraft.class_2609;
import net.minecraft.class_2960;

public class PolymorphFabricComponents
implements BlockComponentInitializer,
EntityComponentInitializer,
ItemComponentInitializer {
    public static final ComponentKey<PlayerRecipeDataComponent> PLAYER_RECIPE_DATA = ComponentRegistry.getOrCreate((class_2960)new class_2960("polymorph", "player_recipe_data"), PlayerRecipeDataComponent.class);
    public static final ComponentKey<AbstractBlockEntityRecipeDataComponent> BLOCK_ENTITY_RECIPE_DATA = ComponentRegistry.getOrCreate((class_2960)new class_2960("polymorph", "block_entity_recipe_data"), AbstractBlockEntityRecipeDataComponent.class);
    public static final ComponentKey<AbstractStackRecipeDataComponent> STACK_RECIPE_DATA = ComponentRegistry.getOrCreate((class_2960)new class_2960("polymorph", "stack_recipe_data"), AbstractStackRecipeDataComponent.class);
    private static final Map<class_1792, Function<class_1799, AbstractStackRecipeDataComponent>> ITEM_2_RECIPE_DATA = new HashMap<class_1792, Function<class_1799, AbstractStackRecipeDataComponent>>();
    private static final Map<Class<? extends class_2586>, Function<class_2586, AbstractBlockEntityRecipeDataComponent<?>>> BLOCK_ENTITY_2_RECIPE_DATA = new HashMap();

    public static void setup() {
        PolymorphFabricComponents.registerBlockEntity(class_2609.class, blockEntity -> new FurnaceRecipeDataComponent((class_2609)blockEntity));
    }

    public static void registerBlockEntity(Class<? extends class_2586> blockEntityClass, Function<class_2586, AbstractBlockEntityRecipeDataComponent<?>> blockEntity2RecipeData) {
        BLOCK_ENTITY_2_RECIPE_DATA.put(blockEntityClass, blockEntity2RecipeData);
    }

    public static void registerItem(class_1792 item, Function<class_1799, AbstractStackRecipeDataComponent> stack2RecipeData) {
        ITEM_2_RECIPE_DATA.put(item, stack2RecipeData);
    }

    public void registerBlockComponentFactories(@Nonnull BlockComponentFactoryRegistry registry) {
        for (Map.Entry<Class<class_2586>, Function<class_2586, AbstractBlockEntityRecipeDataComponent<?>>> entry : BLOCK_ENTITY_2_RECIPE_DATA.entrySet()) {
            registry.registerFor(entry.getKey(), BLOCK_ENTITY_RECIPE_DATA, blockEntity -> (AbstractBlockEntityRecipeDataComponent)((Function)entry.getValue()).apply(blockEntity));
        }
    }

    public void registerEntityComponentFactories(EntityComponentFactoryRegistry registry) {
        registry.registerFor(class_1657.class, PLAYER_RECIPE_DATA, PlayerRecipeDataComponent::new);
    }

    public void registerItemComponentFactories(@Nonnull ItemComponentFactoryRegistry registry) {
        for (Map.Entry<class_1792, Function<class_1799, AbstractStackRecipeDataComponent>> entry : ITEM_2_RECIPE_DATA.entrySet()) {
            registry.register(entry.getKey(), STACK_RECIPE_DATA, stack -> (AbstractStackRecipeDataComponent)((Function)entry.getValue()).apply(stack));
        }
    }
}

