/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.polymorph.api.client.widget;

import com.illusivesoulworks.polymorph.api.client.widget.OutputWidget;
import com.illusivesoulworks.polymorph.api.common.base.IRecipePair;
import com.illusivesoulworks.polymorph.platform.Services;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.class_1159;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4587;
import net.minecraft.class_465;

public class SelectionWidget
extends class_332
implements class_4068,
class_364 {
    private final Consumer<class_2960> onSelect;
    private final class_465<?> containerScreen;
    private final List<OutputWidget> outputWidgets = new ArrayList<OutputWidget>();
    private int xOffset;
    private int yOffset;
    private OutputWidget hoveredButton;
    private boolean active = false;
    private int x;
    private int y;
    private int lastX;
    private int lastY;

    public SelectionWidget(int x, int y, int xOffset, int yOffset, Consumer<class_2960> onSelect, class_465<?> containerScreen) {
        this.setPosition(x, y);
        this.onSelect = onSelect;
        this.containerScreen = containerScreen;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
        this.updateButtonPositions();
    }

    public void setOffsets(int x, int y) {
        this.xOffset = x;
        this.yOffset = y;
    }

    public void highlightButton(class_2960 resourceLocation) {
        this.outputWidgets.forEach(widget -> widget.setHighlighted(widget.getResourceLocation().equals((Object)resourceLocation)));
    }

    private void updateButtonPositions() {
        int size = this.outputWidgets.size();
        int xOffset = (int)(-25.0 * Math.floor((float)size / 2.0f));
        if (size % 2 == 0) {
            xOffset += 13;
        }
        int[] pos = new int[]{this.x + xOffset, this.y};
        this.outputWidgets.forEach(widget -> {
            widget.setPosition(pos[0], pos[1]);
            pos[0] = pos[0] + 25;
        });
    }

    public List<OutputWidget> getOutputWidgets() {
        return this.outputWidgets;
    }

    public void setRecipeList(Set<IRecipePair> recipeList) {
        this.outputWidgets.clear();
        recipeList.forEach(data -> {
            if (!data.getOutput().method_7960()) {
                this.outputWidgets.add(new OutputWidget((IRecipePair)data));
            }
        });
        this.updateButtonPositions();
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public void renderTooltip(class_4587 poseStack, int mouseX, int mouseY) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1755 != null && this.hoveredButton != null) {
            this.renderTooltip(this.hoveredButton.getOutput(), poseStack, this.hoveredButton.getTooltipText(mc.field_1755), mouseX, mouseY);
        }
    }

    public void method_25394(@Nonnull class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.isActive()) {
            int x = Services.CLIENT_PLATFORM.getScreenLeft(this.containerScreen) + this.xOffset;
            int y = Services.CLIENT_PLATFORM.getScreenTop(this.containerScreen) + this.yOffset;
            if (this.lastX != x || this.lastY != y) {
                this.setPosition(x, y);
                this.lastX = x;
                this.lastY = y;
            }
            this.hoveredButton = null;
            this.outputWidgets.forEach(button -> {
                button.method_25394(poseStack, mouseX, mouseY, partialTicks);
                if (button.field_22764 && button.method_25367()) {
                    this.hoveredButton = button;
                }
            });
            this.renderTooltip(poseStack, mouseX, mouseY);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.isActive()) {
            for (OutputWidget widget : this.outputWidgets) {
                if (!widget.method_25402(mouseX, mouseY, button)) continue;
                this.onSelect.accept(widget.getResourceLocation());
                return true;
            }
        }
        return false;
    }

    public void renderTooltip(class_1799 stack, class_4587 poseStack, List<class_2561> text, int mouseX, int mouseY) {
        Services.CLIENT_PLATFORM.renderTooltip(stack, poseStack, text, mouseX, mouseY, this.containerScreen, class_310.method_1551().field_1772, (x$0, x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8) -> class_332.method_27533((class_1159)x$0, (class_287)x$1, (int)x$2, (int)x$3, (int)x$4, (int)x$5, (int)x$6, (int)x$7, (int)x$8));
    }

    public static interface GradientDrawer {
        public void fillGradient(class_1159 var1, class_287 var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);
    }
}

