/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui;

import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.CursorType;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.WrappedIngredient;
import net.minecraft.class_2561;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

public abstract class Button
extends Widget {
    protected class_2561 title;
    protected Icon icon;

    public Button(Panel panel, class_2561 t, Icon i) {
        super(panel);
        this.setSize(16, 16);
        this.icon = i;
        this.title = t;
    }

    public Button(Panel panel) {
        this(panel, (class_2561)class_2561.method_43473(), Color4I.EMPTY);
    }

    @Override
    public class_2561 getTitle() {
        return this.title;
    }

    public Button setTitle(class_2561 s) {
        this.title = s;
        return this;
    }

    public Button setIcon(Icon i) {
        this.icon = i;
        return this;
    }

    public void drawBackground(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
        theme.drawButton(matrixStack, x, y, w, h, this.getWidgetType());
    }

    public void drawIcon(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
        this.icon.draw(matrixStack, x, y, w, h);
    }

    @Override
    public void draw(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
        GuiHelper.setupDrawing();
        int s = h >= 16 ? 16 : 8;
        this.drawBackground(matrixStack, theme, x, y, w, h);
        this.drawIcon(matrixStack, theme, x + (w - s) / 2, y + (h - s) / 2, s, s);
    }

    @Override
    public boolean mousePressed(MouseButton button) {
        if (this.isMouseOver()) {
            if (this.getWidgetType() != WidgetType.DISABLED) {
                this.onClicked(button);
            }
            return true;
        }
        return false;
    }

    public abstract void onClicked(MouseButton var1);

    @Override
    @Nullable
    public Object getIngredientUnderMouse() {
        return new WrappedIngredient(this.icon.getIngredient()).tooltip();
    }

    @Override
    public CursorType getCursor() {
        return CursorType.HAND;
    }
}

