/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity;

import io.netty.buffer.Unpooled;
import java.util.Optional;
import java.util.UUID;
import net.adventurez.entity.goal.DragonFindOwnerGoal;
import net.adventurez.entity.goal.DragonFlyRandomlyGoal;
import net.adventurez.entity.goal.DragonSitGoal;
import net.adventurez.entity.nonliving.FireBreathEntity;
import net.adventurez.init.ConfigInit;
import net.adventurez.init.ItemInit;
import net.adventurez.init.SoundInit;
import net.adventurez.mixin.accessor.LivingEntityAccessor;
import net.adventurez.network.GeneralPacket;
import net.adventurez.network.KeybindPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1306;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1657;
import net.minecraft.class_1707;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2680;
import net.minecraft.class_2817;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3321;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_3730;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5275;
import net.minecraft.class_5425;
import net.minecraft.class_6025;
import net.minecraft.class_746;
import net.minecraft.class_747;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class DragonEntity
extends class_1314
implements class_1265,
class_6025 {
    public static final class_2940<Boolean> IS_FLYING = class_2945.method_12791(DragonEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> IS_START_FLYING = class_2945.method_12791(DragonEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> CLIENT_START_FLYING = class_2945.method_12791(DragonEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> CLIENT_END_FLYING = class_2945.method_12791(DragonEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Byte> TAMEABLE_FLAGS = class_2945.method_12791(DragonEntity.class, (class_2941)class_2943.field_13319);
    public static final class_2940<Optional<UUID>> OWNER_UUID = class_2945.method_12791(DragonEntity.class, (class_2941)class_2943.field_13313);
    public static final class_2940<Boolean> HAS_SADDLE = class_2945.method_12791(DragonEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> HAS_CHEST = class_2945.method_12791(DragonEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> OTHER_EARS = class_2945.method_12791(DragonEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> OTHER_TAIL = class_2945.method_12791(DragonEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> OTHER_EYES = class_2945.method_12791(DragonEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Integer> DRAGON_SIZE = class_2945.method_12791(DragonEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Boolean> FIRE_BREATH = class_2945.method_12791(DragonEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> RED_DRAGON = class_2945.method_12791(DragonEntity.class, (class_2941)class_2943.field_13323);
    private boolean sitting;
    public boolean isFlying;
    private int startFlyingTimer = 0;
    private float dragonSideSpeed = 0.0f;
    private float dragonForwardSpeed = 0.0f;
    public int keyBind = 342;
    private float turningFloat;
    private boolean hasSaddle;
    private int healingFood;
    private class_1277 inventory;
    private int onGroundTicker;
    private int dragonAge;
    private int dragonAgeFoodBonus;
    private int fireBreathCooldown;
    public boolean fireBreathActive;
    private int startFlyingTime = 0;
    private int fluidTicker = 0;

    public DragonEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6013 = 1.0f;
        this.onChestedStatusChanged();
    }

    public static class_5132.class_5133 createDragonAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 60.0).method_26868(class_5134.field_23721, 9.0).method_26868(class_5134.field_23719, 0.28).method_26868(class_5134.field_23724, 6.0).method_26868(class_5134.field_23718, 0.5);
    }

    public void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new DragonSitGoal(this));
        this.field_6201.method_6277(2, (class_1352)new DragonFindOwnerGoal(this, 0.1, 10.0f, 2.0f));
        this.field_6201.method_6277(3, (class_1352)new DragonFlyRandomlyGoal(this));
        this.field_6201.method_6277(4, (class_1352)new class_1379((class_1314)this, 0.9));
        this.field_6201.method_6277(5, (class_1352)new class_1361((class_1308)this, class_1657.class, 10.0f, 0.8f));
        this.field_6201.method_6277(6, (class_1352)new class_1376((class_1308)this));
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(TAMEABLE_FLAGS, (Object)0);
        this.field_6011.method_12784(OWNER_UUID, Optional.empty());
        this.field_6011.method_12784(IS_FLYING, (Object)false);
        this.field_6011.method_12784(CLIENT_END_FLYING, (Object)false);
        this.field_6011.method_12784(IS_START_FLYING, (Object)false);
        this.field_6011.method_12784(CLIENT_START_FLYING, (Object)false);
        this.field_6011.method_12784(HAS_SADDLE, (Object)false);
        this.field_6011.method_12784(HAS_CHEST, (Object)false);
        this.field_6011.method_12784(OTHER_EARS, (Object)false);
        this.field_6011.method_12784(OTHER_TAIL, (Object)false);
        this.field_6011.method_12784(OTHER_EYES, (Object)false);
        this.field_6011.method_12784(DRAGON_SIZE, (Object)1);
        this.field_6011.method_12784(FIRE_BREATH, (Object)false);
        this.field_6011.method_12784(RED_DRAGON, (Object)false);
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        if (this.method_6139() != null) {
            tag.method_25927("DragonOwner", this.method_6139());
        }
        tag.method_10556("IsFlying", this.isFlying);
        tag.method_10556("SittingDragon", this.sitting);
        tag.method_10556("HasSaddle", this.hasSaddle);
        tag.method_10556("HasChest", this.hasChest());
        if (this.hasChest()) {
            class_2499 listTag = new class_2499();
            for (int i = 0; i < this.inventory.method_5439(); ++i) {
                class_1799 itemStack = this.inventory.method_5438(i);
                if (itemStack.method_7960()) continue;
                class_2487 compoundTag = new class_2487();
                compoundTag.method_10567("Slot", (byte)i);
                itemStack.method_7953(compoundTag);
                listTag.add((Object)compoundTag);
            }
            tag.method_10566("Items", (class_2520)listTag);
        }
        tag.method_10569("DragonSize", this.getSize());
        tag.method_10556("OtherDragonEars", ((Boolean)this.method_5841().method_12789(OTHER_EARS)).booleanValue());
        tag.method_10556("OtherDragonTail", ((Boolean)this.method_5841().method_12789(OTHER_TAIL)).booleanValue());
        tag.method_10556("OtherDragonEyes", ((Boolean)this.method_5841().method_12789(OTHER_EYES)).booleanValue());
        tag.method_10556("RedDragon", ((Boolean)this.method_5841().method_12789(RED_DRAGON)).booleanValue());
        tag.method_10569("DragonAge", this.dragonAge);
        tag.method_10569("StartFlyingTime", this.startFlyingTime);
    }

    public void method_5749(class_2487 tag) {
        UUID uUID2;
        super.method_5749(tag);
        if (tag.method_25928("DragonOwner")) {
            uUID2 = tag.method_25926("DragonOwner");
        } else {
            String string = tag.method_10558("DragonOwner");
            uUID2 = class_3321.method_14546((MinecraftServer)this.method_5682(), (String)string);
        }
        if (uUID2 != null) {
            try {
                this.setOwnerUuid(uUID2);
                this.setTamed(true);
            }
            catch (Throwable var4) {
                this.setTamed(false);
            }
        }
        this.isFlying = tag.method_10577("IsFlying");
        this.field_6011.method_12778(IS_FLYING, (Object)this.isFlying);
        this.sitting = tag.method_10577("SittingDragon");
        this.setSitting(this.sitting);
        this.hasSaddle = tag.method_10577("HasSaddle");
        this.field_6011.method_12778(HAS_SADDLE, (Object)this.hasSaddle);
        this.setHasChest(tag.method_10577("HasChest"));
        if (this.hasChest()) {
            class_2499 listTag = tag.method_10554("Items", 10);
            this.onChestedStatusChanged();
            for (int i = 0; i < listTag.size(); ++i) {
                class_2487 compoundTag = listTag.method_10602(i);
                int j = compoundTag.method_10571("Slot") & 0xFF;
                if (j < 0 || j >= this.inventory.method_5439()) continue;
                this.inventory.method_5447(j, class_1799.method_7915((class_2487)compoundTag));
            }
        }
        this.setSize(tag.method_10550("DragonSize"));
        this.field_6011.method_12778(OTHER_EARS, (Object)tag.method_10577("OtherDragonEars"));
        this.field_6011.method_12778(OTHER_TAIL, (Object)tag.method_10577("OtherDragonTail"));
        this.field_6011.method_12778(OTHER_EYES, (Object)tag.method_10577("OtherDragonEyes"));
        this.field_6011.method_12778(RED_DRAGON, (Object)tag.method_10577("RedDragon"));
        this.dragonAge = tag.method_10550("DragonAge");
        if (this.isFlying) {
            this.startFlyingTime = tag.method_10550("StartFlyingTime");
        }
    }

    public void method_6091(class_243 movementInput) {
        if (this.method_5805()) {
            if (this.method_5782() && this.canBeControlledByRider()) {
                class_1309 livingEntity = (class_1309)this.method_5642();
                double wrapper = class_3532.method_15338((double)((double)this.field_6283 - (double)this.method_36454()));
                this.method_36456((float)((double)this.method_36454() + wrapper));
                this.field_5982 = this.method_36454();
                this.method_36457(livingEntity.method_36455() * 0.5f);
                this.method_5710(this.method_36454(), this.method_36455());
                this.field_6241 = livingEntity.field_6241;
                boolean shouldFlyUp = false;
                boolean shouldFlyDown = false;
                shouldFlyUp = ((LivingEntityAccessor)livingEntity).jumping();
                if (this.field_6002.field_9236 && livingEntity instanceof class_746) {
                    class_746 clientPlayerEntity = (class_746)livingEntity;
                    shouldFlyDown = class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)this.keyBind);
                    if (clientPlayerEntity.field_3913.field_3908) {
                        this.turningFloat -= 0.05f;
                    }
                    if (!clientPlayerEntity.field_3913.field_3908 && this.turningFloat < 0.0f) {
                        this.turningFloat = 0.0f;
                    }
                    if (clientPlayerEntity.field_3913.field_3906) {
                        this.turningFloat += 0.05f;
                    }
                    if (!clientPlayerEntity.field_3913.field_3906 && this.turningFloat > 0.0f) {
                        this.turningFloat = 0.0f;
                    }
                }
                this.method_36456(ConfigInit.CONFIG.heavy_dragon_flight ? this.method_36454() + class_3532.method_15393((float)this.turningFloat) : livingEntity.method_36454());
                float f = livingEntity.field_6212 * 0.1f;
                float g = livingEntity.field_6250 * 0.5f;
                float flySpeed = 0.0f;
                float maxForwardSpeed = 0.6f;
                float maxSidewaysSpeed = 0.15f;
                if (this.dragonForwardSpeed < maxForwardSpeed && livingEntity.field_6250 > 0.0f || this.dragonForwardSpeed > maxForwardSpeed * -0.3f && livingEntity.field_6250 < 0.0f) {
                    this.dragonForwardSpeed += g * 0.04f;
                }
                if (this.dragonSideSpeed < maxSidewaysSpeed && livingEntity.field_6212 > 0.0f || this.dragonSideSpeed > maxSidewaysSpeed * -1.0f && livingEntity.field_6212 < 0.0f) {
                    this.dragonSideSpeed += f * 0.03f;
                }
                if (livingEntity.field_6212 == 0.0f) {
                    this.dragonSideSpeed *= 0.7f;
                }
                if (livingEntity.field_6250 == 0.0f) {
                    this.dragonForwardSpeed *= 0.7f;
                }
                if (shouldFlyUp && !this.isFlying && this.startFlyingTimer < 10) {
                    if (this.method_5799() && this.method_5861(class_3486.field_15517) > 0.5) {
                        if (!this.field_6002.field_9236 && this.method_31483() instanceof class_3222) {
                            class_2658 packet = new class_2658(GeneralPacket.VELOCITY_PACKET, new class_2540(Unpooled.buffer().writeInt(this.method_5628()).writeFloat(0.05f)));
                            ((class_3222)this.method_31483()).field_13987.method_14364((class_2596)packet);
                        }
                    } else {
                        ++this.startFlyingTimer;
                        this.method_5841().method_12778(CLIENT_START_FLYING, (Object)true);
                        this.method_5841().method_12778(IS_START_FLYING, (Object)true);
                    }
                }
                if (!shouldFlyUp && !this.isFlying && this.startFlyingTimer > 0) {
                    --this.startFlyingTimer;
                    this.method_5841().method_12778(IS_START_FLYING, (Object)false);
                }
                if (this.startFlyingTimer <= 0 && !this.isFlying || this.isFlying || ((Boolean)this.method_5841().method_12789(IS_FLYING)).booleanValue()) {
                    this.method_5841().method_12778(CLIENT_START_FLYING, (Object)false);
                }
                if (!(this.startFlyingTimer < 10 || this.isFlying && ((Boolean)this.method_5841().method_12789(IS_FLYING)).booleanValue())) {
                    this.isFlying = true;
                    this.method_5841().method_12778(IS_FLYING, (Object)true);
                    this.startFlyingTimer = 0;
                    this.startFlyingTime = (int)this.field_6002.method_8510();
                }
                if (this.isFlying && this.field_5952) {
                    ++this.onGroundTicker;
                    if (this.onGroundTicker > 3) {
                        this.onGroundTicker = 0;
                        this.isFlying = false;
                        this.method_5841().method_12778(IS_FLYING, (Object)false);
                        this.method_5841().method_12778(CLIENT_END_FLYING, (Object)true);
                    }
                }
                if ((this.isFlying || ((Boolean)this.method_5841().method_12789(IS_FLYING)).booleanValue()) && shouldFlyUp) {
                    flySpeed = 0.15f;
                }
                if ((this.isFlying || ((Boolean)this.method_5841().method_12789(IS_FLYING)).booleanValue()) && shouldFlyDown) {
                    flySpeed = -0.2f;
                }
                if ((this.isFlying || ((Boolean)this.method_5841().method_12789(IS_FLYING)).booleanValue()) && !shouldFlyDown && !shouldFlyUp) {
                    flySpeed *= 0.4f;
                }
                if (this.method_5787()) {
                    this.method_6125((float)this.method_26825(class_5134.field_23719));
                    if (!((Boolean)this.method_5841().method_12789(IS_FLYING)).booleanValue() && !this.isFlying || this.method_5799() && this.method_5861(class_3486.field_15517) > 0.2) {
                        super.method_6091(new class_243((double)f, movementInput.field_1351, (double)g));
                    } else {
                        class_243 vec3d = ConfigInit.CONFIG.heavy_dragon_flight ? new class_243((double)this.dragonSideSpeed, movementInput.field_1351 + (double)flySpeed, (double)this.dragonForwardSpeed) : new class_243((double)livingEntity.field_6212 * 0.7, movementInput.field_1351 + (double)flySpeed, (double)livingEntity.field_6250 * 0.7);
                        this.method_5724(0.05f, vec3d);
                        this.method_5784(class_1313.field_6308, this.method_18798());
                        this.method_18799(this.method_18798());
                    }
                } else if (livingEntity instanceof class_1657) {
                    this.method_18799(class_243.field_1353);
                }
                this.method_29242((class_1309)this, false);
            } else if (this.isFlying || ((Boolean)this.method_5841().method_12789(IS_FLYING)).booleanValue()) {
                this.method_5724(0.02f, movementInput);
                this.method_5784(class_1313.field_6308, this.method_18798());
                this.method_18799(this.method_18798().method_1021((double)0.91f));
                double wrapper = class_3532.method_15338((double)((double)this.field_6241 - (double)this.method_36454()));
                this.method_36456((float)((double)this.method_36454() + wrapper));
                class_2338 blockPos = this.method_24515().method_10087(2);
                if (this.field_6002.method_8320(blockPos).method_26212((class_1922)this.field_6002, blockPos)) {
                    this.method_18799(this.method_18798().method_1031(0.0, -0.005, 0.0));
                }
                if (this.field_5952) {
                    this.method_5841().method_12778(CLIENT_END_FLYING, (Object)true);
                    this.isFlying = false;
                    this.method_5841().method_12778(IS_FLYING, (Object)false);
                }
            } else {
                this.field_6281 = 0.02f;
                super.method_6091(movementInput);
            }
        }
        if (this.isFlying && this.startFlyingTime != 0 && (int)(this.field_6002.method_8510() - (long)this.startFlyingTime) % 25 == 0) {
            this.playWingFlapSound();
        }
    }

    private boolean canBeControlledByRider() {
        return this.method_5642() instanceof class_1309;
    }

    public boolean method_6101() {
        return false;
    }

    public boolean method_32316() {
        return false;
    }

    @Nullable
    public class_1297 method_5642() {
        return this.method_5685().isEmpty() ? null : (class_1297)this.method_5685().get(0);
    }

    @Nullable
    private class_243 method_27930(class_243 vec3d, class_1309 livingEntity) {
        double d = this.method_23317() + vec3d.field_1352;
        double e = this.method_5829().field_1322;
        double f = this.method_23321() + vec3d.field_1350;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        block0: for (class_4050 entityPose : livingEntity.method_24831()) {
            mutable.method_10102(d, e, f);
            double g = this.method_5829().field_1325 + 0.75;
            do {
                class_243 vec3d2;
                class_238 box;
                double h = this.field_6002.method_30347((class_2338)mutable);
                if ((double)mutable.method_10264() + h > g) continue block0;
                if (class_5275.method_27932((double)h) && class_5275.method_27933((class_1941)this.field_6002, (class_1309)livingEntity, (class_238)(box = livingEntity.method_24833(entityPose)).method_997(vec3d2 = new class_243(d, (double)mutable.method_10264() + h, f)))) {
                    livingEntity.method_18380(entityPose);
                    return vec3d2;
                }
                mutable.method_10098(class_2350.field_11036);
            } while (!((double)mutable.method_10264() >= g));
        }
        return null;
    }

    public class_243 method_24829(class_1309 passenger) {
        class_243 vec3d = DragonEntity.method_24826((double)this.method_17681(), (double)passenger.method_17681(), (float)(this.method_36454() + (passenger.method_6068() == class_1306.field_6183 ? 90.0f : -90.0f)));
        class_243 vec3d2 = this.method_27930(vec3d, passenger);
        if (vec3d2 != null) {
            return vec3d2;
        }
        class_243 vec3d3 = DragonEntity.method_24826((double)this.method_17681(), (double)passenger.method_17681(), (float)(this.method_36454() + (passenger.method_6068() == class_1306.field_6182 ? 90.0f : -90.0f)));
        class_243 vec3d4 = this.method_27930(vec3d3, passenger);
        return vec3d4 != null ? vec3d4 : this.method_19538();
    }

    private void putPlayerOnBack(class_1657 player) {
        if (!this.field_6002.field_9236) {
            player.method_36456(this.method_36454());
            player.method_36457(this.method_36455());
            player.method_5804((class_1297)this);
        }
    }

    public void dragonFireBreath() {
        if (this.fireBreathCooldown <= 60) {
            ++this.fireBreathCooldown;
            if (!this.field_6002.field_9236) {
                if (this.fireBreathCooldown == 1) {
                    this.field_6002.method_43129((class_1657)null, (class_1297)this, SoundInit.DRAGON_BREATH_EVENT, class_3419.field_15251, 1.0f, 1.0f);
                }
                if (this.fireBreathCooldown % 3 == 0) {
                    class_243 vec3d = this.method_5631(this.field_6004, this.field_6241);
                    class_243 otherVec3d = this.method_5631(this.field_6004, this.field_6283);
                    vec3d = vec3d.method_1019(otherVec3d);
                    FireBreathEntity fireBreathEntity = new FireBreathEntity(this.field_6002, (class_1309)this, vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
                    fireBreathEntity.method_5808(this.method_23317() + vec3d.field_1352 * 3.0, this.method_23318() + this.method_5829().method_17940() * 0.65 + (double)(this.method_36455() > 0.0f ? -this.method_36455() / 40.0f : -this.method_36455() / 80.0f), this.method_23321() + vec3d.field_1350 * 3.0, this.method_36454(), this.method_36455());
                    this.field_6002.method_8649((class_1297)fireBreathEntity);
                }
            } else if (!((Boolean)this.method_5841().method_12789(FIRE_BREATH)).booleanValue()) {
                this.method_5841().method_12778(FIRE_BREATH, (Object)true);
            }
        } else {
            this.fireBreathActive = false;
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        class_1792 item = itemStack.method_7909();
        if (!this.method_6109() && this.method_5782()) {
            return super.method_5992(player, hand);
        }
        if (this.field_6002.field_9236) {
            boolean bl = this.isOwner((class_1309)player) || this.isTamed() || this.dragonFood(item) && !this.isTamed();
            return bl ? class_1269.field_21466 : class_1269.field_5811;
        }
        if (this.isTamed() && this.getSize() > 1 && this.isOwner((class_1309)player)) {
            if (item == class_1802.field_8106 && !this.hasChest() && this.getSize() > 2) {
                this.field_6002.method_43129((class_1657)null, (class_1297)this, SoundInit.EQUIP_CHEST_EVENT, class_3419.field_15254, 0.5f, 1.0f);
                this.setHasChest(true);
                if (!player.method_7337()) {
                    itemStack.method_7934(1);
                }
                return class_1269.field_5812;
            }
            if (this.dragonFood(item) && this.method_6032() < this.method_6063() && player.method_5715()) {
                if (!player.method_7337()) {
                    itemStack.method_7934(1);
                }
                this.method_6025(this.healingFood);
                return class_1269.field_5812;
            }
            if (!player.method_5715()) {
                if (!this.hasSaddle) {
                    if (item == ItemInit.DRAGON_SADDLE) {
                        this.field_6002.method_43129((class_1657)null, (class_1297)this, class_3417.field_14704, class_3419.field_15254, 0.8f, 1.0f);
                        if (!player.method_7337()) {
                            itemStack.method_7934(1);
                        }
                        this.hasSaddle = true;
                        this.method_5841().method_12778(HAS_SADDLE, (Object)true);
                        return class_1269.field_5812;
                    }
                    return class_1269.field_5814;
                }
                this.setSitting(false);
                this.putPlayerOnBack(player);
                return class_1269.field_5812;
            }
            if (this.isInSittingPose()) {
                this.setSitting(false);
                return class_1269.field_5812;
            }
            if (this.field_5952) {
                this.setSitting(true);
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        if (this.dragonFood(item)) {
            if (!this.isTamed()) {
                int tamer;
                if (!player.method_7337()) {
                    itemStack.method_7934(1);
                }
                if (this.field_5974.method_43048(tamer = item == ItemInit.ORC_SKIN ? 1 : this.healingFood) == 0) {
                    this.setOwner(player);
                    this.field_6189.method_6340();
                    this.method_5980(null);
                    this.field_6002.method_8421((class_1297)this, (byte)7);
                } else {
                    this.field_6002.method_8421((class_1297)this, (byte)6);
                }
                return class_1269.field_5812;
            }
            if (this.canEatFood(this.dragonAge, 3, 13)) {
                if (!player.method_7337()) {
                    itemStack.method_7934(1);
                }
                ++this.dragonAgeFoodBonus;
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        return super.method_5992(player, hand);
    }

    private boolean dragonFood(class_1792 item) {
        if (item == ItemInit.ORC_SKIN) {
            this.healingFood = 6;
            return true;
        }
        if (item == class_1802.field_8389 || item == class_1802.field_8046 || item == ItemInit.MAMMOTH_MEAT || item == ItemInit.RAW_VENISON || item == ItemInit.RHINO_MEAT || item == ItemInit.WARTHOG_MEAT || item == ItemInit.ENDER_WHALE_MEAT) {
            this.healingFood = 5;
            return true;
        }
        if (item == class_1802.field_8748 || item == class_1802.field_8726 || item == ItemInit.IGUANA_MEAT) {
            this.healingFood = 4;
            return true;
        }
        if (item == class_1802.field_8504) {
            this.healingFood = 3;
            return true;
        }
        return false;
    }

    private boolean canEatFood(int age, int minAge, int maxAge) {
        return age < minAge || age < maxAge && age > maxAge - minAge * 2;
    }

    public void method_5773() {
        super.method_5773();
        if (!this.field_6002.field_9236) {
            if (this.getSize() < 3) {
                if (this.field_6012 % 1200 == 0) {
                    ++this.dragonAge;
                }
                if (this.dragonAge == 5 && this.getSize() == 1) {
                    this.setSize(2);
                    this.healDragonIfGrowing();
                }
                if (this.dragonAge == 15 && this.getSize() == 2) {
                    this.setSize(3);
                    this.healDragonIfGrowing();
                }
                if (this.dragonAgeFoodBonus > 5) {
                    this.dragonAgeFoodBonus = 0;
                    ++this.dragonAge;
                    this.field_6002.method_8421((class_1297)this, (byte)9);
                }
            }
            if (this.method_5799() || this.method_5771()) {
                if (this.isFlying && this.method_5861(class_3486.field_15517) > 1.2) {
                    ++this.fluidTicker;
                    if (this.fluidTicker >= 30) {
                        this.isFlying = false;
                        this.method_5841().method_12778(IS_FLYING, (Object)false);
                        this.method_5841().method_12778(IS_START_FLYING, (Object)false);
                        this.method_5841().method_12778(CLIENT_START_FLYING, (Object)false);
                        this.method_5841().method_12778(CLIENT_END_FLYING, (Object)false);
                        this.startFlyingTimer = 0;
                        this.fluidTicker = 0;
                    }
                } else if (this.field_6002.field_9236 && this.method_5782() && !this.isFlying && this.method_5861(class_3486.field_15517) > 1.0) {
                    this.method_5762(0.0, 0.05, 0.0);
                }
            } else if (this.fluidTicker != 0) {
                this.fluidTicker = 0;
            }
        }
        if (this.fireBreathCooldown > 60) {
            ++this.fireBreathCooldown;
            if (((Boolean)this.method_5841().method_12789(FIRE_BREATH)).booleanValue()) {
                this.method_5841().method_12778(FIRE_BREATH, (Object)false);
            }
            if (this.fireBreathCooldown >= 120) {
                this.fireBreathCooldown = 0;
            }
        }
        if (this.fireBreathActive) {
            this.dragonFireBreath();
        }
    }

    private void healDragonIfGrowing() {
        if (this.method_6032() < this.method_6063()) {
            this.method_6033(this.method_6032() + 20.0f);
        }
    }

    public boolean method_5810() {
        return !this.method_5782();
    }

    public boolean method_5931(class_1657 player) {
        return !this.method_5934();
    }

    @Environment(value=EnvType.CLIENT)
    protected void showEmoteParticle(boolean positive) {
        class_2400 particleEffect = class_2398.field_11201;
        if (!positive) {
            particleEffect = class_2398.field_11251;
        }
        for (int i = 0; i < 7; ++i) {
            double d = this.field_5974.method_43059() * 0.02;
            double e = this.field_5974.method_43059() * 0.02;
            double f = this.field_5974.method_43059() * 0.02;
            this.field_6002.method_8406((class_2394)particleEffect, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d, e, f);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void method_5711(byte status) {
        if (status == 7 || status == 9) {
            this.showEmoteParticle(true);
        } else if (status == 6) {
            this.showEmoteParticle(false);
        } else {
            super.method_5711(status);
        }
    }

    public boolean isTamed() {
        return ((Byte)this.field_6011.method_12789(TAMEABLE_FLAGS) & 4) != 0;
    }

    public void setTamed(boolean tamed) {
        byte b = (Byte)this.field_6011.method_12789(TAMEABLE_FLAGS);
        if (tamed) {
            this.field_6011.method_12778(TAMEABLE_FLAGS, (Object)((byte)(b | 4)));
        } else {
            this.field_6011.method_12778(TAMEABLE_FLAGS, (Object)((byte)(b & 0xFFFFFFFB)));
        }
    }

    @Nullable
    public UUID method_6139() {
        return ((Optional)this.field_6011.method_12789(OWNER_UUID)).orElse(null);
    }

    public void setOwnerUuid(@Nullable UUID uuid) {
        this.field_6011.method_12778(OWNER_UUID, Optional.ofNullable(uuid));
    }

    public void setOwner(class_1657 player) {
        this.setTamed(true);
        this.setOwnerUuid(player.method_5667());
    }

    @Nullable
    public class_1309 getOwner() {
        try {
            UUID uUID = this.method_6139();
            return uUID == null ? null : this.field_6002.method_18470(uUID);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public boolean method_18395(class_1309 target) {
        return this.isOwner(target) ? false : super.method_18395(target);
    }

    public boolean isOwner(class_1309 entity) {
        return entity == this.getOwner();
    }

    public boolean method_5722(class_1297 other) {
        if (this.isTamed()) {
            class_1309 livingEntity = this.getOwner();
            if (other == livingEntity) {
                return true;
            }
            if (livingEntity != null) {
                return livingEntity.method_5722(other);
            }
        }
        return super.method_5722(other);
    }

    public void method_6078(class_1282 source) {
        if (!this.field_6002.field_9236) {
            if (this.field_6002.method_8450().method_8355(class_1928.field_19398) && this.getOwner() instanceof class_3222) {
                this.getOwner().method_43496(this.method_6066().method_5548());
            }
            if (FabricLoader.getInstance().isModLoaded("dragonloot")) {
                this.method_5775(new class_1799((class_1935)net.dragonloot.init.ItemInit.DRAGON_SCALE_ITEM, this.getSize()));
            }
        }
        super.method_6078(source);
    }

    public boolean isInSittingPose() {
        return ((Byte)this.field_6011.method_12789(TAMEABLE_FLAGS) & 1) != 0;
    }

    private void setInSittingPose(boolean inSittingPose) {
        this.sitting = inSittingPose;
        byte b = (Byte)this.field_6011.method_12789(TAMEABLE_FLAGS);
        if (inSittingPose) {
            this.field_6011.method_12778(TAMEABLE_FLAGS, (Object)((byte)(b | 1)));
        } else {
            this.field_6011.method_12778(TAMEABLE_FLAGS, (Object)((byte)(b & 0xFFFFFFFE)));
        }
    }

    public void setSitting(boolean sitting) {
        this.sitting = sitting;
        this.setInSittingPose(sitting);
    }

    public int method_5978() {
        if (this.isInSittingPose()) {
            return 20;
        }
        return super.method_5978();
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 landedState, class_2338 landedPosition) {
        if (!this.field_6002.field_9236 && !this.isFlying && !onGround && heightDifference < -0.7) {
            if (this.sitting) {
                this.setSitting(false);
            }
            if (!this.method_5782()) {
                this.isFlying = true;
                this.method_5841().method_12778(IS_FLYING, (Object)true);
                this.method_5841().method_12778(IS_START_FLYING, (Object)false);
                this.method_5841().method_12778(CLIENT_START_FLYING, (Object)false);
                this.startFlyingTime = (int)this.field_6002.method_8510();
            }
        }
        super.method_5623(heightDifference, onGround, landedState, landedPosition);
    }

    private void playWingFlapSound() {
        this.field_6002.method_43129(null, (class_1297)this, class_3417.field_14550, this.method_5634(), 5.0f, 0.8f + this.field_5974.method_43057() * 0.3f);
    }

    public void setKeyBind(String key) {
        this.keyBind = class_3675.method_15981((String)key).method_1444();
    }

    protected class_3414 method_5994() {
        return SoundInit.DRAGON_IDLE_EVENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return SoundInit.DRAGON_HIT_EVENT;
    }

    protected class_3414 method_6002() {
        return SoundInit.DRAGON_DEATH_EVENT;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(SoundInit.DRAGON_STEP_EVENT, 0.7f, 1.0f);
    }

    protected float method_5867() {
        return (float)((int)this.field_5994 + 2) - 0.01f;
    }

    public boolean method_5974(double num) {
        return false;
    }

    public void method_5453(class_1263 sender) {
    }

    private void onChestedStatusChanged() {
        class_1277 simpleInventory = this.inventory;
        this.inventory = new class_1277(27);
        if (simpleInventory != null) {
            simpleInventory.method_5488((class_1265)this);
            int i = Math.min(simpleInventory.method_5439(), this.inventory.method_5439());
            for (int j = 0; j < i; ++j) {
                class_1799 itemStack = simpleInventory.method_5438(j);
                if (itemStack.method_7960()) continue;
                this.inventory.method_5447(j, itemStack.method_7972());
            }
        }
        this.inventory.method_5489((class_1265)this);
    }

    protected void method_16078() {
        super.method_16078();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.method_5439(); ++i) {
                class_1799 itemStack = this.inventory.method_5438(i);
                if (itemStack.method_7960() || class_1890.method_8221((class_1799)itemStack)) continue;
                this.method_5775(itemStack);
            }
        }
        if (this.hasChest()) {
            if (!this.field_6002.field_9236) {
                this.method_5706((class_1935)class_2246.field_10034);
            }
            this.setHasChest(false);
        }
    }

    public boolean hasChest() {
        return (Boolean)this.field_6011.method_12789(HAS_CHEST);
    }

    public void setHasChest(boolean hasChest) {
        this.field_6011.method_12778(HAS_CHEST, (Object)hasChest);
    }

    public void openInventory(class_1657 player) {
        if (!this.field_6002.field_9236 && (!this.method_5782() || this.method_5626((class_1297)player)) && this.isTamed()) {
            player.method_17355((class_3908)new class_747((syncId, inv, p) -> new class_1707(class_3917.field_17326, syncId, p.method_31548(), (class_1263)this.inventory, 3), this.method_5477()));
        }
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityTag) {
        this.method_5841().method_12778(OTHER_EARS, (Object)world.method_8409().method_43056());
        this.method_5841().method_12778(OTHER_TAIL, (Object)world.method_8409().method_43056());
        this.method_5841().method_12778(OTHER_EYES, (Object)world.method_8409().method_43056());
        if (world.method_8597().comp_644()) {
            this.method_5841().method_12778(RED_DRAGON, (Object)world.method_8409().method_43056());
        }
        if (spawnReason.equals((Object)class_3730.field_16462)) {
            this.setSize(3);
        } else {
            this.setSize(1);
        }
        return super.method_5943(world, difficulty, spawnReason, entityData, entityTag);
    }

    public class_4048 method_18377(class_4050 pose) {
        return super.method_18377(pose).method_18383((float)this.getSize() / 3.0f);
    }

    public int getSize() {
        return (Integer)this.field_6011.method_12789(DRAGON_SIZE);
    }

    public void setSize(int size) {
        this.field_6011.method_12778(DRAGON_SIZE, (Object)size);
        this.method_23311();
        this.method_18382();
        this.method_5996(class_5134.field_23716).method_6192((double)(size * 20));
        this.method_5996(class_5134.field_23721).method_6192((double)size * 3.0);
        this.method_5996(class_5134.field_23724).method_6192((double)size * 2.0);
    }

    public void method_5674(class_2940<?> data) {
        if (DRAGON_SIZE.equals(data)) {
            this.method_18382();
            this.method_36456(this.field_6241);
            this.method_5636(this.field_6241);
        }
        super.method_5674(data);
    }

    public void method_18382() {
        double d = this.method_23317();
        double e = this.method_23318();
        double f = this.method_23321();
        super.method_18382();
        this.method_30634(d, e, f);
    }

    protected float method_6107() {
        return 0.3f * (float)this.getSize();
    }

    public float method_6017() {
        return 1.6f - 0.2f * (float)this.getSize();
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        if (this.getSize() == 1) {
            return 0.8f * dimensions.field_18068;
        }
        return 0.85f * dimensions.field_18068;
    }

    public double method_5621() {
        double flySubtraction = 0.92;
        if (this.isFlying) {
            flySubtraction = 0.9;
        }
        return (double)this.getSize() * 0.794 * flySubtraction;
    }

    public void method_5865(class_1297 passenger) {
        super.method_5865(passenger);
        if (passenger instanceof class_1308) {
            class_1308 mobEntity = (class_1308)passenger;
            this.field_6283 = mobEntity.field_6283;
            if (this.field_6002.field_9236) {
                float offSet = 12.0f;
                if (passenger.equals((Object)this.method_5642())) {
                    offSet = 1.0f;
                }
                float f = class_3532.method_15374((float)(this.field_6283 * ((float)Math.PI / 180))) * offSet;
                float g = class_3532.method_15362((float)(this.field_6283 * ((float)Math.PI / 180))) * offSet;
                passenger.method_5814(this.method_23317() + (double)(0.1f * f), this.method_23323(0.66f) + passenger.method_5678(), this.method_23321() - (double)(0.1f * g));
            }
        }
    }

    public double method_5678() {
        return 0.0;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (source == class_1282.field_5855) {
            return false;
        }
        if (!this.field_6002.field_9236) {
            this.setSitting(false);
        }
        return this.method_5679(source) ? false : super.method_5643(source, amount);
    }

    @Environment(value=EnvType.CLIENT)
    public static void flyDragonDown(class_746 player, String keyString) {
        if (player.method_5854() != null && player.method_5854() instanceof DragonEntity) {
            ((DragonEntity)player.method_5854()).setKeyBind(keyString);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void dragonFireBreath(class_746 player) {
        DragonEntity dragonEntity;
        if (player.method_5854() != null && player.method_5854() instanceof DragonEntity && player.method_5854().method_5805() && (Integer)(dragonEntity = (DragonEntity)player.method_5854()).method_5841().method_12789(DRAGON_SIZE) >= 3) {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.writeInt(player.method_5854().method_5628());
            class_2817 packet = new class_2817(KeybindPacket.FIRE_BREATH_PACKET, buf);
            class_310.method_1551().method_1562().method_2883((class_2596)packet);
            ((DragonEntity)player.method_5854()).fireBreathActive = true;
        }
    }
}

