/*
 * Decompiled with CFR 0.152.
 */
package de.martenschaefer.grindenchantments;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.martenschaefer.config.api.ConfigIo;
import de.martenschaefer.config.api.ModConfig;
import de.martenschaefer.grindenchantments.config.GrindEnchantmentsV2Config;
import de.martenschaefer.grindenchantments.config.v1.GrindEnchantmentsV1Config;
import de.martenschaefer.grindenchantments.cost.CostFunctionType;
import de.martenschaefer.grindenchantments.event.ApplyLevelCostEvent;
import de.martenschaefer.grindenchantments.event.GrindstoneEvents;
import de.martenschaefer.grindenchantments.impl.DisenchantOperation;
import de.martenschaefer.grindenchantments.impl.MoveOperation;
import de.martenschaefer.grindenchantments.registry.GrindEnchantmentsRegistries;
import io.github.fourmisain.taxfreelevels.TaxFreeLevels;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GrindEnchantmentsMod
implements ModInitializer {
    public static final String MODID = "grindenchantments";
    public static final Logger LOGGER = LogManager.getLogger((String)"Grind Enchantments");
    public static final Path CONFIG_PATH = Paths.get("grindenchantments.json", new String[0]);
    private static final GrindEnchantmentsV2Config LATEST_CONFIG_DEFAULT = GrindEnchantmentsV2Config.DEFAULT;
    private static final int LATEST_CONFIG_VERSION = LATEST_CONFIG_DEFAULT.version();
    private static final Codec<ModConfig<GrindEnchantmentsV2Config>> CONFIG_CODEC = ModConfig.createCodec((int)LATEST_CONFIG_VERSION, GrindEnchantmentsMod::getConfigType);
    private static GrindEnchantmentsV2Config CONFIG = LATEST_CONFIG_DEFAULT;

    public void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            CONFIG = (GrindEnchantmentsV2Config)ConfigIo.initializeConfig((Path)Paths.get("grindenchantments.json", new String[0]), (int)LATEST_CONFIG_VERSION, (ModConfig)LATEST_CONFIG_DEFAULT, CONFIG_CODEC, (DynamicOps)class_6903.method_40414((DynamicOps)JsonOps.INSTANCE, (class_5455)server.method_30611()), arg_0 -> ((Logger)LOGGER).info(arg_0), arg_0 -> ((Logger)LOGGER).error(arg_0));
        });
        GrindEnchantmentsRegistries.init();
        CostFunctionType.init();
        DisenchantOperation disenchant = new DisenchantOperation();
        MoveOperation move = new MoveOperation();
        GrindstoneEvents.registerAll(disenchant);
        GrindstoneEvents.registerAll(move);
        ApplyLevelCostEvent.EVENT.register(ApplyLevelCostEvent.DEFAULT, (cost, player) -> {
            player.method_7316(-cost);
            return true;
        });
        if (FabricLoader.getInstance().isModLoaded("taxfreelevels")) {
            ApplyLevelCostEvent.EVENT.register(ApplyLevelCostEvent.MOD_COMPATIBILITY, (cost, player) -> {
                TaxFreeLevels.applyFlattenedXpCost((class_1657)player, (int)cost);
                return true;
            });
        }
    }

    private static ModConfig.Type<GrindEnchantmentsV2Config, ?> getConfigType(int version) {
        return new ModConfig.Type(version, switch (version) {
            case 1 -> GrindEnchantmentsV1Config.TYPE_CODEC;
            default -> GrindEnchantmentsV2Config.TYPE_CODEC;
        });
    }

    public static GrindEnchantmentsV2Config getConfig() {
        return CONFIG;
    }

    public static void log(Level level, Object message) {
        LOGGER.log(level, "[Grind Enchantments] " + message);
    }

    public static class_2960 id(String path) {
        return new class_2960(MODID, path);
    }
}

