/*
 * Decompiled with CFR 0.152.
 */
package de.martenschaefer.grindenchantments;

import de.martenschaefer.grindenchantments.GrindEnchantmentsMod;
import de.martenschaefer.grindenchantments.config.DedicatedServerConfig;
import de.martenschaefer.grindenchantments.cost.CostFunction;
import java.util.Map;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.apache.logging.log4j.Level;

public class GrindEnchantments {
    public static int getLevelCost(class_1799 stack, CostFunction costFunction, boolean allowCurses) {
        Map enchantments = class_1890.method_8222((class_1799)stack);
        double cost = costFunction.getCost(enchantments.entrySet(), allowCurses);
        return (int)Math.ceil(cost);
    }

    public static Map<class_1887, Integer> getEnchantments(class_1799 stack, boolean allowCurses) {
        Stream<Object> enchantments = class_1890.method_8222((class_1799)stack).entrySet().stream();
        if (!allowCurses) {
            enchantments = enchantments.filter(entry -> !((class_1887)entry.getKey()).method_8195());
        }
        return enchantments.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static class_1799 addLevelCostNbt(class_1799 stack, IntSupplier cost, boolean canTakeItem, DedicatedServerConfig config) {
        if (!config.alternativeCostDisplay()) {
            return stack;
        }
        class_1799 changed = stack.method_7972();
        class_2487 modNbt = changed.method_7911("grindenchantments");
        modNbt.method_10569("Cost", cost.getAsInt());
        modNbt.method_10556("CanTake", canTakeItem);
        return changed;
    }

    public static class_1799 addLevelCostLore(class_1799 stack, IntSupplier cost, boolean canTakeItem) {
        class_2499 lore;
        class_1799 changed = stack.method_7972();
        class_2487 display = changed.method_7911("display");
        if (display.method_10540("Lore") == 9) {
            lore = display.method_10554("Lore", 8);
        } else if (!display.method_10545("Lore")) {
            lore = new class_2499();
            display.method_10566("Lore", (class_2520)lore);
        } else {
            GrindEnchantmentsMod.log(Level.ERROR, "Cannot add enchantment cost to item stack as lore.");
            return stack;
        }
        class_5250 text = class_2561.method_43470((String)("Enchantment cost: " + cost.getAsInt())).method_27692(canTakeItem ? class_124.field_1060 : class_124.field_1061);
        lore.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)text)));
        return changed;
    }

    public static class_1799 removeLevelCostNbt(class_1799 stack) {
        stack.method_7983("grindenchantments");
        return stack;
    }
}

