/*
 * Decompiled with CFR 0.152.
 */
package terrablender.api;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import terrablender.api.ModifiedVanillaOverworldBuilder;
import terrablender.api.ParameterUtils;
import terrablender.api.RegionType;
import terrablender.worldgen.RegionUtils;

public abstract class Region {
    public static final class_5321<class_1959> DEFERRED_PLACEHOLDER = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)new class_2960("terrablender", "deferred_placeholder"));
    private final class_2960 name;
    private RegionType type;
    private int weight;

    public Region(class_2960 name, RegionType type, int weight) {
        this.name = name;
        this.type = type;
        this.weight = weight;
    }

    public class_2960 getName() {
        return this.name;
    }

    public RegionType getType() {
        return this.type;
    }

    public int getWeight() {
        return this.weight;
    }

    public void addBiomes(class_2378<class_1959> registry, Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> mapper) {
    }

    protected final void addBiome(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> mapper, class_6544.class_6546 temperature, class_6544.class_6546 humidity, class_6544.class_6546 continentalness, class_6544.class_6546 erosion, class_6544.class_6546 weirdness, class_6544.class_6546 depth, float offset, class_5321<class_1959> biome) {
        this.addBiome(mapper, class_6544.method_38118((class_6544.class_6546)temperature, (class_6544.class_6546)humidity, (class_6544.class_6546)continentalness, (class_6544.class_6546)erosion, (class_6544.class_6546)depth, (class_6544.class_6546)weirdness, (float)offset), biome);
    }

    protected final void addBiome(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> mapper, ParameterUtils.Temperature temperature, ParameterUtils.Humidity humidity, ParameterUtils.Continentalness continentalness, ParameterUtils.Erosion erosion, ParameterUtils.Weirdness weirdness, ParameterUtils.Depth depth, float offset, class_5321<class_1959> biome) {
        this.addBiome(mapper, class_6544.method_38118((class_6544.class_6546)temperature.parameter(), (class_6544.class_6546)humidity.parameter(), (class_6544.class_6546)continentalness.parameter(), (class_6544.class_6546)erosion.parameter(), (class_6544.class_6546)depth.parameter(), (class_6544.class_6546)weirdness.parameter(), (float)offset), biome);
    }

    protected final void addBiome(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> mapper, class_6544.class_4762 parameters, class_5321<class_1959> biome) {
        mapper.accept((Pair<class_6544.class_4762, class_5321<class_1959>>)Pair.of((Object)parameters, biome));
    }

    protected final void addBiomeSimilar(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> mapper, class_5321<class_1959> similarVanillaBiome, class_5321<class_1959> biome) {
        List points = (List)RegionUtils.getVanillaParameterPoints(similarVanillaBiome).stream().collect(ImmutableList.toImmutableList());
        points.forEach(point -> this.addBiome(mapper, (class_6544.class_4762)point, biome));
    }

    protected final void addModifiedVanillaOverworldBiomes(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> mapper, Consumer<ModifiedVanillaOverworldBuilder> onModify) {
        ModifiedVanillaOverworldBuilder builder = new ModifiedVanillaOverworldBuilder();
        onModify.accept(builder);
        builder.build().forEach(mapper::accept);
    }
}

