/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.screen;

import com.google.common.collect.Lists;
import io.github.foundationgames.automobility.entity.AutomobileEntity;
import io.github.foundationgames.automobility.platform.Platform;
import io.github.foundationgames.automobility.util.AUtils;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public final class AutomobileHud
extends Enum<AutomobileHud> {
    public static final List<ControlHint> CONTROL_HINTS;
    private static final /* synthetic */ AutomobileHud[] $VALUES;

    public static AutomobileHud[] values() {
        return (AutomobileHud[])$VALUES.clone();
    }

    public static AutomobileHud valueOf(String name) {
        return Enum.valueOf(AutomobileHud.class, name);
    }

    public static void render(class_4587 pose, class_1657 player, AutomobileEntity auto, float tickDelta) {
        float alpha;
        AutomobileHud.renderSpeedometer(pose, auto);
        if (!Platform.get().inControllerMode() && (int)((alpha = Math.max(0.0f, auto.getStandStillTime() * 2.0f - 1.0f)) * 255.0f) > 0) {
            AutomobileHud.renderControlHints(pose, alpha);
        }
    }

    private static void renderSpeedometer(class_4587 pose, AutomobileEntity auto) {
        float speed = (float)auto.getEffectiveSpeed() * 20.0f;
        int color = 0xFFFFFF;
        if (auto.getBoostTimer() > 0) {
            color = 0xFF6F00;
        }
        if (auto.getTurboCharge() > 35) {
            color = 16771658;
        }
        if (auto.getTurboCharge() > 70) {
            color = 8251903;
        }
        if (auto.getTurboCharge() > 115) {
            color = 9465599;
        }
        class_332.method_27535((class_4587)pose, (class_327)class_310.method_1551().field_1772, (class_2561)class_2561.method_43470((String)(AUtils.DEC_TWO_PLACES.format(speed) + " m/s")), (int)20, (int)20, (int)color);
    }

    private static void renderControlHints(class_4587 pose, float alpha) {
        int x = 20;
        int y = 50;
        class_315 options = class_310.method_1551().field_1690;
        class_327 font = class_310.method_1551().field_1772;
        for (ControlHint control : CONTROL_HINTS) {
            class_2561 keyTxt = control.getKeybindText(options);
            int keyTxtWid = font.method_27525((class_5348)keyTxt);
            class_332.method_25294((class_4587)pose, (int)x, (int)y, (int)(x + keyTxtWid + 6), (int)(y + 14), (int)((int)(alpha * 171.0f) << 24));
            int textColor = 0xFFFFFF | (int)(alpha * 255.0f) << 24;
            class_332.method_27535((class_4587)pose, (class_327)font, (class_2561)keyTxt, (int)(x + 3), (int)(y + 3), (int)textColor);
            class_332.method_27535((class_4587)pose, (class_327)font, (class_2561)control.getText(), (int)(x + keyTxtWid + 9), (int)(y + 3), (int)textColor);
            y += 17;
        }
    }

    private static /* synthetic */ AutomobileHud[] $values() {
        return new AutomobileHud[0];
    }

    static {
        $VALUES = AutomobileHud.$values();
        CONTROL_HINTS = Lists.newArrayList((Object[])new ControlHint[]{new ControlHint("accelerate", options -> options.field_1894), new ControlHint("brake", options -> options.field_1881), new ControlHint("steer_left", options -> options.field_1913), new ControlHint("steer_right", options -> options.field_1849), new ControlHint("drift", options -> options.field_1903)});
    }

    public record ControlHint(String name, Function<class_315, class_304> keybind) {
        public class_2561 getText() {
            return class_2561.method_43471((String)("automobile_control." + this.name));
        }

        public class_2561 getKeybindText(class_315 options) {
            return this.keybind.apply(options).method_16007();
        }
    }
}

