/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.foundationgames.automobility.item.AutomobileComponentItem;
import io.github.foundationgames.automobility.recipe.AutoMechanicTableRecipe;
import java.util.LinkedHashSet;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class AutoMechanicTableRecipeSerializer
implements class_1865<AutoMechanicTableRecipe> {
    public static final AutoMechanicTableRecipeSerializer INSTANCE = new AutoMechanicTableRecipeSerializer();

    public static class_1799 autoComponentStackFromJson(JsonObject obj) throws JsonSyntaxException, IllegalStateException {
        class_1792 class_17922;
        class_2960 id = class_2960.method_12829((String)obj.get("item").getAsString());
        int count = obj.has("count") ? obj.get("count").getAsInt() : 1;
        class_1799 stack = class_2378.field_11142.method_17966(id).map(i -> new class_1799((class_1935)i, count)).orElse(class_1799.field_8037);
        if (obj.has("component") && (class_17922 = stack.method_7909()) instanceof AutomobileComponentItem) {
            AutomobileComponentItem item = (AutomobileComponentItem)class_17922;
            class_2960 component = class_2960.method_12829((String)obj.get("component").getAsString());
            if (component != null) {
                item.setComponent(stack, component);
            }
        }
        return stack;
    }

    public AutoMechanicTableRecipe fromJson(class_2960 id, JsonObject json) {
        try {
            class_2960 category = class_2960.method_12829((String)json.get("category").getAsString());
            LinkedHashSet<class_1856> ingredients = new LinkedHashSet<class_1856>();
            for (JsonElement ele : json.get("ingredients").getAsJsonArray()) {
                ingredients.add(class_1856.method_8102((JsonElement)ele));
            }
            class_1799 result = AutoMechanicTableRecipeSerializer.autoComponentStackFromJson(json.get("result").getAsJsonObject());
            int sortNum = 0;
            if (json.has("sortnum")) {
                sortNum = json.get("sortnum").getAsInt();
            }
            return new AutoMechanicTableRecipe(id, category, ingredients, result, sortNum);
        }
        catch (IllegalStateException ex) {
            throw new JsonSyntaxException("Error parsing Auto Mechanic Table recipe - " + ex.getMessage());
        }
    }

    public AutoMechanicTableRecipe fromNetwork(class_2960 id, class_2540 buf) {
        class_2960 category = class_2960.method_12829((String)buf.method_19772());
        int size = buf.readByte();
        LinkedHashSet<class_1856> ingredients = new LinkedHashSet<class_1856>();
        for (int i = 0; i < size; ++i) {
            ingredients.add(class_1856.method_8086((class_2540)buf));
        }
        class_1799 result = buf.method_10819();
        int sortNum = buf.readInt();
        return new AutoMechanicTableRecipe(id, category, ingredients, result, sortNum);
    }

    public void toNetwork(class_2540 buf, AutoMechanicTableRecipe recipe) {
        buf.method_10814(recipe.category.toString());
        buf.writeByte(recipe.ingredients.size());
        recipe.ingredients.forEach(ing -> ing.method_8088(buf));
        buf.method_10793(recipe.result);
        buf.writeInt(recipe.sortNum);
    }
}

