/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.automobile;

import io.github.foundationgames.automobility.Automobility;
import io.github.foundationgames.automobility.automobile.AutomobileComponent;
import io.github.foundationgames.automobility.automobile.DisplayStat;
import io.github.foundationgames.automobility.util.SimpleMapContentRegistry;
import java.util.function.Consumer;
import net.minecraft.class_2960;

public record AutomobileWheel(class_2960 id, float size, float grip, WheelModel model, Ability[] abilities) implements AutomobileComponent<AutomobileWheel>
{
    public static final class_2960 ID = Automobility.rl("wheel");
    public static final SimpleMapContentRegistry<AutomobileWheel> REGISTRY = new SimpleMapContentRegistry();
    public static final AutomobileWheel EMPTY = REGISTRY.register(new AutomobileWheel(Automobility.rl("empty"), 0.01f, 0.01f, new WheelModel(1.0f, 1.0f, new class_2960("empty"), Automobility.rl("empty")), new Ability[0]));
    public static final AutomobileWheel STANDARD = REGISTRY.register(new AutomobileWheel(Automobility.rl("standard"), 0.6f, 0.5f, new WheelModel(3.0f, 3.0f, Automobility.rl("textures/entity/automobile/wheel/standard.png"), Automobility.rl("wheel_standard")), new Ability[0]));
    public static final AutomobileWheel OFF_ROAD = REGISTRY.register(new AutomobileWheel(Automobility.rl("off_road"), 1.1f, 0.8f, new WheelModel(8.4f, 5.0f, Automobility.rl("textures/entity/automobile/wheel/off_road.png"), Automobility.rl("wheel_off_road")), new Ability[0]));
    public static final AutomobileWheel STEEL = REGISTRY.register(new AutomobileWheel(Automobility.rl("steel"), 0.69f, 0.4f, new WheelModel(3.625f, 3.0f, Automobility.rl("textures/entity/automobile/wheel/steel.png"), Automobility.rl("wheel_steel")), new Ability[0]));
    public static final AutomobileWheel TRACTOR = REGISTRY.register(new AutomobileWheel(Automobility.rl("tractor"), 1.05f, 0.69f, new WheelModel(3.625f, 3.0f, Automobility.rl("textures/entity/automobile/wheel/tractor.png"), Automobility.rl("wheel_tractor")), new Ability[0]));
    public static final AutomobileWheel CARRIAGE = REGISTRY.register(AutomobileWheel.carriage("carriage", 0.2f));
    public static final AutomobileWheel PLATED = REGISTRY.register(AutomobileWheel.carriage("plated", 0.33f));
    public static final AutomobileWheel STREET = REGISTRY.register(AutomobileWheel.carriage("street", 0.5f));
    public static final AutomobileWheel GILDED = REGISTRY.register(AutomobileWheel.carriage("gilded", 0.45f));
    public static final AutomobileWheel BEJEWELED = REGISTRY.register(AutomobileWheel.carriage("bejeweled", 0.475f));
    public static final AutomobileWheel CONVERTIBLE = REGISTRY.register(new AutomobileWheel(Automobility.rl("convertible"), 0.75f, 0.45f, new WheelModel(5.2f, 4.1f, Automobility.rl("textures/entity/automobile/frame/c_arr.png"), Automobility.rl("wheel_convertible")), new Ability[0]));
    public static final DisplayStat<AutomobileWheel> STAT_SIZE = new DisplayStat<AutomobileWheel>("size", AutomobileWheel::size);
    public static final DisplayStat<AutomobileWheel> STAT_GRIP = new DisplayStat<AutomobileWheel>("grip", AutomobileWheel::grip);

    private static AutomobileWheel carriage(String name, float grip) {
        return new AutomobileWheel(Automobility.rl(name), 1.05f, grip, new WheelModel(5.0f, 2.0f, Automobility.rl("textures/entity/automobile/wheel/" + name + ".png"), Automobility.rl("wheel_carriage")), new Ability[0]);
    }

    @Override
    public boolean isEmpty() {
        return this == EMPTY;
    }

    @Override
    public class_2960 containerId() {
        return ID;
    }

    @Override
    public void forEachStat(Consumer<DisplayStat<AutomobileWheel>> action) {
        action.accept(STAT_SIZE);
        action.accept(STAT_GRIP);
    }

    @Override
    public class_2960 getId() {
        return this.id;
    }

    public String getTranslationKey() {
        return "wheel." + this.id.method_12836() + "." + this.id.method_12832();
    }

    public record WheelModel(float radius, float width, class_2960 texture, class_2960 modelId) {
    }

    public static final class Ability
    extends Enum<Ability> {
        private static final /* synthetic */ Ability[] $VALUES;

        public static Ability[] values() {
            return (Ability[])$VALUES.clone();
        }

        public static Ability valueOf(String name) {
            return Enum.valueOf(Ability.class, name);
        }

        private static /* synthetic */ Ability[] $values() {
            return new Ability[0];
        }

        static {
            $VALUES = Ability.$values();
        }
    }
}

