/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.core.setup;

import lilypuree.decorative_blocks.CommonAPI;
import lilypuree.decorative_blocks.CommonConfig;
import lilypuree.decorative_blocks.blocks.BonfireBlock;
import lilypuree.decorative_blocks.blocks.IWoodenBlock;
import lilypuree.decorative_blocks.blocks.PalisadeBlock;
import lilypuree.decorative_blocks.blocks.SeatBlock;
import lilypuree.decorative_blocks.blocks.SupportBlock;
import lilypuree.decorative_blocks.core.DBBlocks;
import lilypuree.decorative_blocks.core.DBItems;
import lilypuree.decorative_blocks.core.Registration;
import lilypuree.decorative_blocks.items.BlockstateCopyItem;
import lilypuree.decorative_blocks.mixin.FireBlockInvoker;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class ModSetup {
    private static class_1792 bonfireActivatorItem = null;

    public static void init() {
        CommonAPI.addThatchlikeFluid(Registration.referenceHolder);
        CommonAPI.bonfireMap.put(class_2246.field_10036, (class_2248)DBBlocks.BONFIRE.get());
        CommonAPI.bonfireMap.put(class_2246.field_22089, (class_2248)DBBlocks.SOUL_BONFIRE.get());
        class_2378.field_11146.forEach(block -> {
            if (block instanceof PalisadeBlock) {
                BlockstateCopyItem.addProperties(block, new class_2769[]{PalisadeBlock.field_10905, PalisadeBlock.field_10907, PalisadeBlock.field_10904, PalisadeBlock.field_10903});
            } else if (block instanceof SeatBlock) {
                BlockstateCopyItem.addProperties(block, new class_2769[]{SeatBlock.field_11177, SeatBlock.POST, SeatBlock.ATTACHED});
            } else if (block instanceof SupportBlock) {
                BlockstateCopyItem.addProperties(block, new class_2769[]{SupportBlock.HORIZONTAL_SHAPE, SupportBlock.VERTICAL_SHAPE, SupportBlock.field_11177, SupportBlock.UP});
            }
        });
        FireBlockInvoker invoker = (FireBlockInvoker)class_2246.field_10036;
        class_2378.field_11146.forEach(block -> {
            IWoodenBlock woodenBlock;
            if (block instanceof IWoodenBlock && (woodenBlock = (IWoodenBlock)block).getWoodType().isFlammable()) {
                invoker.invokeSetFlammable((class_2248)block, 5, 20);
            }
        });
        invoker.invokeSetFlammable((class_2248)DBBlocks.LATTICE.get(), 5, 20);
        invoker.invokeSetFlammable((class_2248)DBBlocks.THATCH.get(), 60, 80);
    }

    public static boolean onLeftClick(class_1937 world, class_2338 pos) {
        class_2248 block = world.method_8320(pos).method_26204();
        if (block instanceof BonfireBlock) {
            world.method_8444(null, 1009, pos, 0);
            world.method_8650(pos, false);
            return true;
        }
        return false;
    }

    public static int onRightClick(class_1937 world, class_1657 player, class_1268 hand, class_1799 itemStack, class_2338 pos) {
        if (!world.method_22340(pos)) {
            return 0;
        }
        class_2248 block = world.method_8320(pos).method_26204();
        class_1792 item = itemStack.method_7909();
        if (item == class_1802.field_8868 && CommonAPI.shearMap.containsKey(block)) {
            if (world.field_9236) {
                player.method_6104(hand);
            } else if (CommonConfig.THATCH_ENABLED) {
                world.method_8501(pos, CommonAPI.shearMap.get(block).getLiquidBlock().method_9564());
                world.method_8396(null, pos, class_3417.field_17610, class_3419.field_15245, 1.2f, 1.0f);
                itemStack.method_7956(1, (class_1309)player, entity -> entity.method_20235(class_1304.field_6173));
            }
        }
        if (item == DBItems.BLOCKSTATE_COPY_ITEM) {
            return -1;
        }
        return 0;
    }

    public static boolean isBonfireActivator(class_1799 item) {
        if (bonfireActivatorItem == null) {
            ModSetup.checkBonfireActivatorConfig();
            return ModSetup.isBonfireActivator(item);
        }
        return bonfireActivatorItem != class_1802.field_8162 && bonfireActivatorItem == item.method_7909();
    }

    public static boolean sendMessageOnThrow(class_1657 player, class_1542 thrown) {
        if (bonfireActivatorItem == null && !ModSetup.checkBonfireActivatorConfig()) {
            player.method_43496((class_2561)class_2561.method_43471((String)"message.decorative_blocks.invalid_bonfire_activator_config"));
            return false;
        }
        return ModSetup.isBonfireActivator(thrown.method_6983());
    }

    public static boolean checkBonfireActivatorConfig() {
        class_2960 bonfireActivatorResourceLocation = class_2960.method_12829((String)CommonConfig.BONFIRE_ACTIVATOR);
        if (bonfireActivatorResourceLocation != null && class_2378.field_11142.method_10250(bonfireActivatorResourceLocation)) {
            bonfireActivatorItem = (class_1792)class_2378.field_11142.method_10223(bonfireActivatorResourceLocation);
            return true;
        }
        bonfireActivatorItem = class_1802.field_8162;
        return false;
    }
}

