/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.data;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.unlikepaladin.pfm.registry.RecipeTypes;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_193;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2378;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class FurnitureRecipeJsonBuilder
implements class_5797 {
    private final class_1792 output;
    private final int outputCount;
    private final List<String> pattern = Lists.newArrayList();
    private final Map<Character, class_1856> inputs = Maps.newLinkedHashMap();
    private final class_161.class_162 advancementBuilder = class_161.class_162.method_707();
    public static final Logger PFM_RECIPE_LOGGER = LogManager.getLogger();
    @Nullable
    private String group;

    public FurnitureRecipeJsonBuilder(class_1935 output, int outputCount) {
        this.output = output.method_8389();
        this.outputCount = outputCount;
    }

    public static FurnitureRecipeJsonBuilder create(class_1935 output) {
        return FurnitureRecipeJsonBuilder.create(output, 1);
    }

    public static FurnitureRecipeJsonBuilder create(class_1935 output, int outputCount) {
        return new FurnitureRecipeJsonBuilder(output, outputCount);
    }

    public FurnitureRecipeJsonBuilder input(Character c, class_6862<class_1792> tag) {
        return this.input(c, class_1856.method_8106(tag));
    }

    public FurnitureRecipeJsonBuilder input(Character c, class_1935 itemProvider) {
        return this.input(c, class_1856.method_8091((class_1935[])new class_1935[]{itemProvider}));
    }

    public FurnitureRecipeJsonBuilder input(Character c, class_1856 ingredient) {
        if (this.inputs.containsKey(c)) {
            throw new IllegalArgumentException("Symbol '" + c + "' is already defined!");
        }
        if (c.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.inputs.put(c, ingredient);
        return this;
    }

    public FurnitureRecipeJsonBuilder pattern(String patternStr) {
        if (!this.pattern.isEmpty() && patternStr.length() != this.pattern.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.pattern.add(patternStr);
        return this;
    }

    public FurnitureRecipeJsonBuilder criterion(String string, class_184 criterionConditions) {
        this.advancementBuilder.method_709(string, criterionConditions);
        return this;
    }

    public FurnitureRecipeJsonBuilder group(@Nullable String string) {
        this.group = string;
        return this;
    }

    public class_1792 method_36441() {
        return this.output;
    }

    public void method_17972(Consumer<class_2444> exporter, class_2960 recipeId) {
        this.validate(recipeId);
        this.advancementBuilder.method_708(new class_2960("recipes/root")).method_709("has_the_recipe", (class_184)class_2119.method_27847((class_2960)recipeId)).method_703(class_170.class_171.method_753((class_2960)recipeId)).method_704(class_193.field_1257);
        class_1792 output = this.output;
        int outputCount = this.outputCount;
        String group = this.group == null ? "" : this.group;
        List<String> pattern = this.pattern;
        Map<Character, class_1856> inputs = this.inputs;
        class_161.class_162 advancementBuilder = this.advancementBuilder;
        String recipeIdNamespace = recipeId.method_12836();
        String name = this.output.method_7859().method_7751();
        exporter.accept(new FurnitureRecipeJsonProvider(recipeId, output, outputCount, group, pattern, inputs, advancementBuilder, new class_2960(recipeIdNamespace, "recipes/" + name + "/" + recipeId.method_12832())));
    }

    private void validate(class_2960 recipeId) {
        if (this.pattern.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for furniture recipe " + recipeId + "!");
        }
        HashSet set = Sets.newHashSet(this.inputs.keySet());
        set.remove(Character.valueOf(' '));
        for (String string : this.pattern) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (!this.inputs.containsKey(Character.valueOf(c)) && c != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + recipeId + " uses undefined symbol '" + c + "'");
                }
                set.remove(Character.valueOf(c));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + recipeId);
        }
        if (this.inputs.containsValue(class_1856.field_9017) || this.inputs.containsValue(class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8162}))) {
            PFM_RECIPE_LOGGER.warn("Recipe contains empty ingredient: " + recipeId);
        }
    }

    static class FurnitureRecipeJsonProvider
    implements class_2444 {
        private final class_2960 recipeId;
        private final class_1792 output;
        private final int resultCount;
        private final String group;
        private final List<String> pattern;
        private final Map<Character, class_1856> inputs;
        private final class_161.class_162 advancementBuilder;
        private final class_2960 advancementId;

        public FurnitureRecipeJsonProvider(class_2960 recipeId, class_1792 output, int resultCount, String group, List<String> pattern, Map<Character, class_1856> inputs, class_161.class_162 advancementBuilder, class_2960 advancementId) {
            this.recipeId = recipeId;
            this.output = output;
            this.resultCount = resultCount;
            this.group = group;
            this.pattern = pattern;
            this.inputs = inputs;
            this.advancementBuilder = advancementBuilder;
            this.advancementId = advancementId;
        }

        public void method_10416(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray jsonArray = new JsonArray();
            for (String string : this.pattern) {
                jsonArray.add(string);
            }
            json.add("pattern", (JsonElement)jsonArray);
            JsonObject jsonObject = new JsonObject();
            for (Map.Entry<Character, class_1856> entry : this.inputs.entrySet()) {
                jsonObject.add(String.valueOf(entry.getKey()), entry.getValue().method_8089());
            }
            json.add("key", (JsonElement)jsonObject);
            JsonObject string = new JsonObject();
            string.addProperty("item", class_2378.field_11142.method_10221((Object)this.output).toString());
            if (this.resultCount > 1) {
                string.addProperty("count", (Number)this.resultCount);
            }
            json.add("result", (JsonElement)string);
        }

        public class_1865<?> method_17800() {
            return RecipeTypes.FURNITURE_SERIALIZER;
        }

        public class_2960 method_10417() {
            return this.recipeId;
        }

        @Nullable
        public JsonObject method_10415() {
            return this.advancementBuilder.method_698();
        }

        @Nullable
        public class_2960 method_10418() {
            return this.advancementId;
        }
    }
}

