/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.compat.fabric.jei;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.unlikepaladin.pfm.compat.fabric.jei.PaladinFurnitureModJEIPlugin;
import com.unlikepaladin.pfm.recipes.FreezingRecipe;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class FreezingCategory
implements IRecipeCategory<FreezingRecipe> {
    public static final class_2561 TITLE = class_2561.method_43471((String)"rei.pfm.freezer");
    public final IDrawable ICON;
    public static final class_2960 IDENTIFIER = new class_2960("pfm", "freezing");
    private final IDrawable BACKGROUND;
    public static final class_2960 FREEZE_GUI = new class_2960("pfm", "textures/gui/container/freezer.png");
    protected final IDrawableStatic staticFreezeIcon;
    protected final IDrawableAnimated animatedFreezeIcon;
    private final int regularFreezeTime;
    private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;
    protected static final int inputSlot = 0;
    protected static final int fuelSlot = 1;
    protected static final int outputSlot = 2;

    public FreezingCategory(final IGuiHelper guiHelper) {
        this.ICON = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)PaladinFurnitureModBlocksItems.WHITE_FRIDGE));
        this.BACKGROUND = guiHelper.createDrawable(FREEZE_GUI, 55, 16, 82, 54);
        this.staticFreezeIcon = guiHelper.createDrawable(FREEZE_GUI, 176, 0, 12, 12);
        this.animatedFreezeIcon = guiHelper.createAnimatedDrawable(this.staticFreezeIcon, 300, IDrawableAnimated.StartDirection.TOP, true);
        this.regularFreezeTime = 100;
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer freezeTime) {
                return guiHelper.drawableBuilder(FREEZE_GUI, 176, 14, 24, 17).buildAnimated(freezeTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    public RecipeType<FreezingRecipe> getRecipeType() {
        return PaladinFurnitureModJEIPlugin.FREEZING_RECIPE;
    }

    public class_2561 getTitle() {
        return TITLE;
    }

    public IDrawable getBackground() {
        return this.BACKGROUND;
    }

    public IDrawable getIcon() {
        return this.ICON;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FreezingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients((class_1856)recipe.method_8117().get(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 61, 19).addItemStack(recipe.method_8110());
    }

    protected IDrawableAnimated getArrow(FreezingRecipe recipe) {
        int freezeTime = recipe.method_8167();
        if (freezeTime <= 0) {
            freezeTime = this.regularFreezeTime;
        }
        return (IDrawableAnimated)this.cachedArrows.getUnchecked((Object)freezeTime);
    }

    protected void drawFreezeTime(FreezingRecipe recipe, class_4587 poseStack, int y) {
        int freezeTime = recipe.method_8167();
        if (freezeTime > 0) {
            int freezeTimeSeconds = freezeTime / 20;
            class_2561 timeString = class_2561.method_30163((String)(freezeTimeSeconds + "s"));
            class_310 minecraft = class_310.method_1551();
            class_327 fontRenderer = minecraft.field_1772;
            int stringWidth = fontRenderer.method_27525((class_5348)timeString);
            fontRenderer.method_30883(poseStack, timeString, (float)(this.BACKGROUND.getWidth() - stringWidth), (float)y, -8355712);
        }
    }

    protected void drawExperience(FreezingRecipe recipe, class_4587 poseStack, int y) {
        float experience = recipe.method_8171();
        if (experience > 0.0f) {
            class_2561 experienceString = class_2561.method_30163((String)(experience + " XP"));
            class_310 minecraft = class_310.method_1551();
            class_327 fontRenderer = minecraft.field_1772;
            int stringWidth = fontRenderer.method_27525((class_5348)experienceString);
            fontRenderer.method_30883(poseStack, experienceString, (float)(this.BACKGROUND.getWidth() - stringWidth), (float)y, -8355712);
        }
    }

    public void draw(FreezingRecipe recipe, IRecipeSlotsView recipeSlotsView, class_4587 poseStack, double mouseX, double mouseY) {
        this.animatedFreezeIcon.draw(poseStack, 1, 20);
        IDrawableAnimated arrow = this.getArrow(recipe);
        arrow.draw(poseStack, 24, 18);
        this.drawExperience(recipe, poseStack, 0);
        this.drawFreezeTime(recipe, poseStack, 45);
    }
}

