/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.blockentities;

import com.google.common.collect.Maps;
import com.unlikepaladin.pfm.blocks.Freezer;
import com.unlikepaladin.pfm.menus.FreezerScreenHandler;
import com.unlikepaladin.pfm.registry.BlockEntities;
import com.unlikepaladin.pfm.registry.RecipeTypes;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1662;
import net.minecraft.class_1703;
import net.minecraft.class_1732;
import net.minecraft.class_1737;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1860;
import net.minecraft.class_1874;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_5561;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class FreezerBlockEntity
extends class_2624
implements class_3908,
class_1278,
class_1732,
class_1737 {
    private final class_5561 stateManager = new class_5561(){

        protected void method_31681(class_1937 world, class_2338 pos, class_2680 state) {
            if (state.method_26204() instanceof Freezer) {
                FreezerBlockEntity.this.playSound(state, class_3417.field_15082);
                FreezerBlockEntity.this.setOpen(state, true);
            }
        }

        protected void method_31683(class_1937 world, class_2338 pos, class_2680 state) {
            if (state.method_26204() instanceof Freezer) {
                FreezerBlockEntity.this.playSound(state, class_3417.field_15131);
                FreezerBlockEntity.this.setOpen(state, false);
            }
        }

        protected void method_31682(class_1937 world, class_2338 pos, class_2680 state, int oldViewerCount, int newViewerCount) {
        }

        protected boolean method_31679(class_1657 player) {
            if (player.field_7512 instanceof FreezerScreenHandler) {
                class_1263 inventory = ((FreezerScreenHandler)player.field_7512).getInventory();
                return inventory == FreezerBlockEntity.this;
            }
            return false;
        }
    };
    private static final int[] TOP_SLOTS = new int[]{0};
    private static final int[] BOTTOM_SLOTS = new int[]{2, 1};
    private static final int[] SIDE_SLOTS = new int[]{1};
    private class_2371<class_1799> inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
    int fuelTime;
    int fuelTimeTotal;
    int freezeTime;
    int freezeTimeTotal;
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            switch (index) {
                case 0: {
                    return FreezerBlockEntity.this.fuelTime;
                }
                case 1: {
                    return FreezerBlockEntity.this.fuelTimeTotal;
                }
                case 2: {
                    return FreezerBlockEntity.this.freezeTime;
                }
                case 3: {
                    return FreezerBlockEntity.this.freezeTimeTotal;
                }
            }
            return 0;
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    FreezerBlockEntity.this.fuelTime = value;
                    break;
                }
                case 1: {
                    FreezerBlockEntity.this.fuelTimeTotal = value;
                    break;
                }
                case 2: {
                    FreezerBlockEntity.this.freezeTime = value;
                    break;
                }
                case 3: {
                    FreezerBlockEntity.this.freezeTimeTotal = value;
                }
            }
        }

        public int method_17389() {
            return 4;
        }
    };
    private final Object2IntOpenHashMap<class_2960> recipesUsed = new Object2IntOpenHashMap();
    private final class_3956<? extends class_1874> recipeType = RecipeTypes.FREEZING_RECIPE;

    public FreezerBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 state) {
        super(blockEntityType, pos, state);
    }

    public FreezerBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntities.FREEZER_BLOCK_ENTITY, pos, state);
    }

    public void method_5435(class_1657 player) {
        if (!this.field_11865 && !player.method_7325()) {
            this.stateManager.method_31684(player, this.method_10997(), this.method_11016(), this.method_11010());
        }
    }

    public void method_5432(class_1657 player) {
        if (!this.field_11865 && !player.method_7325()) {
            this.stateManager.method_31685(player, this.method_10997(), this.method_11016(), this.method_11010());
        }
    }

    public static Map<class_1792, Integer> createFuelTimeMap() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        FreezerBlockEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_1802.field_8543, 50);
        FreezerBlockEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_1802.field_8749, 62);
        FreezerBlockEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_1802.field_8246, 400);
        FreezerBlockEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_1802.field_8426, 1600);
        FreezerBlockEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_1802.field_8081, 14400);
        FreezerBlockEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_1802.field_8178, 129600);
        return map;
    }

    private boolean isActive() {
        return this.fuelTime > 0;
    }

    private static void addFuel(Map<class_1792, Integer> fuelTimes, class_6862<class_1792> tag, int fuelTime) {
        for (class_6880 registryEntry : class_2378.field_11142.method_40286(tag)) {
            fuelTimes.put((class_1792)registryEntry.comp_349(), fuelTime);
        }
    }

    private static void addFuel(Map<class_1792, Integer> fuelTimes, class_1935 item, int fuelTime) {
        class_1792 item2 = item.method_8389();
        fuelTimes.put(item2, fuelTime);
    }

    private static int getFreezeTime(class_1937 world, class_3956<? extends class_1874> recipeType, class_1263 inventory) {
        return world.method_8433().method_8132(recipeType, inventory, world).map(class_1874::method_8167).orElse(200);
    }

    public static boolean canUseAsFuel(class_1799 stack) {
        return FreezerBlockEntity.createFuelTimeMap().containsKey(stack.method_7909());
    }

    public int[] method_5494(class_2350 side) {
        if (side == class_2350.field_11033) {
            return BOTTOM_SLOTS;
        }
        if (side == class_2350.field_11036) {
            return TOP_SLOTS;
        }
        return SIDE_SLOTS;
    }

    public boolean method_5437(int slot, class_1799 stack) {
        if (slot == 2) {
            return false;
        }
        if (slot == 1) {
            class_1799 itemStack = (class_1799)this.inventory.get(1);
            return FreezerBlockEntity.canUseAsFuel(stack);
        }
        return true;
    }

    public void method_7683(class_1662 finder) {
        for (class_1799 itemStack : this.inventory) {
            finder.method_7400(itemStack);
        }
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        if (dir == class_2350.field_11033 && slot == 1) {
            return stack.method_31574(class_1802.field_8550);
        }
        return true;
    }

    public boolean method_5442() {
        for (class_1799 itemStack : this.inventory) {
            if (itemStack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        return class_1262.method_5430(this.inventory, (int)slot, (int)amount);
    }

    public class_1799 method_5441(int slot) {
        return class_1262.method_5428(this.inventory, (int)slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        class_1799 itemStack = (class_1799)this.inventory.get(slot);
        boolean bl = !stack.method_7960() && stack.method_7962(itemStack) && class_1799.method_7975((class_1799)stack, (class_1799)itemStack);
        this.inventory.set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        if (slot == 0 && !bl) {
            this.freezeTimeTotal = FreezerBlockEntity.getFreezeTime(this.field_11863, this.recipeType, (class_1263)this);
            this.freezeTime = 0;
            this.method_5431();
        }
    }

    public boolean method_5443(class_1657 player) {
        if (this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public void method_5448() {
        this.inventory.clear();
    }

    public void method_7662(@Nullable class_1860<?> recipe) {
        if (recipe != null) {
            class_2960 identifier = recipe.method_8114();
            this.recipesUsed.addTo((Object)identifier, 1);
        }
    }

    @Nullable
    public class_1860<?> method_7663() {
        return null;
    }

    public int method_5439() {
        return 3;
    }

    protected int getFuelTime(class_1799 fuel) {
        if (fuel.method_7960()) {
            return 0;
        }
        class_1792 item = fuel.method_7909();
        return FreezerBlockEntity.createFuelTimeMap().getOrDefault(item, 0);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.fuelTime = nbt.method_10568("BurnTime");
        this.freezeTime = nbt.method_10568("CookTime");
        this.freezeTimeTotal = nbt.method_10568("CookTimeTotal");
        this.fuelTimeTotal = this.getFuelTime((class_1799)this.inventory.get(1));
        class_2487 nbtCompound = nbt.method_10562("RecipesUsed");
        for (String string : nbtCompound.method_10541()) {
            this.recipesUsed.put((Object)new class_2960(string), nbtCompound.method_10550(string));
        }
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10575("FuelTimeLeft", (short)this.fuelTime);
        nbt.method_10575("FreezeTime", (short)this.freezeTime);
        nbt.method_10575("FreezeTimeTotal", (short)this.freezeTimeTotal);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        class_2487 nbtCompound = new class_2487();
        this.recipesUsed.forEach((identifier, integer) -> nbtCompound.method_10569(identifier.toString(), integer.intValue()));
        nbt.method_10566("RecipesUsed", (class_2520)nbtCompound);
    }

    void setOpen(class_2680 state, boolean open) {
        this.field_11863.method_8652(this.method_11016(), (class_2680)state.method_11657((class_2769)Freezer.OPEN, (Comparable)Boolean.valueOf(open)), 10);
    }

    void playSound(class_2680 state, class_3414 soundEvent) {
        class_2382 vec3i = ((class_2350)state.method_11654((class_2769)Freezer.FACING)).method_10163();
        double d = (double)this.field_11867.method_10263() + 0.5 + (double)vec3i.method_10263() / 2.0;
        double e = (double)this.field_11867.method_10264() + 0.5 + (double)vec3i.method_10264() / 2.0;
        double f = (double)this.field_11867.method_10260() + 0.5 + (double)vec3i.method_10260() / 2.0;
        this.field_11863.method_43128(null, d, e, f, soundEvent, class_3419.field_15245, 0.5f, this.field_11863.field_9229.method_43057() * 0.1f + 0.9f);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.pfm.freezer");
    }

    protected class_2561 method_17823() {
        return this.method_5476();
    }

    private static boolean canAcceptRecipeOutput(@Nullable class_1860<?> recipe, class_2371<class_1799> slots, int count) {
        if (((class_1799)slots.get(0)).method_7960() || recipe == null) {
            return false;
        }
        class_1799 itemStack = recipe.method_8110();
        if (itemStack.method_7960()) {
            return false;
        }
        class_1799 itemStack2 = (class_1799)slots.get(2);
        if (itemStack2.method_7960()) {
            return true;
        }
        if (!itemStack2.method_7962(itemStack)) {
            return false;
        }
        if (itemStack2.method_7947() < count && itemStack2.method_7947() < itemStack2.method_7914()) {
            return true;
        }
        return itemStack2.method_7947() < itemStack.method_7914();
    }

    private static boolean craftRecipe(@Nullable class_1860<?> recipe, class_2371<class_1799> slots, int count) {
        if (recipe == null || !FreezerBlockEntity.canAcceptRecipeOutput(recipe, slots, count)) {
            return false;
        }
        class_1799 itemStack = (class_1799)slots.get(0);
        class_1799 itemStack2 = recipe.method_8110();
        class_1799 itemStack3 = (class_1799)slots.get(2);
        if (itemStack2.method_31574(class_1802.field_8281) || itemStack2.method_31574(class_1802.field_8426) || itemStack2.method_31574(class_1802.field_8178)) {
            slots.set(0, (Object)new class_1799((class_1935)class_1802.field_8550));
        }
        if (itemStack3.method_7960()) {
            slots.set(2, (Object)itemStack2.method_7972());
        } else if (itemStack3.method_31574(itemStack2.method_7909())) {
            itemStack3.method_7933(1);
        }
        itemStack.method_7934(1);
        return true;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return this.method_5437(slot, stack);
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return this.method_5465(syncId, inv);
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return new FreezerScreenHandler(syncId, playerInventory, (class_1263)this, this.propertyDelegate);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, FreezerBlockEntity blockEntity) {
        boolean bl = blockEntity.isActive();
        boolean bl2 = false;
        if (blockEntity.isActive()) {
            --blockEntity.fuelTime;
        }
        class_1799 itemStack = (class_1799)blockEntity.inventory.get(1);
        if (blockEntity.isActive() || !itemStack.method_7960() && !((class_1799)blockEntity.inventory.get(0)).method_7960()) {
            class_1860 recipe = world.method_8433().method_8132(blockEntity.recipeType, (class_1263)blockEntity, world).orElse(null);
            int i = blockEntity.method_5444();
            if (!blockEntity.isActive() && FreezerBlockEntity.canAcceptRecipeOutput(recipe, blockEntity.inventory, i)) {
                blockEntity.fuelTimeTotal = blockEntity.fuelTime = blockEntity.getFuelTime(itemStack);
                if (blockEntity.isActive()) {
                    bl2 = true;
                    if (!itemStack.method_7960()) {
                        class_1792 item = itemStack.method_7909();
                        itemStack.method_7934(1);
                        if (itemStack.method_7960()) {
                            class_1792 item2 = item.method_7858();
                            blockEntity.inventory.set(1, (Object)(item2 == null ? class_1799.field_8037 : new class_1799((class_1935)item2)));
                        }
                    }
                }
            }
            if (blockEntity.isActive() && FreezerBlockEntity.canAcceptRecipeOutput(recipe, blockEntity.inventory, i)) {
                ++blockEntity.freezeTime;
                if (blockEntity.freezeTime == blockEntity.freezeTimeTotal) {
                    blockEntity.freezeTime = 0;
                    blockEntity.freezeTimeTotal = FreezerBlockEntity.getFreezeTime(world, blockEntity.recipeType, (class_1263)blockEntity);
                    if (FreezerBlockEntity.craftRecipe(recipe, blockEntity.inventory, i)) {
                        blockEntity.method_7662(recipe);
                    }
                    bl2 = true;
                }
            } else {
                blockEntity.freezeTime = 0;
            }
        } else if (!blockEntity.isActive() && blockEntity.freezeTime > 0) {
            blockEntity.freezeTime = class_3532.method_15340((int)(blockEntity.freezeTime - 2), (int)0, (int)blockEntity.freezeTimeTotal);
        }
        if (bl != blockEntity.isActive()) {
            bl2 = true;
        }
        if (bl2) {
            FreezerBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
        }
    }
}

