/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2275;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3614;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5556;
import net.minecraft.class_5620;
import net.minecraft.class_5819;

public class KitchenSink
extends class_2275
implements class_3737 {
    private final class_2680 baseBlockState;
    private final class_2248 baseBlock;
    private final Predicate<class_1959.class_1963> precipitationPredicate;
    public static final class_2758 LEVEL_4 = class_2758.method_11867((String)"level", (int)0, (int)3);
    private final Map<class_1792, class_5620> behaviorMap;
    private static final List<FurnitureBlock> WOOD_SINKS = new ArrayList<FurnitureBlock>();
    private static final List<FurnitureBlock> STONE_SINKS = new ArrayList<FurnitureBlock>();
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private static final class_265 FACING_NORTH = class_259.method_1072((class_265)class_259.method_1084((class_265)class_259.method_1077(), (class_265)KitchenSink.method_9541((double)1.0625, (double)11.3, (double)0.296, (double)15.0625, (double)16.3, (double)12.296)), (class_265)class_259.method_17786((class_265)KitchenSink.method_9541((double)2.0, (double)11.0, (double)2.3, (double)14.0, (double)16.3, (double)11.3), (class_265[])new class_265[]{KitchenSink.method_9541((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)14.0, (double)16.0), KitchenSink.method_9541((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)1.0, (double)13.0)}), (class_247)class_247.field_16886);
    private static final class_265 FACING_EAST = class_259.method_1072((class_265)class_259.method_1084((class_265)class_259.method_1077(), (class_265)KitchenSink.method_9541((double)3.704, (double)11.3, (double)1.0625, (double)15.704, (double)16.3, (double)15.0625)), (class_265)class_259.method_17786((class_265)KitchenSink.method_9541((double)4.7, (double)11.0, (double)2.0, (double)13.7, (double)16.3, (double)14.0), (class_265[])new class_265[]{KitchenSink.method_9541((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)14.0, (double)16.0), KitchenSink.method_9541((double)3.0, (double)0.0, (double)0.0, (double)4.0, (double)1.0, (double)16.0)}), (class_247)class_247.field_16886);
    private static final class_265 FACING_SOUTH = class_259.method_1072((class_265)class_259.method_1084((class_265)class_259.method_1077(), (class_265)KitchenSink.method_9541((double)0.9375, (double)11.3, (double)3.704, (double)14.9375, (double)16.3, (double)15.704)), (class_265)class_259.method_17786((class_265)KitchenSink.method_9541((double)2.0, (double)11.0, (double)4.7, (double)14.0, (double)16.3, (double)13.7), (class_265[])new class_265[]{KitchenSink.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)3.0), KitchenSink.method_9541((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)4.0)}), (class_247)class_247.field_16886);
    private static final class_265 FACING_WEST = class_259.method_1072((class_265)class_259.method_1084((class_265)class_259.method_1077(), (class_265)KitchenSink.method_9541((double)0.296, (double)11.3, (double)0.9375, (double)12.296, (double)16.3, (double)14.9375)), (class_265)class_259.method_17786((class_265)KitchenSink.method_9541((double)2.3, (double)11.0, (double)2.0, (double)11.3, (double)16.3, (double)14.0), (class_265[])new class_265[]{KitchenSink.method_9541((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), KitchenSink.method_9541((double)12.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)16.0)}), (class_247)class_247.field_16886);

    public KitchenSink(class_4970.class_2251 settings, Predicate<class_1959.class_1963> precipitationPredicate, Map<class_1792, class_5620> map) {
        super(settings, map);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043)).method_11657((class_2769)LEVEL_4, (Comparable)Integer.valueOf(0))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.baseBlockState = this.method_9564();
        this.precipitationPredicate = precipitationPredicate;
        this.behaviorMap = map;
        this.baseBlock = this.baseBlockState.method_26204();
        if ((this.field_23158.equals(class_3614.field_15932) || this.field_23158.equals(class_3614.field_22223)) && ((Object)((Object)this)).getClass().isAssignableFrom(KitchenSink.class)) {
            WOOD_SINKS.add(new FurnitureBlock((class_2248)this, "kitchen_sink"));
        } else if (((Object)((Object)this)).getClass().isAssignableFrom(KitchenSink.class)) {
            STONE_SINKS.add(new FurnitureBlock((class_2248)this, "kitchen_sink"));
        }
    }

    public static Stream<FurnitureBlock> streamWoodSinks() {
        return WOOD_SINKS.stream();
    }

    public static Stream<FurnitureBlock> streamStoneSinks() {
        return STONE_SINKS.stream();
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateManager) {
        stateManager.method_11667(new class_2769[]{class_2741.field_12481});
        stateManager.method_11667(new class_2769[]{LEVEL_4});
        stateManager.method_11667(new class_2769[]{WATERLOGGED});
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)ctx.method_8042())).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.method_8045().method_8316(ctx.method_8037()).method_15772() == class_3612.field_15910));
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2680 sourceState;
        class_2338 sourcePos = pos.method_10074().method_10074();
        if ((Integer)state.method_11654((class_2769)LEVEL_4) == 0 && (sourceState = world.method_8320(sourcePos)).method_26227().method_15772() == class_3612.field_15910 && !sourceState.method_26227().method_15769()) {
            if (sourceState.method_28501().contains(class_2741.field_12508)) {
                world.method_8501(sourcePos, (class_2680)sourceState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)));
            } else {
                world.method_8501(sourcePos, class_2246.field_10124.method_9564());
            }
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)LEVEL_4, (Comparable)Integer.valueOf(3)));
            return class_1269.field_5812;
        }
        class_1799 itemStack = player.method_5998(hand);
        class_5620 sinkBehavior = this.behaviorMap.get(itemStack.method_7909());
        return sinkBehavior.interact(state, world, pos, player, hand, itemStack);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 dir = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
        return switch (dir) {
            case class_2350.field_11043 -> FACING_NORTH;
            case class_2350.field_11035 -> FACING_SOUTH;
            case class_2350.field_11034 -> FACING_EAST;
            default -> FACING_WEST;
        };
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 dir = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
        return switch (dir) {
            case class_2350.field_11043 -> FACING_NORTH;
            case class_2350.field_11035 -> FACING_SOUTH;
            case class_2350.field_11034 -> FACING_EAST;
            default -> FACING_WEST;
        };
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (!world.field_9236 && entity.method_5809() && this.method_31616(state, pos, entity)) {
            entity.method_5646();
            if (entity.method_36971(world, pos)) {
                this.onFireCollision(state, world, pos);
            }
        }
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        super.method_9496(state, world, pos, random);
    }

    protected void onFireCollision(class_2680 state, class_1937 world, class_2338 pos) {
        KitchenSink.decrementFluidLevel(state, world, pos);
    }

    public static void decrementFluidLevel(class_2680 state, class_1937 world, class_2338 pos) {
        int i = (Integer)state.method_11654((class_2769)LEVEL_4) - 1;
        world.method_8501(pos, (class_2680)state.method_11657((class_2769)LEVEL_4, (Comparable)Integer.valueOf(i)));
    }

    public boolean method_32766(class_2680 state) {
        return (Integer)state.method_11654((class_2769)LEVEL_4) == 3;
    }

    protected boolean method_32765(class_3611 fluid) {
        return fluid == class_3612.field_15910 && this.precipitationPredicate == class_5556.field_27880;
    }

    protected double method_31615(class_2680 state) {
        return (6.0 + (double)((Integer)state.method_11654((class_2769)LEVEL_4)).intValue() * 3.0) / 16.0;
    }

    protected static boolean canFillWithPrecipitation(class_1937 world, class_1959.class_1963 precipitation) {
        if (precipitation == class_1959.class_1963.field_9382) {
            return world.method_8409().method_43057() < 0.05f;
        }
        if (precipitation == class_1959.class_1963.field_9383) {
            return world.method_8409().method_43057() < 0.1f;
        }
        return false;
    }

    public void method_9504(class_2680 state, class_1937 world, class_2338 pos, class_1959.class_1963 precipitation) {
        if (!KitchenSink.canFillWithPrecipitation(world, precipitation) || (Integer)state.method_11654((class_2769)LEVEL_4) == 3 || !this.precipitationPredicate.test(precipitation)) {
            return;
        }
        world.method_8501(pos, (class_2680)state.method_28493((class_2769)LEVEL_4));
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return (Integer)state.method_11654((class_2769)LEVEL_4);
    }

    protected void method_32764(class_2680 state, class_1937 world, class_2338 pos, class_3611 fluid) {
        if (this.method_32766(state)) {
            return;
        }
        world.method_8501(pos, (class_2680)state.method_11657((class_2769)LEVEL_4, (Comparable)Integer.valueOf((Integer)state.method_11654((class_2769)LEVEL_4) + 1)));
        world.method_20290(1047, pos, 0);
    }

    public int getFlammability(class_2680 state, class_1922 world, class_2338 pos, class_2350 face) {
        if (state.method_26207() == class_3614.field_15932 || state.method_26207() == class_3614.field_15931) {
            return 20;
        }
        return 0;
    }
}

