/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.ratsmischief.common;

import io.github.ladysnake.pal.AbilitySource;
import io.github.ladysnake.pal.Pal;
import io.github.ladysnake.pal.PlayerAbility;
import io.github.ladysnake.pal.VanillaAbilities;
import ladysnake.ratsmischief.common.Mischief;
import ladysnake.ratsmischief.common.entity.RatEntity;
import ladysnake.requiem.api.v1.possession.PossessionComponent;
import ladysnake.requiem.api.v1.remnant.MobResurrectable;
import ladysnake.requiem.api.v1.remnant.RemnantState;
import ladysnake.requiem.api.v1.remnant.RemnantType;
import ladysnake.requiem.core.entity.SoulHolderComponent;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class RatifiedRemnantType
implements RemnantType {
    private final class_2561 name = class_2561.method_43471((String)"ratsmischief:remnant_type.name");

    @NotNull
    public RemnantState create(class_1657 player) {
        return new RatifiedRemnantState(player);
    }

    public boolean isDemon() {
        return false;
    }

    @NotNull
    public class_2561 getName() {
        return this.name;
    }

    public static class RatifiedRemnantState
    implements RemnantState {
        public static final AbilitySource SOUL_STATE = Pal.getAbilitySource((class_2960)new class_2960("mischief", "soul_state"));
        private final class_1657 player;
        private boolean removed;

        public RatifiedRemnantState(class_1657 player) {
            this.player = player;
        }

        public void setup(RemnantState oldHandler) {
            if (!this.player.field_6002.field_9236) {
                Pal.grantAbility((class_1657)this.player, (PlayerAbility)VanillaAbilities.INVULNERABLE, (AbilitySource)SOUL_STATE);
                if (this.isInWorld()) {
                    PossessionComponent.get((class_1657)this.player).stopPossessing(false);
                    RatEntity rat = new RatEntity(Mischief.RAT, this.player.field_6002);
                    SoulHolderComponent.get((class_1309)rat).removeSoul();
                    rat.method_5719((class_1297)this.player);
                    this.player.field_6002.method_8649((class_1297)rat);
                    PossessionComponent.get((class_1657)this.player).startPossessing((class_1308)rat);
                }
            }
        }

        private boolean isInWorld() {
            return this.player.field_6002.method_8469(this.player.method_5628()) == this.player;
        }

        public void teardown(RemnantState newHandler) {
            if (!this.player.field_6002.field_9236) {
                PossessionComponent possessionComponent;
                class_1308 rat;
                Pal.revokeAbility((class_1657)this.player, (PlayerAbility)VanillaAbilities.INVULNERABLE, (AbilitySource)SOUL_STATE);
                if (this.isInWorld() && (rat = (possessionComponent = PossessionComponent.get((class_1657)this.player)).getHost()) != null) {
                    rat.method_5650(class_1297.class_5529.field_26999);
                    possessionComponent.stopPossessing(false);
                    this.removed = true;
                }
            }
        }

        public boolean isIncorporeal() {
            return !PossessionComponent.get((class_1657)this.player).isPossessionOngoing();
        }

        public boolean isVagrant() {
            return !this.removed;
        }

        public boolean setVagrant(boolean vagrant) {
            return false;
        }

        public boolean canDissociateFrom(class_1308 possessed) {
            return false;
        }

        public void prepareRespawn(class_3222 original, boolean lossless) {
            ((MobResurrectable)this.player).setResurrectionEntity((class_1308)new RatEntity(Mischief.RAT, this.player.field_6002));
        }

        public void serverTick() {
            class_1308 possessedEntity = PossessionComponent.get((class_1657)this.player).getHost();
            if (possessedEntity instanceof RatEntity) {
                RatEntity rat = (RatEntity)possessedEntity;
                rat.setEating(this.player.method_6115());
            } else {
                this.player.method_5768();
            }
        }
    }
}

