/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.ratsmischief.common;

import com.mojang.brigadier.CommandDispatcher;
import java.util.function.Consumer;
import ladysnake.ratsmischief.common.RatifiedRemnantType;
import ladysnake.ratsmischief.common.command.PlayerRatifyCommand;
import ladysnake.ratsmischief.common.command.PlayerUnratifyCommand;
import ladysnake.ratsmischief.common.entity.RatEntity;
import ladysnake.requiem.api.v1.RequiemPlugin;
import ladysnake.requiem.api.v1.event.requiem.HumanityCheckCallback;
import ladysnake.requiem.api.v1.event.requiem.PossessionStartCallback;
import ladysnake.requiem.api.v1.remnant.RemnantComponent;
import ladysnake.requiem.api.v1.remnant.RemnantType;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class MischiefRequiemPlugin
implements RequiemPlugin {
    public static final RatifiedRemnantType RATIFIED_REMNANT_TYPE = new RatifiedRemnantType();

    public void onRequiemInitialize() {
        PossessionStartCallback.EVENT.register(new class_2960("ratsmischief:possession"), (mobEntity, playerEntity, b) -> {
            if (mobEntity instanceof RatEntity && RemnantComponent.get((class_1657)playerEntity).getRemnantType() == RATIFIED_REMNANT_TYPE) {
                return PossessionStartCallback.Result.ALLOW;
            }
            return PossessionStartCallback.Result.PASS;
        });
        HumanityCheckCallback.EVENT.register(livingEntity -> {
            if (livingEntity instanceof RatEntity) {
                return 9999;
            }
            return 0;
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            PlayerRatifyCommand.register((CommandDispatcher<class_2168>)dispatcher);
            PlayerUnratifyCommand.register((CommandDispatcher<class_2168>)dispatcher);
        });
    }

    public void registerRemnantStates(class_2378<RemnantType> registry) {
        class_2378.method_10230(registry, (class_2960)new class_2960("ratsmischief:ratified"), (Object)RATIFIED_REMNANT_TYPE);
        PlayerRatifyCommand.action = this.changeState(RATIFIED_REMNANT_TYPE);
        PlayerUnratifyCommand.action = this.changeState((RemnantType)registry.method_10223((class_2960)null));
    }

    public Consumer<class_1657> changeState(RemnantType type) {
        return player -> RemnantComponent.get((class_1657)player).become(type, true);
    }
}

