/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.ratsmischief.client.model;

import java.util.Locale;
import ladysnake.ratsmischief.common.entity.RatEntity;
import net.minecraft.class_1767;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;

public class RatEntityModel
extends AnimatedGeoModel<RatEntity> {
    private static final class_2960 MODEL_LOCATION = new class_2960("ratsmischief", "geo/entity/rat.geo.json");
    private static final class_2960 ANIMATION_LOCATION = new class_2960("ratsmischief", "animations/entity/rat.animation.json");
    private static final class_2960 REMY_TEXTURE = new class_2960("ratsmischief", "textures/entity/named/remy.png");
    private static class_2960[] RAT_KID_TEXTURES;

    public class_2960 getModelResource(RatEntity rat) {
        return MODEL_LOCATION;
    }

    public class_2960 getTextureResource(RatEntity rat) {
        if (RAT_KID_TEXTURES == null) {
            RAT_KID_TEXTURES = new class_2960[16];
            for (class_1767 color : class_1767.values()) {
                RatEntityModel.RAT_KID_TEXTURES[color.method_7789()] = new class_2960("ratsmischief", "textures/entity/rat_kid/rat_kid_" + color.method_7792().toLowerCase(Locale.ROOT) + ".png");
            }
        }
        if (rat.getRatType() == RatEntity.Type.RUSSIAN_BLUE && rat.method_16914() && rat.method_5797().getString().equalsIgnoreCase("remy")) {
            return REMY_TEXTURE;
        }
        if (rat.getRatType() == RatEntity.Type.RAT_KID) {
            return RAT_KID_TEXTURES[rat.getRatColor().method_7789()];
        }
        return rat.getRatType().ratTexture;
    }

    public class_2960 getAnimationResource(RatEntity rat) {
        return ANIMATION_LOCATION;
    }

    public void setLivingAnimations(RatEntity entity, Integer uniqueID, AnimationEvent customPredicate) {
        IBone root;
        super.setLivingAnimations((IAnimatable)entity, uniqueID, customPredicate);
        IBone head = this.getAnimationProcessor().getBone("head");
        IBone rocket = this.getAnimationProcessor().getBone("rocket");
        IBone leftWing = this.getAnimationProcessor().getBone("left");
        IBone rightWing = this.getAnimationProcessor().getBone("right");
        if (entity.isFlying()) {
            IBone body;
            if (leftWing != null && rightWing != null) {
                leftWing.setRotationY((float)class_3532.method_15350((double)(-(entity.method_18798().method_10214() * 2.0) - 1.0), (double)-1.0, (double)0.0));
                rightWing.setRotationY((float)class_3532.method_15350((double)(entity.method_18798().method_10214() * 2.0 + 1.0), (double)0.0, (double)1.0));
            }
            if ((body = this.getAnimationProcessor().getBone("root")) != null) {
                body.setRotationX((float)entity.method_18798().method_10214());
            }
            if (rocket != null) {
                rocket.setHidden(false);
            }
        } else if (head != null && !entity.isSniffing() && !entity.isEating()) {
            head.setRotationX(-entity.method_36455() * ((float)Math.PI / 180));
            if (rocket != null) {
                rocket.setHidden(true);
            }
        }
        if (entity.method_6109() && (root = this.getAnimationProcessor().getBone("root")) != null) {
            root.setScaleX(0.5f);
            root.setScaleY(0.5f);
            root.setScaleZ(0.5f);
        }
    }
}

