/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.ratsmischief.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import ladysnake.ratsmischief.common.Mischief;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1060;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_636;
import net.minecraft.class_6382;
import net.minecraft.class_757;
import net.minecraft.class_918;

@Environment(value=EnvType.CLIENT)
public class StaffCommandSelectionScreen
extends class_437 {
    static final class_2960 TEXTURE = new class_2960("textures/gui/container/gamemode_switcher.png");
    private static final int field_32310 = 128;
    private static final int field_32311 = 128;
    private static final int field_32312 = 26;
    private static final int field_32313 = 5;
    private static final int field_32314 = 31;
    private static final int field_32315 = 5;
    private static final int UI_WIDTH = GameMode.values().length * 31 - 5;
    private static final class_2561 SELECT_NEXT_TEXT = class_2561.method_43469((String)"debug.gamemodes.select_next", (Object[])new Object[]{class_2561.method_43471((String)"debug.gamemodes.press_f4").method_27692(class_124.field_1075)});
    private final Optional<GameMode> currentGameMode = GameMode.of(this.getPreviousGameMode());
    private final List<ButtonWidget> gameModeButtons = Lists.newArrayList();
    private Optional<GameMode> gameMode = Optional.empty();
    private int lastMouseX;
    private int lastMouseY;
    private boolean mouseUsedForSelection;

    public StaffCommandSelectionScreen() {
        super((class_2561)class_2561.method_43473());
    }

    private static void apply(class_310 client, Optional<GameMode> gameMode) {
        if (client.field_1761 != null && client.field_1724 != null && gameMode.isPresent()) {
            Optional<GameMode> optional = GameMode.of(client.field_1761.method_2920());
            GameMode gameMode2 = gameMode.get();
            if (optional.isPresent() && client.field_1724.method_5687(2) && gameMode2 != optional.get()) {
                client.field_1724.method_44099(gameMode2.getCommand());
            }
        }
    }

    private class_1934 getPreviousGameMode() {
        class_636 clientPlayerInteractionManager = class_310.method_1551().field_1761;
        class_1934 gameMode = clientPlayerInteractionManager.method_28107();
        if (gameMode != null) {
            return gameMode;
        }
        return clientPlayerInteractionManager.method_2920() == class_1934.field_9220 ? class_1934.field_9215 : class_1934.field_9220;
    }

    protected void method_25426() {
        super.method_25426();
        this.gameMode = this.currentGameMode.isPresent() ? this.currentGameMode : GameMode.of(this.field_22787.field_1761.method_2920());
        for (int i = 0; i < GameMode.VALUES.length; ++i) {
            GameMode gameMode = GameMode.VALUES[i];
            this.gameModeButtons.add(new ButtonWidget(gameMode, this.field_22789 / 2 - UI_WIDTH / 2 + i * 31, this.field_22790 / 2 - 31));
        }
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (!this.checkForClose()) {
            RenderSystem.setShader(class_757::method_34542);
            matrices.method_22903();
            RenderSystem.enableBlend();
            RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
            int i = this.field_22789 / 2 - 62;
            int j = this.field_22790 / 2 - 31 - 27;
            StaffCommandSelectionScreen.method_25290((class_4587)matrices, (int)i, (int)j, (float)0.0f, (float)0.0f, (int)125, (int)75, (int)128, (int)128);
            matrices.method_22909();
            super.method_25394(matrices, mouseX, mouseY, delta);
            this.gameMode.ifPresent(gameMode -> StaffCommandSelectionScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)gameMode.getText(), (int)(this.field_22789 / 2), (int)(this.field_22790 / 2 - 31 - 20), (int)-1));
            StaffCommandSelectionScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)SELECT_NEXT_TEXT, (int)(this.field_22789 / 2), (int)(this.field_22790 / 2 + 5), (int)0xFFFFFF);
            if (!this.mouseUsedForSelection) {
                this.lastMouseX = mouseX;
                this.lastMouseY = mouseY;
                this.mouseUsedForSelection = true;
            }
            boolean bl = this.lastMouseX == mouseX && this.lastMouseY == mouseY;
            for (ButtonWidget buttonWidget : this.gameModeButtons) {
                buttonWidget.method_25394(matrices, mouseX, mouseY, delta);
                this.gameMode.ifPresent(gameMode -> buttonWidget.method_25365(gameMode == buttonWidget.gameMode));
                if (bl || !buttonWidget.method_25367()) continue;
                this.gameMode = Optional.of(buttonWidget.gameMode);
            }
        }
    }

    private void apply() {
        StaffCommandSelectionScreen.apply(this.field_22787, this.gameMode);
    }

    private boolean checkForClose() {
        if (class_3675.method_15987((long)this.field_22787.method_22683().method_4490(), (int)257)) {
            this.apply();
            this.field_22787.method_1507((class_437)null);
            return true;
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 293 && this.gameMode.isPresent()) {
            this.mouseUsedForSelection = false;
            this.gameMode = this.gameMode.get().next();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25421() {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    private static enum GameMode {
        CREATIVE((class_2561)class_2561.method_43471((String)"gameMode.creative"), "/gamemode creative", new class_1799((class_1935)Mischief.HARVEST_STAFF)),
        SURVIVAL((class_2561)class_2561.method_43471((String)"gameMode.survival"), "/gamemode survival", new class_1799((class_1935)Mischief.COLLECTION_STAFF)),
        ADVENTURE((class_2561)class_2561.method_43471((String)"gameMode.adventure"), "/gamemode adventure", new class_1799((class_1935)Mischief.LOVE_STAFF)),
        SPECTATOR((class_2561)class_2561.method_43471((String)"gameMode.spectator"), "/gamemode spectator", new class_1799((class_1935)class_1802.field_8077));

        protected static final GameMode[] VALUES;
        protected static final int field_32316 = 5;
        private static final int field_32317 = 16;
        final class_2561 text;
        final String command;
        final class_1799 icon;

        private GameMode(class_2561 text, String command, class_1799 icon) {
            this.text = text;
            this.command = command;
            this.icon = icon;
        }

        static Optional<GameMode> of(class_1934 gameMode) {
            switch (gameMode) {
                case field_9219: {
                    return Optional.of(SPECTATOR);
                }
                case field_9215: {
                    return Optional.of(SURVIVAL);
                }
                case field_9220: {
                    return Optional.of(CREATIVE);
                }
                case field_9216: {
                    return Optional.of(ADVENTURE);
                }
            }
            return Optional.empty();
        }

        void renderIcon(class_918 itemRenderer, int x, int y) {
            itemRenderer.method_4023(this.icon, x, y);
        }

        class_2561 getText() {
            return this.text;
        }

        String getCommand() {
            return this.command;
        }

        Optional<GameMode> next() {
            switch (this) {
                case CREATIVE: {
                    return Optional.of(SURVIVAL);
                }
                case SURVIVAL: {
                    return Optional.of(ADVENTURE);
                }
                case ADVENTURE: {
                    return Optional.of(SPECTATOR);
                }
            }
            return Optional.of(CREATIVE);
        }

        static {
            VALUES = GameMode.values();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class ButtonWidget
    extends class_339 {
        final GameMode gameMode;
        private boolean selected;

        public ButtonWidget(GameMode gameMode, int x, int y) {
            super(x, y, 26, 26, gameMode.getText());
            this.gameMode = gameMode;
        }

        public void method_25359(class_4587 matrices, int mouseX, int mouseY, float delta) {
            class_310 minecraftClient = class_310.method_1551();
            this.drawBackground(matrices, minecraftClient.method_1531());
            this.gameMode.renderIcon(StaffCommandSelectionScreen.this.field_22788, this.field_22760 + 5, this.field_22761 + 5);
            if (this.selected) {
                this.drawSelectionBox(matrices, minecraftClient.method_1531());
            }
        }

        public void method_37020(class_6382 builder) {
            this.method_37021(builder);
        }

        public boolean method_25367() {
            return super.method_25367() || this.selected;
        }

        public void method_25365(boolean selected) {
            this.selected = selected;
        }

        private void drawBackground(class_4587 matrices, class_1060 textureManager) {
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
            matrices.method_22903();
            matrices.method_22904((double)this.field_22760, (double)this.field_22761, 0.0);
            ButtonWidget.method_25290((class_4587)matrices, (int)0, (int)0, (float)0.0f, (float)75.0f, (int)26, (int)26, (int)128, (int)128);
            matrices.method_22909();
        }

        private void drawSelectionBox(class_4587 matrices, class_1060 textureManager) {
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
            matrices.method_22903();
            matrices.method_22904((double)this.field_22760, (double)this.field_22761, 0.0);
            ButtonWidget.method_25290((class_4587)matrices, (int)0, (int)0, (float)26.0f, (float)75.0f, (int)26, (int)26, (int)128, (int)128);
            matrices.method_22909();
        }
    }
}

