/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.compat;

import ht.treechop.api.TreeData;
import ht.treechop.client.Client;
import ht.treechop.common.block.ChoppedLogBlock;
import ht.treechop.common.chop.ChopUtil;
import ht.treechop.common.config.ConfigHandler;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.ITooltipLine;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.component.ItemComponent;
import mcp.mobius.waila.api.component.WrappedComponent;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;

public class Wthit
implements IWailaPlugin,
IBlockComponentProvider {
    public static final class_2960 SHOW_TREE_BLOCKS = new class_2960("treechop", "show_tree_block_counts");
    public static final class_2960 SHOW_NUM_CHOPS_REMAINING = new class_2960("treechop", "show_num_chops_remaining");
    private static final Wthit INSTANCE = new Wthit();

    public void register(IRegistrar registrar) {
        registrar.addConfig(SHOW_TREE_BLOCKS, true);
        registrar.addConfig(SHOW_NUM_CHOPS_REMAINING, true);
        registrar.addComponent((IBlockComponentProvider)INSTANCE, TooltipPosition.BODY, class_2248.class);
        registrar.addOverride((IBlockComponentProvider)INSTANCE, ChoppedLogBlock.class);
    }

    @Nullable
    public class_2680 getOverride(IBlockAccessor accessor, IPluginConfig config) {
        return this.getLogState(accessor.getWorld(), accessor.getPosition(), accessor.getBlockState());
    }

    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        if (ChopUtil.playerWantsToChop(accessor.getPlayer()) && ChopUtil.isBlockChoppable((class_1922)accessor.getWorld(), accessor.getPosition(), accessor.getBlockState()) && (config.getBoolean(SHOW_TREE_BLOCKS) || config.getBoolean(SHOW_NUM_CHOPS_REMAINING))) {
            class_1937 level = accessor.getWorld();
            AtomicInteger numChops = new AtomicInteger(0);
            int maxNumTreeBlocks = (Integer)ConfigHandler.COMMON.maxNumTreeBlocks.get();
            TreeData tree = Client.treeCache.getTree(level, accessor.getPosition(), maxNumTreeBlocks);
            if (tree.isAProperTree(Client.getChopSettings().getTreesMustHaveLeaves())) {
                tree.getLogBlocks().ifPresent(treeBlocks -> {
                    if (config.getBoolean(SHOW_NUM_CHOPS_REMAINING)) {
                        treeBlocks.forEach(pos -> numChops.getAndAdd(ChopUtil.getNumChops(level, pos)));
                        tooltip.addLine((ITooltipComponent)new WrappedComponent((class_2561)class_2561.method_43469((String)"treechop.waila.x_out_of_y_chops", (Object[])new Object[]{numChops.get(), ChopUtil.numChopsToFell(level, treeBlocks)})));
                    }
                    if (config.getBoolean(SHOW_TREE_BLOCKS)) {
                        ITooltipLine line = tooltip.addLine();
                        treeBlocks.stream().collect(Collectors.groupingBy(pos -> {
                            class_2680 state = level.method_8320(pos);
                            return this.getLogState(level, (class_2338)pos, state).method_26204();
                        }, Collectors.counting())).forEach((block, count) -> {
                            class_1799 stack = block.method_8389().method_7854();
                            stack.method_7939(count.intValue());
                            line.with((ITooltipComponent)new ItemComponent(stack));
                        });
                    }
                });
            }
        }
    }

    private class_2680 getLogState(class_1937 level, class_2338 pos, class_2680 state) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof ChoppedLogBlock.MyEntity) {
            ChoppedLogBlock.MyEntity entity = (ChoppedLogBlock.MyEntity)class_25862;
            return entity.getOriginalState();
        }
        return state;
    }
}

