/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.compat;

import ht.treechop.TreeChop;
import ht.treechop.api.TreeData;
import ht.treechop.client.Client;
import ht.treechop.common.block.ChoppedLogBlock;
import ht.treechop.common.chop.ChopUtil;
import ht.treechop.common.config.ConfigHandler;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;

@WailaPlugin
public class Jade
implements IWailaPlugin,
IBlockComponentProvider {
    public static final class_2960 SHOW_TREE_BLOCKS = new class_2960("treechop", "show_tree_block_counts");
    public static final class_2960 SHOW_NUM_CHOPS_REMAINING = new class_2960("treechop", "show_num_chops_remaining");
    private static final class_2960 UID = TreeChop.resource("plugin");

    public void registerClient(IWailaClientRegistration registrar) {
        registrar.registerBlockComponent((IBlockComponentProvider)this, class_2248.class);
        registrar.registerBlockIcon((IBlockComponentProvider)this, ChoppedLogBlock.class);
        registrar.addConfig(SHOW_TREE_BLOCKS, true);
        registrar.addConfig(SHOW_NUM_CHOPS_REMAINING, true);
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (ChopUtil.playerWantsToChop(accessor.getPlayer(), Client.getChopSettings()) && ChopUtil.isBlockChoppable((class_1922)accessor.getLevel(), accessor.getPosition(), accessor.getBlockState()) && (config.get(SHOW_TREE_BLOCKS) || config.get(SHOW_NUM_CHOPS_REMAINING))) {
            class_1937 level = accessor.getLevel();
            AtomicInteger numChops = new AtomicInteger(0);
            int maxNumTreeBlocks = (Integer)ConfigHandler.COMMON.maxNumTreeBlocks.get();
            TreeData tree = Client.treeCache.getTree(level, accessor.getPosition(), maxNumTreeBlocks);
            if (tree.isAProperTree(Client.getChopSettings().getTreesMustHaveLeaves())) {
                tree.getLogBlocks().ifPresent(treeBlocks -> {
                    if (config.get(SHOW_NUM_CHOPS_REMAINING)) {
                        treeBlocks.forEach(pos -> numChops.getAndAdd(ChopUtil.getNumChops(level, pos)));
                        tooltip.add((class_2561)class_2561.method_43469((String)"treechop.waila.x_out_of_y_chops", (Object[])new Object[]{numChops.get(), ChopUtil.numChopsToFell(level, treeBlocks)}));
                    }
                    if (config.get(SHOW_TREE_BLOCKS)) {
                        LinkedList tiles = new LinkedList();
                        treeBlocks.stream().collect(Collectors.groupingBy(pos -> {
                            class_2680 state = level.method_8320(pos);
                            return this.getLogState(level, (class_2338)pos, state).method_26204();
                        }, Collectors.counting())).forEach((block, count) -> {
                            IElement icon = tooltip.getElementHelper().item(block.method_8389().method_7854(), 1.0f, count.toString());
                            tiles.add(icon.translate(new class_241(0.0f, -1.5f)));
                        });
                        tooltip.add(tiles);
                    }
                });
            }
        }
    }

    private class_2680 getLogState(class_1937 level, class_2338 pos, class_2680 state) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof ChoppedLogBlock.MyEntity) {
            ChoppedLogBlock.MyEntity entity = (ChoppedLogBlock.MyEntity)class_25862;
            return entity.getOriginalState();
        }
        return state;
    }

    public class_2960 getUid() {
        return UID;
    }
}

