/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.properties;

import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.util.FaceShape;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3542;

public enum ChoppedLogShape implements class_3542
{
    PILLAR_Y("pillar", 60),
    CORNER_NWEU("corner_nweu", 54),
    CORNER_NWED("corner_nwed", 53),
    CORNER_NSWU("corner_nswu", 30),
    CORNER_NSWD("corner_nswd", 29),
    CORNER_NWUD("corner_nwud", 23),
    CORNER_SWEU("corner_sweu", 58),
    CORNER_SWED("corner_swed", 57),
    PILLAR_Z("pillar_z", 51),
    CORNER_SWUD("corner_swud", 27),
    CORNER_NSEU("corner_nseu", 46),
    CORNER_NSED("corner_nsed", 45),
    CORNER_NEUD("corner_neud", 39),
    PILLAR_X("pillar_x", 15),
    CORNER_SEUD("corner_seud", 43),
    END_N("end_n", 52),
    END_W("end_w", 28),
    CORNER_NWU("corner_nwu", 22),
    CORNER_NWD("corner_nwd", 21),
    END_S("end_s", 56),
    CORNER_WEU("corner_weu", 50),
    CORNER_WED("corner_wed", 49),
    CORNER_SWU("corner_swu", 26),
    CORNER_SWD("corner_swd", 25),
    CORNER_WUD("corner_wud", 19),
    END_E("end_e", 44),
    CORNER_NEU("corner_neu", 38),
    CORNER_NED("corner_ned", 37),
    END_U("end_u", 14),
    END_D("end_d", 13),
    CORNER_NUD("corner_nud", 7),
    CORNER_SEU("corner_seu", 42),
    CORNER_SED("corner_sed", 41),
    CORNER_EUD("corner_eud", 35),
    CORNER_SUD("corner_sud", 11),
    CORNER_NW("corner_nw", 20),
    SLAB_YZ("slab_yz", 48),
    CORNER_SW("corner_sw", 24),
    CORNER_WU("corner_wu", 18),
    CORNER_WD("corner_wd", 17),
    CORNER_NE("corner_ne", 36),
    SLAB_XY("slab_xy", 12),
    CORNER_NU("corner_nu", 6),
    CORNER_ND("corner_nd", 5),
    CORNER_SE("corner_se", 40),
    CORNER_EU("corner_eu", 34),
    CORNER_ED("corner_ed", 33),
    CORNER_SU("corner_su", 10),
    CORNER_SD("corner_sd", 9),
    SLAB_XZ("slab_xz", 3),
    SIDE_W("side_w", 16),
    SIDE_N("side_n", 4),
    SIDE_E("side_e", 32),
    SIDE_S("side_s", 8),
    SIDE_U("side_u", 2),
    SIDE_D("side_d", 1);

    private static final int MIN_RADIUS = 1;
    public static final int MAX_RADIUS = 8;
    private final String name;
    private final byte openSides;
    private final Map<Integer, class_238> radiusBoxes;
    private static final ChoppedLogShape[] openSidesMap;
    private final class_265 occlusionShape;

    private ChoppedLogShape(String name, int openSides) {
        this.name = name;
        this.openSides = (byte)openSides;
        this.radiusBoxes = IntStream.range(1, 8).boxed().collect(Collectors.toMap(radius -> radius, this::bakeBoundingBox));
        this.occlusionShape = class_259.method_17786((class_265)class_259.method_1073(), (class_265[])((class_265[])Arrays.stream(class_2350.values()).filter(direction -> direction.method_10166().method_10179() && !this.isSideOpen((class_2350)direction)).map(direction -> class_259.method_1078((class_238)FaceShape.get(direction).getBox().asAxisAlignedBB())).toArray(class_265[]::new)));
        boolean x = false;
    }

    public static ChoppedLogShape forOpenSides(byte openSides) {
        return openSidesMap[openSides];
    }

    public Set<class_2350> getSolidSides(class_1922 level, class_2338 pos) {
        return ConfigHandler.removeBarkOnInteriorLogs.get() != false ? (Set)Arrays.stream(class_2350.values()).filter(direction -> direction.method_10166().method_10179() && !this.isSideOpen((class_2350)direction)).filter(direction -> {
            class_2338 neighborPos = pos.method_10093(direction);
            class_2680 blockState = level.method_8320(neighborPos);
            return blockState.method_26234(level, neighborPos);
        }).collect(Collectors.toCollection(() -> EnumSet.noneOf(class_2350.class))) : Collections.emptySet();
    }

    public String toString() {
        return this.name;
    }

    public String method_15434() {
        return this.name;
    }

    private class_238 bakeBoundingBox(int radius) {
        boolean down = this.isSideOpen(class_2350.field_11033);
        boolean up = this.isSideOpen(class_2350.field_11036);
        boolean north = this.isSideOpen(class_2350.field_11043);
        boolean south = this.isSideOpen(class_2350.field_11035);
        boolean west = this.isSideOpen(class_2350.field_11039);
        boolean east = this.isSideOpen(class_2350.field_11034);
        int chops = 8 - radius;
        float xCenter = 8 + (west ? chops : 0) - (east ? chops : 0);
        float yCenter = 8 + (down ? chops : 0) - (up ? chops : 0);
        float zCenter = 8 + (north ? chops : 0) - (south ? chops : 0);
        float xRadius = west || east ? (float)radius : 8.0f;
        float yRadius = down || up ? (float)radius : 8.0f;
        float zRadius = north || south ? (float)radius : 8.0f;
        return new class_238((double)(xCenter - xRadius), (double)(yCenter - yRadius), (double)(zCenter - zRadius), (double)(xCenter + xRadius), (double)(yCenter + yRadius), (double)(zCenter + zRadius));
    }

    public class_238 getBoundingBox(int radius) {
        class_238 defaultBox = new class_238(0.0, 0.0, 0.0, 16.0, 16.0, 16.0);
        return this.radiusBoxes.getOrDefault(Math.max(1, Math.min(radius, 8)), defaultBox);
    }

    public boolean isSideOpen(class_2350 side) {
        return (this.openSides >> side.ordinal() & 1) == 1;
    }

    public class_265 getOcclusionShape() {
        return ConfigHandler.removeBarkOnInteriorLogs.get() != false ? this.occlusionShape : class_259.method_1073();
    }

    static {
        openSidesMap = new ChoppedLogShape[64];
        Arrays.stream(ChoppedLogShape.values()).forEach(shape -> {
            ChoppedLogShape.openSidesMap[shape.openSides] = shape;
        });
        ChoppedLogShape.openSidesMap[0] = PILLAR_Y;
        ChoppedLogShape.openSidesMap[63] = PILLAR_Y;
        ChoppedLogShape.openSidesMap[62] = PILLAR_Y;
        ChoppedLogShape.openSidesMap[61] = PILLAR_Y;
        ChoppedLogShape.openSidesMap[55] = PILLAR_Z;
        ChoppedLogShape.openSidesMap[31] = PILLAR_X;
        ChoppedLogShape.openSidesMap[59] = PILLAR_Z;
        ChoppedLogShape.openSidesMap[47] = PILLAR_X;
    }
}

