/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.chop;

import ht.treechop.TreeChop;
import ht.treechop.api.IChoppableBlock;
import ht.treechop.api.IChoppingItem;
import ht.treechop.api.IFellableBlock;
import ht.treechop.api.IStrippableBlock;
import ht.treechop.api.TreeData;
import ht.treechop.common.chop.Chop;
import ht.treechop.common.chop.ChopDataImpl;
import ht.treechop.common.chop.ChopResult;
import ht.treechop.common.config.ChopCountingAlgorithm;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.settings.ChopSettings;
import ht.treechop.common.settings.EntityChopSettings;
import ht.treechop.common.util.AxeAccessor;
import ht.treechop.common.util.BlockNeighbors;
import ht.treechop.common.util.BlockUtil;
import ht.treechop.common.util.ClassUtil;
import ht.treechop.common.util.TreeDataImpl;
import ht.treechop.server.Server;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.apache.commons.lang3.tuple.Pair;

public class ChopUtil {
    public static boolean isBlockALog(class_1937 level, class_2338 pos) {
        return ChopUtil.isBlockALog(level, pos, level.method_8320(pos));
    }

    public static boolean isBlockALog(class_1937 level, class_2338 pos, class_2680 blockState) {
        return ChopUtil.isBlockChoppable((class_1922)level, pos, blockState);
    }

    public static boolean isBlockChoppable(class_1937 level, class_2338 pos) {
        return ChopUtil.isBlockChoppable((class_1922)level, pos, level.method_8320(pos));
    }

    public static boolean isBlockChoppable(class_1922 level, class_2338 pos, class_2680 blockState) {
        return ClassUtil.getChoppableBlock(level, pos, blockState) != null;
    }

    public static boolean isBlockLeaves(class_1937 level, class_2338 pos) {
        return ChopUtil.isBlockLeaves(level.method_8320(pos));
    }

    public static boolean isBlockLeaves(class_2680 blockState) {
        if (ConfigHandler.COMMON.leavesBlocks.get().contains(blockState.method_26204())) {
            return (Boolean)ConfigHandler.COMMON.ignorePersistentLeaves.get() == false || !blockState.method_28498((class_2769)class_2397.field_11200) || (Boolean)blockState.method_11654((class_2769)class_2397.field_11200) == false;
        }
        return false;
    }

    public static Set<class_2338> getConnectedBlocks(Collection<class_2338> startingPoints, Function<class_2338, Stream<class_2338>> searchOffsetsSupplier, int maxNumBlocks, AtomicInteger iterationCounter) {
        HashSet<class_2338> connectedBlocks = new HashSet<class_2338>();
        List<Object> newConnectedBlocks = new LinkedList<class_2338>(startingPoints);
        iterationCounter.set(0);
        do {
            connectedBlocks.addAll(newConnectedBlocks);
            if (connectedBlocks.size() >= maxNumBlocks) break;
            newConnectedBlocks = newConnectedBlocks.stream().flatMap(blockPos -> ((Stream)searchOffsetsSupplier.apply((class_2338)blockPos)).filter(pos1 -> !connectedBlocks.contains(pos1))).limit(maxNumBlocks - connectedBlocks.size()).collect(Collectors.toList());
            iterationCounter.incrementAndGet();
        } while (!newConnectedBlocks.isEmpty());
        return connectedBlocks;
    }

    public static Set<class_2338> getConnectedBlocks(Collection<class_2338> startingPoints, Function<class_2338, Stream<class_2338>> searchOffsetsSupplier, int maxNumBlocks) {
        return ChopUtil.getConnectedBlocks(startingPoints, searchOffsetsSupplier, maxNumBlocks, new AtomicInteger());
    }

    public static List<class_2338> getTreeLeaves(class_1937 level, Collection<class_2338> treeBlocks) {
        AtomicInteger iterationCounter = new AtomicInteger();
        HashSet leaves = new HashSet();
        int maxDistance = (Integer)ConfigHandler.COMMON.maxBreakLeavesDistance.get();
        int maxNumLeavesBlocks = (Integer)ConfigHandler.COMMON.maxNumLeavesBlocks.get();
        ChopUtil.getConnectedBlocks(treeBlocks, pos1 -> {
            class_2680 blockState = level.method_8320(pos1);
            return (ChopUtil.isBlockLeaves(blockState) && !(blockState.method_26204() instanceof class_2397) ? BlockNeighbors.ADJACENTS_AND_BELOW_ADJACENTS : BlockNeighbors.ADJACENTS).asStream((class_2338)pos1).filter(pos2 -> ChopUtil.markLeavesToDestroyAndKeepLooking(level, pos2, iterationCounter, leaves, maxDistance));
        }, maxNumLeavesBlocks, iterationCounter);
        if (leaves.size() >= maxNumLeavesBlocks) {
            TreeChop.LOGGER.warn(String.format("Max number of leaves reached: %d >= %d blocks", leaves.size(), maxNumLeavesBlocks));
        }
        return new ArrayList<class_2338>(leaves);
    }

    private static boolean markLeavesToDestroyAndKeepLooking(class_1937 level, class_2338 pos, AtomicInteger iterationCounter, Set<class_2338> leavesToDestroy, int maxDistance) {
        class_2680 blockState = level.method_8320(pos);
        if (ChopUtil.isBlockLeaves(blockState)) {
            if (blockState.method_26204() instanceof class_2397 ? iterationCounter.get() + 1 > (Integer)blockState.method_11654((class_2769)class_2397.field_11199) : iterationCounter.get() >= maxDistance) {
                return false;
            }
            leavesToDestroy.add(pos);
            return true;
        }
        return false;
    }

    public static int numChopsToFell(int supportSize) {
        return ((ChopCountingAlgorithm)((Object)ConfigHandler.COMMON.chopCountingAlgorithm.get())).calculate(supportSize);
    }

    public static int numChopsToFell(class_1937 level, Set<class_2338> supportedBlocks) {
        int treeSize = Math.max(supportedBlocks.stream().map(pos -> {
            Double d;
            class_2248 patt6295$temp = level.method_8320(pos).method_26204();
            if (patt6295$temp instanceof IFellableBlock) {
                IFellableBlock block = (IFellableBlock)patt6295$temp;
                d = block.getSupportFactor((class_1922)level, (class_2338)pos, level.method_8320(pos));
            } else {
                d = 1.0;
            }
            return d;
        }).reduce(Double::sum).orElse(1.0).intValue(), 1);
        return ChopUtil.numChopsToFell(treeSize);
    }

    public static ChopResult getChopResult(class_1937 level, class_2338 blockPos, class_1657 agent, int numChops, boolean fellIfPossible, Predicate<class_2338> logCondition) {
        return fellIfPossible ? ChopUtil.getChopResult(level, blockPos, agent, numChops, logCondition) : ChopUtil.tryToChopWithoutFelling(level, blockPos, numChops);
    }

    private static ChopResult getChopResult(class_1937 level, class_2338 blockPos, class_1657 agent, int numChops, Predicate<class_2338> logCondition) {
        int maxNumTreeBlocks = (Integer)ConfigHandler.COMMON.maxNumTreeBlocks.get();
        TreeData tree = ChopUtil.getTreeBlocks(level, blockPos, logCondition, maxNumTreeBlocks);
        if (tree.getLogBlocksOrEmpty().size() >= maxNumTreeBlocks) {
            TreeChop.LOGGER.warn("Max tree size {} reached (not including leaves)", (Object)maxNumTreeBlocks);
        }
        if (tree.isAProperTree(ChopUtil.getPlayerChopSettings(agent).getTreesMustHaveLeaves())) {
            Set<class_2338> supportedBlocks = tree.getLogBlocks().orElse(Collections.emptySet());
            return ChopUtil.getChopResult(level, blockPos, supportedBlocks, numChops);
        }
        return ChopResult.IGNORED;
    }

    public static TreeData getTreeBlocks(class_1937 level, class_2338 blockPos, int maxNumTreeBlocks) {
        return ChopUtil.getTreeBlocks(level, blockPos, pos -> ChopUtil.isBlockALog(level, pos), maxNumTreeBlocks);
    }

    public static TreeData getTreeBlocks(class_1937 level, class_2338 blockPos, Predicate<class_2338> logCondition, int maxNumTreeBlocks) {
        if (!logCondition.test(blockPos)) {
            return new TreeDataImpl();
        }
        TreeData detectData = TreeChop.platform.detectTreeEvent(level, null, blockPos, level.method_8320(blockPos), false);
        if (detectData.getLogBlocks().isPresent()) {
            return detectData;
        }
        Set<class_2338> supportedBlocks = ChopUtil.getConnectedBlocks(Collections.singletonList(blockPos), somePos -> BlockNeighbors.HORIZONTAL_AND_ABOVE.asStream((class_2338)somePos).peek(pos -> detectData.setLeaves(detectData.hasLeaves() || ChopUtil.isBlockLeaves(level, pos))).filter(logCondition), maxNumTreeBlocks);
        detectData.setLogBlocks(supportedBlocks);
        return detectData;
    }

    private static ChopResult getChopResult(class_1937 level, class_2338 target, Set<class_2338> supportedBlocks, int numChops) {
        int numChopsToFell;
        if (supportedBlocks.isEmpty()) {
            return ChopResult.IGNORED;
        }
        class_2680 blockState = level.method_8320(target);
        int currentNumChops = ChopUtil.getNumChops(level, target, blockState);
        if (currentNumChops + numChops < (numChopsToFell = ChopUtil.numChopsToFell(level, supportedBlocks))) {
            Set<class_2338> nearbyChoppableBlocks = ChopUtil.getConnectedBlocks(Collections.singletonList(target), pos -> BlockNeighbors.ADJACENTS_AND_DIAGONALS.asStream((class_2338)pos).filter(checkPos -> Math.abs(checkPos.method_10264() - target.method_10264()) < 4 && ChopUtil.isBlockChoppable(level, checkPos)), 64);
            int totalNumChops = ChopUtil.getNumChops(level, nearbyChoppableBlocks) + numChops;
            if (totalNumChops >= numChopsToFell) {
                List choppedLogsSortedByY = nearbyChoppableBlocks.stream().filter(pos1 -> level.method_8320(pos1).method_26204() instanceof IChoppableBlock).sorted(Comparator.comparingInt(class_2382::method_10264)).collect(Collectors.toList());
                for (class_2338 pos2 : choppedLogsSortedByY) {
                    int chops = ChopUtil.getNumChops(level, pos2);
                    supportedBlocks.add(pos2);
                    if (chops <= numChopsToFell) continue;
                    break;
                }
            } else {
                nearbyChoppableBlocks.remove(target);
                return ChopUtil.gatherChops(level, target, numChops, nearbyChoppableBlocks);
            }
        }
        Chop chop = new Chop(target, numChops);
        return new ChopResult(level, Collections.singletonList(chop), supportedBlocks);
    }

    private static ChopResult gatherChops(class_1937 level, class_2338 target, int numChops, Set<class_2338> nearbyChoppableBlocks) {
        List sortedChoppableBlocks;
        Stack<Chop> chops = new Stack<Chop>();
        int numChopsLeft = ChopUtil.gatherChopAndGetNumChopsRemaining(level, target, numChops, chops);
        if (numChopsLeft > 0 && (sortedChoppableBlocks = nearbyChoppableBlocks.stream().filter(pos -> {
            class_2680 blockState = level.method_8320(pos);
            if (blockState.method_26204() instanceof IChoppableBlock) {
                return ChopUtil.getNumChops(level, pos, blockState) < ChopUtil.getMaxNumChops(level, pos, blockState);
            }
            return pos.method_10264() >= target.method_10264();
        }).sorted(Comparator.comparingInt(a -> ChopUtil.chopDistance(target, a))).collect(Collectors.toList())).size() > 0) {
            int nextChoiceDistance = ChopUtil.chopDistance(target, (class_2338)sortedChoppableBlocks.get(0));
            int candidateStartIndex = 0;
            int n = sortedChoppableBlocks.size();
            for (int i = 0; i <= n; ++i) {
                class_2338 nextTarget;
                if (i != n && ChopUtil.chopDistance(target, (class_2338)sortedChoppableBlocks.get(i)) <= nextChoiceDistance) continue;
                List candidates = sortedChoppableBlocks.subList(candidateStartIndex, i);
                Collections.shuffle(candidates);
                Iterator iterator = candidates.iterator();
                while (iterator.hasNext() && (numChopsLeft = ChopUtil.gatherChopAndGetNumChopsRemaining(level, nextTarget = (class_2338)iterator.next(), numChopsLeft, chops)) > 0) {
                }
                if (numChopsLeft <= 0) break;
                candidateStartIndex = i;
            }
        }
        return new ChopResult(level, chops, Collections.emptyList());
    }

    private static int gatherChopAndGetNumChopsRemaining(class_1937 level, class_2338 targetPos, int numChops, List<Chop> choppedBlocks) {
        class_2680 blockStateBeforeChopping = level.method_8320(targetPos);
        if (!(blockStateBeforeChopping.method_26204() instanceof IChoppableBlock) && ChopUtil.isBlockSurrounded(level, targetPos)) {
            return numChops;
        }
        int adjustedNumChops = ChopUtil.adjustNumChops(level, targetPos, blockStateBeforeChopping, numChops, false);
        if (adjustedNumChops > 0) {
            choppedBlocks.add(new Chop(targetPos, adjustedNumChops));
        }
        return numChops - adjustedNumChops;
    }

    private static boolean isBlockSurrounded(class_1937 level, class_2338 pos) {
        return Stream.of(pos.method_10067(), pos.method_10095(), pos.method_10078(), pos.method_10072()).allMatch(neighborPos -> ChopUtil.isBlockALog(level, neighborPos));
    }

    public static int adjustNumChops(class_1937 level, class_2338 blockPos, class_2680 blockState, int numChops, boolean destructive) {
        IChoppableBlock choppableBlock = ClassUtil.getChoppableBlock((class_1922)level, blockPos, blockState);
        if (choppableBlock != null) {
            if (destructive) {
                return numChops;
            }
            int currentNumChops = choppableBlock.getNumChops((class_1922)level, blockPos, blockState);
            int maxNondestructiveChops = choppableBlock.getMaxNumChops((class_1922)level, blockPos, blockState) - currentNumChops;
            return Math.min(maxNondestructiveChops, numChops);
        }
        return 0;
    }

    public static int getMaxNumChops(class_1937 level, class_2338 blockPos, class_2680 blockState) {
        IChoppableBlock choppableBlock = ClassUtil.getChoppableBlock((class_1922)level, blockPos, blockState);
        return choppableBlock != null ? choppableBlock.getMaxNumChops((class_1922)level, blockPos, blockState) : 0;
    }

    public static int getNumChops(class_1937 level, class_2338 pos) {
        return ChopUtil.getNumChops(level, pos, level.method_8320(pos));
    }

    public static int getNumChops(class_1937 level, class_2338 pos, class_2680 blockState) {
        int n;
        class_2248 block = blockState.method_26204();
        if (block instanceof IChoppableBlock) {
            IChoppableBlock choppableBlock = (IChoppableBlock)block;
            n = choppableBlock.getNumChops((class_1922)level, pos, blockState);
        } else {
            n = 0;
        }
        return n;
    }

    public static int getNumChops(class_1937 level, Set<class_2338> positions) {
        return positions.stream().map(pos -> Pair.of((Object)pos, (Object)level.method_8320(pos))).map(posAndblockState -> {
            Integer n;
            class_2248 patt16090$temp = ((class_2680)posAndblockState.getRight()).method_26204();
            if (patt16090$temp instanceof IChoppableBlock) {
                IChoppableBlock choppableBlock = (IChoppableBlock)patt16090$temp;
                n = choppableBlock.getNumChops((class_1922)level, (class_2338)posAndblockState.getLeft(), (class_2680)posAndblockState.getRight());
            } else {
                n = 0;
            }
            return n;
        }).reduce(Integer::sum).orElse(0);
    }

    private static ChopResult tryToChopWithoutFelling(class_1937 level, class_2338 blockPos, int numChops) {
        return ChopUtil.isBlockChoppable(level, blockPos) ? new ChopResult(level, Collections.singletonList(new Chop(blockPos, numChops)), Collections.emptyList()) : ChopResult.IGNORED;
    }

    public static int chopDistance(class_2338 a, class_2338 b) {
        return a.method_19455((class_2382)b);
    }

    public static boolean canChopWithTool(class_1657 player, class_1937 level, class_2338 pos) {
        return ChopUtil.canChopWithTool(player, player.method_6047(), level, pos, level.method_8320(pos));
    }

    public static boolean canChopWithTool(class_1657 player, class_1799 tool, class_1937 level, class_2338 pos, class_2680 blockState) {
        return !((Boolean)ConfigHandler.COMMON.mustUseCorrectToolForDrops.get() != false && blockState.method_29291() && !tool.method_7951(blockState) || (Boolean)ConfigHandler.COMMON.mustUseFastBreakingTool.get() != false && !(tool.method_7924(blockState) > 1.0f) || !ConfigHandler.canChopWithTool(player, tool, level, pos, blockState));
    }

    public static int getNumChopsByTool(class_1799 tool, class_2680 blockState) {
        class_1792 class_17922 = tool.method_7909();
        if (class_17922 instanceof IChoppingItem) {
            IChoppingItem choppingItem = (IChoppingItem)class_17922;
            return choppingItem.getNumChops(tool, blockState);
        }
        return 1;
    }

    public static boolean playerWantsToChop(class_1657 player) {
        EntityChopSettings chopSettings = ChopUtil.getPlayerChopSettings(player);
        return ChopUtil.playerWantsToChop(player, chopSettings);
    }

    public static boolean playerWantsToChop(class_1657 player, ChopSettings chopSettings) {
        if (((Boolean)ConfigHandler.COMMON.enabled.get()).booleanValue() && (player != null && !player.method_7337() || chopSettings.getChopInCreativeMode())) {
            return chopSettings.getChoppingEnabled() ^ chopSettings.getSneakBehavior().shouldChangeChopBehavior((class_1297)player);
        }
        return false;
    }

    public static boolean playerWantsToFell(class_1657 player) {
        EntityChopSettings chopSettings = ChopUtil.getPlayerChopSettings(player);
        return ChopUtil.playerWantsToFell(player, chopSettings);
    }

    public static boolean playerWantsToFell(class_1657 player, ChopSettings chopSettings) {
        return chopSettings.getFellingEnabled() ^ chopSettings.getSneakBehavior().shouldChangeFellBehavior((class_1297)player);
    }

    public static EntityChopSettings getPlayerChopSettings(class_1657 player) {
        return Server.instance().getPlayerChopSettings(player);
    }

    public static void dropExperience(class_1937 level, class_2338 pos, int amount) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            if (level.method_8450().method_8355(class_1928.field_19392)) {
                class_1303.method_31493((class_3218)serverLevel, (class_243)class_243.method_24953((class_2382)pos), (int)amount);
            }
        }
    }

    public static boolean chop(class_3222 agent, class_3218 level, class_2338 pos, class_2680 blockState, class_1799 tool, Object trigger) {
        if (!(ChopUtil.isBlockChoppable((class_1922)level, pos, blockState) && ChopUtil.playerWantsToChop((class_1657)agent) && ChopUtil.canChopWithTool((class_1657)agent, tool, (class_1937)level, pos, blockState))) {
            return false;
        }
        ChopDataImpl chopData = new ChopDataImpl(ChopUtil.getNumChopsByTool(tool, blockState), ChopUtil.playerWantsToFell((class_1657)agent));
        boolean doChop = TreeChop.platform.startChopEvent(agent, level, pos, blockState, chopData, trigger);
        if (!doChop) {
            return false;
        }
        ChopResult chopResult = ChopUtil.getChopResult((class_1937)level, pos, (class_1657)agent, chopData.getNumChops(), chopData.getFelling(), logPos -> ChopUtil.isBlockALog((class_1937)level, logPos));
        if (chopResult != ChopResult.IGNORED) {
            boolean felled = chopResult.apply(pos, agent, tool, (Boolean)ConfigHandler.COMMON.breakLeaves.get());
            TreeChop.platform.finishChopEvent(agent, level, pos, blockState, chopData, felled);
            tool.method_7952((class_1937)level, blockState, pos, (class_1657)agent);
            return !felled;
        }
        return false;
    }

    public static class_2680 getStrippedState(class_1920 level, class_2338 pos, class_2680 state) {
        return ChopUtil.getStrippedState(level, pos, state, state);
    }

    public static class_2680 getStrippedState(class_1920 level, class_2338 pos, class_2680 state, class_2680 fallback) {
        class_2680 strippedState;
        class_2680 class_26802 = strippedState = AxeAccessor.isStripped(state.method_26204()) ? state : AxeAccessor.getStripped(state);
        if (strippedState == null && (strippedState = TreeChop.platform.getStrippedState(level, pos, state)) == null) {
            IStrippableBlock strippableBlock = ClassUtil.getStrippableBlock(state.method_26204());
            class_2680 class_26803 = strippedState = strippableBlock != null ? strippableBlock.getStrippedState((class_1922)level, pos, state) : ConfigHandler.inferredStrippedStates.get().get(state.method_26204());
            if (strippedState == null) {
                strippedState = fallback;
            }
        }
        return BlockUtil.copyStateProperties(strippedState, state);
    }
}

