/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.block;

import ht.treechop.TreeChop;
import ht.treechop.api.IChoppableBlock;
import ht.treechop.common.block.BlockImitator;
import ht.treechop.common.chop.ChopUtil;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.network.ServerUpdateChopsPacket;
import ht.treechop.common.properties.ChoppedLogShape;
import ht.treechop.common.util.ClassUtil;
import ht.treechop.server.Server;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2622;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_47;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;

public abstract class ChoppedLogBlock
extends BlockImitator
implements IChoppableBlock,
class_2343,
class_3737 {
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final int DEFAULT_SUPPORT_FACTOR = 7;
    public static final int DEFAULT_MAX_NUM_CHOPS = 7;
    public static final int DEFAULT_UNCHOPPED_RADIUS = 8;

    public ChoppedLogBlock(class_4970.class_2251 properties) {
        super(properties.method_9624().method_26245((blockState, level, pos) -> false));
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public static ChoppedLogShape getPlacementShape(class_1937 level, class_2338 blockPos) {
        boolean DOWN = true;
        int UP = 2;
        int NORTH = 4;
        int SOUTH = 8;
        int WEST = 16;
        int EAST = 32;
        byte openSides = (byte)((ChoppedLogBlock.isBlockOpen(level, blockPos.method_10074()) ? 1 : 0) | (!ChopUtil.isBlockALog(level, blockPos.method_10084()) ? 2 : 0) | (!ChopUtil.isBlockALog(level, blockPos.method_10095()) ? 4 : 0) | (!ChopUtil.isBlockALog(level, blockPos.method_10072()) ? 8 : 0) | (!ChopUtil.isBlockALog(level, blockPos.method_10067()) ? 16 : 0) | (!ChopUtil.isBlockALog(level, blockPos.method_10078()) ? 32 : 0));
        return ChoppedLogShape.forOpenSides(openSides);
    }

    private static boolean isBlockOpen(class_1937 level, class_2338 pos) {
        return level.method_22347(pos) || ChopUtil.isBlockLeaves(level, pos);
    }

    @Override
    public class_2680 getImitatedBlockState(class_1922 level, class_2338 pos) {
        MyEntity entity;
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof MyEntity && !(entity = (MyEntity)class_25862).getOriginalState().method_27852((class_2248)this)) {
            return entity.getOriginalState();
        }
        return class_2246.field_10431.method_9564();
    }

    public float method_9594(class_2680 blockState, class_1657 player, class_1922 level, class_2338 pos) {
        return (float)Math.min(0.35, (double)this.getImitatedBlockState(level, pos).method_26165(player, level, pos));
    }

    @Nonnull
    public class_265 method_9530(class_2680 state, @Nonnull class_1922 level, @Nonnull class_2338 pos, @Nonnull class_3726 context) {
        double scale = 0.0625;
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof MyEntity) {
            MyEntity entity = (MyEntity)class_25862;
            class_238 box = entity.getShape().getBoundingBox(entity.getRadius());
            return class_259.method_1081((double)(box.field_1323 * 0.0625), (double)(box.field_1322 * 0.0625), (double)(box.field_1321 * 0.0625), (double)(box.field_1320 * 0.0625), (double)(box.field_1325 * 0.0625), (double)(box.field_1324 * 0.0625));
        }
        return class_259.method_1077();
    }

    public class_265 method_9571(class_2680 state, class_1922 level, class_2338 pos) {
        MyEntity entity;
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof MyEntity && (entity = (MyEntity)class_25862).getOriginalState().method_26216(level, pos)) {
            return entity.getShape().getOcclusionShape();
        }
        return class_259.method_1073();
    }

    public boolean method_9526(class_2680 blockState) {
        return false;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{WATERLOGGED});
    }

    @Override
    public int getNumChops(class_1922 level, class_2338 pos, class_2680 blockState) {
        int n;
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof MyEntity) {
            MyEntity entity = (MyEntity)class_25862;
            n = entity.getChops();
        } else {
            n = 0;
        }
        return n;
    }

    @Override
    public int getMaxNumChops(class_1922 level, class_2338 pos, class_2680 blockState) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof MyEntity) {
            MyEntity entity = (MyEntity)class_25862;
            return entity.getMaxNumChops();
        }
        return 7;
    }

    @Override
    public double getSupportFactor(class_1922 level, class_2338 pos, class_2680 blockState) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof MyEntity) {
            MyEntity entity = (MyEntity)class_25862;
            return entity.getSupportFactor();
        }
        return 7.0;
    }

    @Override
    public void chop(class_1657 player, class_1799 tool, class_1937 level, class_2338 pos, class_2680 blockState, int numChops, boolean felling) {
        int currentNumChops = ChopUtil.getNumChops(level, pos, blockState);
        int maxNumChops = ChopUtil.getMaxNumChops(level, pos, blockState);
        int newNumChops = Math.min(currentNumChops + numChops, maxNumChops);
        int numAddedChops = newNumChops - currentNumChops;
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            for (int i = 0; i < numAddedChops; ++i) {
                ChoppedLogBlock.method_9609((class_2680)this.method_9564(), (class_3218)serverLevel, (class_2338)pos, null, (class_1297)player, (class_1799)tool).forEach(stack -> ChoppedLogBlock.method_9577((class_1937)serverLevel, (class_2338)pos, (class_1799)stack));
            }
        }
        if (!felling) {
            if (numAddedChops > 0) {
                class_2586 class_25862;
                if (!blockState.method_27852((class_2248)this)) {
                    class_2586 class_25863;
                    class_2680 newBlockState;
                    int chopZeroRadius = Optional.ofNullable(ClassUtil.getCylinderBlock(blockState.method_26204())).map(slimBlock -> slimBlock.getRadius((class_1922)level, pos, blockState)).orElse(8);
                    double supportFactor = Optional.ofNullable(ClassUtil.getFellableBlock(blockState.method_26204())).map(fellableBlock -> fellableBlock.getSupportFactor((class_1922)level, pos, blockState)).orElse(1.0);
                    class_2680 class_26802 = newBlockState = blockState.method_27852((class_2248)this) ? blockState : this.getPlacementState(level, pos);
                    if (level.method_8501(pos, newBlockState) && (class_25863 = level.method_8321(pos)) instanceof MyEntity) {
                        MyEntity entity = (MyEntity)class_25863;
                        if (level instanceof class_3218) {
                            class_3218 serverLevel = (class_3218)level;
                            entity.setShape(ChoppedLogBlock.getPlacementShape(level, pos));
                            entity.setOriginalState(blockState);
                            entity.setParameters(chopZeroRadius, maxNumChops, supportFactor);
                            List drops = class_2248.method_9609((class_2680)blockState, (class_3218)serverLevel, (class_2338)pos, (class_2586)entity, (class_1297)player, (class_1799)tool);
                            entity.setDrops(drops);
                        }
                    }
                }
                if ((class_25862 = level.method_8321(pos)) instanceof MyEntity) {
                    MyEntity entity = (MyEntity)class_25862;
                    entity.setChops(newNumChops);
                    entity.method_5431();
                }
            } else {
                level.method_8501(pos, class_2246.field_10124.method_9564());
            }
        }
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        return this.getPlacementState(context.method_8045(), context.method_8037());
    }

    private class_2680 getPlacementState(class_1937 level, class_2338 pos) {
        return (class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(this.shouldPlaceAsWaterlogged(level, pos)));
    }

    private boolean shouldPlaceAsWaterlogged(class_1937 level, class_2338 pos) {
        class_2350[] waterSourceDirections = new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039, class_2350.field_11036};
        return Arrays.stream(waterSourceDirections).filter(direction -> level.method_8316(pos.method_10081(direction.method_10163())).method_15771()).limit(2L).count() == 2L;
    }

    public class_3610 method_9545(class_2680 blockState) {
        return (Boolean)blockState.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(blockState);
    }

    public class_2680 method_9559(class_2680 blockState, class_2350 side, class_2680 neighborState, class_1936 level, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)blockState.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            level.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
        }
        return super.method_9559(blockState, side, neighborState, level, pos, neighborPos);
    }

    @Nonnull
    public List<class_1799> method_9560(class_2680 blockState, class_47.class_48 context) {
        Object object;
        if (((Boolean)ConfigHandler.COMMON.dropLootForChoppedBlocks.get()).booleanValue() && (object = context.method_305(class_181.field_1228)) instanceof MyEntity) {
            MyEntity entity = (MyEntity)((Object)object);
            return entity.drops;
        }
        return Collections.emptyList();
    }

    public static abstract class MyEntity
    extends class_2586 {
        public static final String KEY_CHOPS = "Chops";
        public static final String KEY_SHAPE = "Shape";
        public static final String KEY_DROPS = "Drops";
        public static final String KEY_ORIGINAL_STATE = "OriginalState";
        public static final String KEY_UNCHOPPED_RADIUS = "UnchoppedRadius";
        public static final String KEY_MAX_NUM_CHOPS = "MaxNumChops";
        public static final String KEY_SUPPORT_FACTOR = "SupportFactor";
        protected class_2680 originalState = class_2246.field_10431.method_9564();
        protected List<class_1799> drops = Collections.emptyList();
        private ChoppedLogShape shape = ChoppedLogShape.PILLAR_Y;
        private int chops = 1;
        private int unchoppedRadius = 8;
        private int maxNumChops = 7;
        private double supportFactor = 7.0;

        public MyEntity(class_2338 pos, class_2680 blockState) {
            super(TreeChop.platform.getChoppedLogBlockEntity(), pos, blockState);
        }

        public void setParameters(int unchoppedRadius, int maxNumChops, double supportFactor) {
            this.unchoppedRadius = unchoppedRadius;
            this.maxNumChops = maxNumChops;
            this.supportFactor = supportFactor;
        }

        public void setDrops(List<class_1799> drops) {
            this.drops = drops;
        }

        public int getChops() {
            return this.chops;
        }

        public void setChops(int chops) {
            this.chops = chops;
        }

        public ChoppedLogShape getShape() {
            return this.shape;
        }

        public void setShape(ChoppedLogShape shape) {
            this.shape = shape;
        }

        public class_2680 getOriginalState() {
            return this.originalState;
        }

        public void setOriginalState(class_2680 originalState) {
            this.originalState = originalState;
        }

        public int getUnchoppedRadius() {
            return this.unchoppedRadius;
        }

        public int getRadius() {
            return Math.max(this.getUnchoppedRadius() - this.getChops(), 1);
        }

        public int getMaxNumChops() {
            return this.maxNumChops;
        }

        public double getSupportFactor() {
            return this.supportFactor;
        }

        public void method_11007(@Nonnull class_2487 tag) {
            super.method_11007(tag);
            tag.method_10569(KEY_ORIGINAL_STATE, class_2248.method_9507((class_2680)this.getOriginalState()));
            tag.method_10569(KEY_CHOPS, this.getChops());
            tag.method_10569(KEY_SHAPE, this.getShape().ordinal());
            if (this.unchoppedRadius != 8) {
                tag.method_10569(KEY_UNCHOPPED_RADIUS, this.unchoppedRadius);
            }
            if (this.maxNumChops != 7) {
                tag.method_10569(KEY_MAX_NUM_CHOPS, this.maxNumChops);
            }
            if (this.supportFactor != 7.0) {
                tag.method_10549(KEY_SUPPORT_FACTOR, this.supportFactor);
            }
            class_2499 list = new class_2499();
            this.drops.stream().map(stack -> stack.method_7953(new class_2487())).forEach(arg_0 -> list.add(arg_0));
            tag.method_10566(KEY_DROPS, (class_2520)list);
        }

        public void method_11014(@Nonnull class_2487 tag) {
            super.method_11014(tag);
            int stateId = tag.method_10550(KEY_ORIGINAL_STATE);
            this.setOriginalState(stateId > 0 ? class_2248.method_9531((int)stateId) : class_2246.field_10431.method_9564());
            this.setChops(tag.method_10550(KEY_CHOPS));
            this.setShape(ChoppedLogShape.values()[tag.method_10550(KEY_SHAPE)]);
            int unchoppedRadius = tag.method_10545(KEY_UNCHOPPED_RADIUS) ? tag.method_10550(KEY_UNCHOPPED_RADIUS) : 8;
            int maxNumChops = tag.method_10545(KEY_MAX_NUM_CHOPS) ? tag.method_10550(KEY_MAX_NUM_CHOPS) : 7;
            double supportFactor = tag.method_10545(KEY_SUPPORT_FACTOR) ? (double)tag.method_10550(KEY_SUPPORT_FACTOR) : 7.0;
            this.setParameters(unchoppedRadius, maxNumChops, supportFactor);
            class_2499 list = tag.method_10554(KEY_DROPS, 10);
            this.drops = new LinkedList<class_1799>();
            for (int i = 0; i < list.size(); ++i) {
                class_2487 item = list.method_10602(i);
                this.drops.add(class_1799.method_7915((class_2487)item));
            }
        }

        @Nonnull
        public class_2487 method_16887() {
            return this.method_38244();
        }

        @Nullable
        public class_2622 getUpdatePacket() {
            return class_2622.method_38585((class_2586)this);
        }

        public void method_5431() {
            super.method_5431();
            this.syncWithClients();
        }

        public void syncWithClients() {
            class_1937 class_19372 = this.field_11863;
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                Server.instance().broadcast(serverLevel, this.field_11867, new ServerUpdateChopsPacket(this.field_11867, this.method_16887()));
            }
        }

        public void method_31662(@NotNull class_1937 level) {
            super.method_31662(level);
            if (level.method_8608()) {
                this.update(level);
            }
        }

        public void update(@NotNull class_1937 level) {
            class_2487 update = ServerUpdateChopsPacket.getPendingUpdate(level, this.field_11867);
            if (update != null) {
                this.method_11014(update);
            }
        }
    }
}

