/*
 * Decompiled with CFR 0.152.
 */
package wraith.fwaystones.util;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1702;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3781;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_5321;
import net.minecraft.class_5497;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import wraith.fwaystones.FabricWaystones;
import wraith.fwaystones.access.WaystoneValue;
import wraith.fwaystones.block.WaystoneBlockEntity;
import wraith.fwaystones.item.LocalVoidItem;
import wraith.fwaystones.mixin.StructurePoolAccessor;
import wraith.fwaystones.screen.AbyssScreenHandler;
import wraith.fwaystones.screen.PocketWormholeScreenHandler;
import wraith.fwaystones.screen.WaystoneBlockScreenHandler;
import wraith.fwaystones.util.FWConfig;
import wraith.fwaystones.util.FWConfigModel;
import wraith.fwaystones.util.TeleportSources;

public final class Utils {
    public static final DecimalFormat df = new DecimalFormat("#.##");
    public static final Random random = new Random();
    private static final class_5321<class_5497> EMPTY_PROCESSOR_LIST_KEY = class_5321.method_29179((class_5321)class_2378.field_25916, (class_2960)new class_2960("minecraft", "empty"));

    private Utils() {
    }

    public static int getRandomIntInRange(int min, int max) {
        if (min == max) {
            return min;
        }
        if (min > max) {
            int temp = min;
            min = max;
            max = temp;
        }
        return random.nextInt(max - min + 1) + min;
    }

    public static class_2960 ID(String id) {
        return new class_2960("fwaystones", id);
    }

    public static String generateWaystoneName(String id) {
        return id == null || "".equals(id) ? Utils.generateUniqueId() : id;
    }

    private static String generateUniqueId() {
        if (random.nextDouble() < 1.0E-4) {
            return "DeatHunter was here";
        }
        StringBuilder sb = new StringBuilder();
        char[] vowels = new char[]{'a', 'e', 'i', 'o', 'u'};
        char[] consonants = new char[]{'b', 'c', 'd', 'f', 'g', 'h', 'j', 'k', 'l', 'm', 'n', 'p', 'q', 'r', 's', 't', 'v', 'w', 'x', 'y', 'z'};
        for (int i = 0; i < 4; ++i) {
            char consonant = consonants[random.nextInt(consonants.length)];
            if (i == 0) {
                consonant = Character.toUpperCase(consonant);
            }
            sb.append(consonant);
            sb.append(vowels[random.nextInt(vowels.length)]);
        }
        return sb.toString();
    }

    public static void addToStructurePool(MinecraftServer server, class_2960 village, class_2960 waystone, int weight) {
        class_6880 emptyProcessorList = server.method_30611().method_30530(class_2378.field_25916).method_40290(EMPTY_PROCESSOR_LIST_KEY);
        Optional poolGetter = server.method_30611().method_30530(class_2378.field_25917).method_17966(village);
        if (poolGetter.isEmpty()) {
            FabricWaystones.LOGGER.error("Cannot add to " + village + " as it cannot be found!");
            return;
        }
        class_3785 pool = (class_3785)poolGetter.get();
        ObjectArrayList<class_3784> pieceList = ((StructurePoolAccessor)pool).getElements();
        class_3781 piece = (class_3781)class_3784.method_30435((String)waystone.toString(), (class_6880)emptyProcessorList).apply(class_3785.class_3786.field_16687);
        ArrayList<Pair<class_3784, Integer>> list = new ArrayList<Pair<class_3784, Integer>>(((StructurePoolAccessor)pool).getElementCounts());
        list.add((Pair<class_3784, Integer>)Pair.of((Object)piece, (Object)weight));
        ((StructurePoolAccessor)pool).setElementCounts(list);
        for (int i = 0; i < weight; ++i) {
            pieceList.add((Object)piece);
        }
    }

    public static long determineLevelXP(class_1657 player) {
        int level = player.field_7520;
        long total = player.field_7495;
        total = level <= 16 ? (total += (long)(Math.pow(level, 2.0) + (double)(6L * (long)level))) : (level <= 31 ? (total += (long)(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0)) : (total += (long)(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0)));
        return total;
    }

    public static int getCost(class_243 startPos, class_243 endPos, String startDim, String endDim) {
        FWConfig.Teleportation_cost config = FabricWaystones.CONFIG.teleportation_cost;
        float cost = config.base_cost();
        cost = startDim.equals(endDim) ? (float)((double)cost + Math.max(0.0, startPos.method_1031(0.0, 0.5, 0.0).method_1022(endPos) - 1.4142) * (double)config.cost_per_block_distance()) : (cost *= config.cost_multiplier_between_dimensions());
        return Math.round(cost);
    }

    public static boolean canTeleport(class_1657 player, String hash, boolean takeCost) {
        FWConfigModel.CostType cost = FabricWaystones.CONFIG.teleportation_cost.cost_type();
        WaystoneValue waystone = FabricWaystones.WAYSTONE_STORAGE.getWaystoneData(hash);
        if (waystone == null) {
            player.method_7353((class_2561)class_2561.method_43471((String)"fwaystones.no_teleport.invalid_waystone"), true);
            return false;
        }
        String sourceDim = Utils.getDimensionName(player.field_6002);
        String destDim = waystone.getWorldName();
        if (!FabricWaystones.CONFIG.ignore_dimension_blacklists_if_same_dimension() || !sourceDim.equals(destDim)) {
            if (FabricWaystones.CONFIG.disable_teleportation_from_dimensions().contains(sourceDim)) {
                player.method_7353((class_2561)class_2561.method_43471((String)"fwaystones.no_teleport.blacklisted_dimension_source"), true);
                return false;
            }
            if (FabricWaystones.CONFIG.disable_teleportation_to_dimensions().contains(destDim)) {
                player.method_7353((class_2561)class_2561.method_43471((String)"fwaystones.no_teleport.blacklisted_dimension_destination"), true);
                return false;
            }
        }
        int amount = Utils.getCost(player.method_19538(), class_243.method_24953((class_2382)waystone.way_getPos()), sourceDim, destDim);
        if (player.method_7337()) {
            return true;
        }
        switch (cost) {
            case HEALTH: {
                if (player.method_6032() + player.method_6067() <= (float)amount) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"fwaystones.no_teleport.health"), true);
                    return false;
                }
                if (takeCost) {
                    player.method_5643(class_1282.field_5846, (float)amount);
                }
                return true;
            }
            case HUNGER: {
                class_1702 hungerManager = player.method_7344();
                float hungerAndExhaustion = (float)hungerManager.method_7586() + hungerManager.method_7589();
                if (hungerAndExhaustion <= 10.0f || hungerAndExhaustion + hungerManager.method_35219() / 4.0f <= (float)amount) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"fwaystones.no_teleport.hunger"), true);
                    return false;
                }
                if (takeCost) {
                    hungerManager.method_7583((float)(4 * amount));
                }
                return true;
            }
            case EXPERIENCE: {
                long total = Utils.determineLevelXP(player);
                if (total < (long)amount) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"fwaystones.no_teleport.xp"), true);
                    return false;
                }
                if (takeCost) {
                    player.method_7255(-amount);
                }
                return true;
            }
            case LEVEL: {
                if (player.field_7520 < amount) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"fwaystones.no_teleport.level"), true);
                    return false;
                }
                if (takeCost) {
                    player.method_7316(-amount);
                }
                return true;
            }
            case ITEM: {
                class_2960 itemId = Utils.getTeleportCostItem();
                class_1792 item = (class_1792)class_2378.field_11142.method_10223(itemId);
                if (!Utils.containsItem(player.method_31548(), item, amount)) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"fwaystones.no_teleport.item"), true);
                    return false;
                }
                if (takeCost) {
                    Utils.removeItem(player.method_31548(), item, amount);
                    if (player.field_6002.field_9236 || FabricWaystones.WAYSTONE_STORAGE == null) {
                        return true;
                    }
                    WaystoneBlockEntity waystoneBE = waystone.getEntity();
                    if (waystoneBE == null) {
                        return true;
                    }
                    ArrayList<class_1799> oldInventory = new ArrayList<class_1799>((Collection<class_1799>)waystoneBE.getInventory());
                    boolean found = false;
                    for (class_1799 stack : oldInventory) {
                        if (stack.method_7909() != item) continue;
                        stack.method_7933(amount);
                        found = true;
                        break;
                    }
                    if (!found) {
                        oldInventory.add(new class_1799((class_1935)item, amount));
                    }
                    waystoneBE.setInventory(oldInventory);
                }
                return true;
            }
        }
        return true;
    }

    public static boolean containsItem(class_1661 inventory, class_1792 item, int maxAmount) {
        int amount = 0;
        for (class_1799 stack : inventory.field_7547) {
            if (!stack.method_7909().equals(item)) continue;
            amount += stack.method_7947();
        }
        for (class_1799 stack : inventory.field_7544) {
            if (!stack.method_7909().equals(item)) continue;
            amount += stack.method_7947();
        }
        for (class_1799 stack : inventory.field_7548) {
            if (!stack.method_7909().equals(item)) continue;
            amount += stack.method_7947();
        }
        return amount >= maxAmount;
    }

    public static void removeItem(class_1661 inventory, class_1792 item, int totalAmount) {
        int amount;
        for (class_1799 stack : inventory.field_7547) {
            if (stack.method_7909().equals(item)) {
                amount = stack.method_7947();
                stack.method_7934(totalAmount);
                totalAmount -= amount;
            }
            if (totalAmount > 0) continue;
            return;
        }
        for (class_1799 stack : inventory.field_7544) {
            if (stack.method_7909().equals(item)) {
                amount = stack.method_7947();
                stack.method_7934(totalAmount);
                totalAmount -= amount;
            }
            if (totalAmount > 0) continue;
            return;
        }
        for (class_1799 stack : inventory.field_7548) {
            if (stack.method_7909().equals(item)) {
                amount = stack.method_7947();
                stack.method_7934(totalAmount);
                totalAmount -= amount;
            }
            if (totalAmount > 0) continue;
            return;
        }
    }

    public static String getSHA256(String data) {
        try {
            return Arrays.toString(MessageDigest.getInstance("SHA-256").digest(data.getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getDimensionName(class_1937 world) {
        return world.method_27983().method_29177().toString();
    }

    public static TeleportSources getTeleportSource(class_1657 player) {
        if (player.field_7512 instanceof AbyssScreenHandler) {
            return TeleportSources.ABYSS_WATCHER;
        }
        if (player.field_7512 instanceof PocketWormholeScreenHandler) {
            return TeleportSources.POCKET_WORMHOLE;
        }
        if (player.field_7512 instanceof WaystoneBlockScreenHandler) {
            return TeleportSources.WAYSTONE;
        }
        for (class_1268 hand : class_1268.values()) {
            if (!(player.method_5998(hand).method_7909() instanceof LocalVoidItem)) continue;
            return TeleportSources.LOCAL_VOID;
        }
        return null;
    }

    public static int getRandomColor() {
        return random.nextInt(0xFFFFFF);
    }

    @Nullable
    public static class_2960 getTeleportCostItem() {
        if (FabricWaystones.CONFIG.teleportation_cost.cost_type() == FWConfigModel.CostType.ITEM) {
            String[] item = FabricWaystones.CONFIG.teleportation_cost.cost_item().split(":");
            return item.length == 2 ? new class_2960(item[0], item[1]) : new class_2960(item[0]);
        }
        return null;
    }

    @Nullable
    public static class_2960 getDiscoverItem() {
        String discoverStr = FabricWaystones.CONFIG.discover_with_item();
        if (discoverStr.equals("none")) {
            return null;
        }
        String[] item = discoverStr.split(":");
        return item.length == 2 ? new class_2960(item[0], item[1]) : new class_2960(item[0]);
    }

    public static boolean isSubSequence(String mainString, String searchString) {
        int j = 0;
        for (int i = 0; i < mainString.length() && j < searchString.length(); ++i) {
            if (mainString.charAt(i) == searchString.charAt(j)) {
                ++j;
            }
            if (j != searchString.length()) continue;
            return true;
        }
        return false;
    }
}

