/*
 * Decompiled with CFR 0.152.
 */
package wraith.fwaystones.screen;

import java.util.ArrayList;
import java.util.Comparator;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2645;
import net.minecraft.class_2815;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3917;
import wraith.fwaystones.FabricWaystones;
import wraith.fwaystones.access.PlayerAccess;
import wraith.fwaystones.access.PlayerEntityMixinAccess;
import wraith.fwaystones.mixin.ClientPlayerEntityAccessor;
import wraith.fwaystones.mixin.ServerPlayerEntityAccessor;
import wraith.fwaystones.util.SearchType;
import wraith.fwaystones.util.Utils;
import wraith.fwaystones.util.WaystonePacketHandler;

public abstract class UniversalWaystoneScreenHandler
extends class_1703 {
    protected final class_1657 player;
    protected ArrayList<String> sortedWaystones = new ArrayList();
    protected ArrayList<String> filteredWaystones = new ArrayList();
    protected String filter = "";

    protected UniversalWaystoneScreenHandler(class_3917<? extends UniversalWaystoneScreenHandler> type, int syncId, class_1657 player) {
        super(type, syncId);
        this.player = player;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.method_7621(new class_1735((class_1263)this.player.method_31548(), x + y * 9 + 9, 2000000000, 2000000000));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.method_7621(new class_1735((class_1263)this.player.method_31548(), x, 2000000000, 2000000000));
        }
    }

    public void updateWaystones(class_1657 player) {
        if (!player.field_6002.field_9236) {
            return;
        }
        this.sortedWaystones = new ArrayList();
        if (((PlayerEntityMixinAccess)player).shouldViewDiscoveredWaystones()) {
            this.sortedWaystones.addAll(((PlayerAccess)player).getHashesSorted());
        }
        if (((PlayerEntityMixinAccess)player).shouldViewGlobalWaystones()) {
            for (String waystone : FabricWaystones.WAYSTONE_STORAGE.getGlobals()) {
                if (this.sortedWaystones.contains(waystone)) continue;
                this.sortedWaystones.add(waystone);
            }
        }
        this.sortedWaystones.sort(Comparator.comparing(a -> FabricWaystones.WAYSTONE_STORAGE.getName((String)a)));
        this.filterWaystones();
    }

    public boolean method_7604(class_1657 player, int id) {
        if (!player.field_6002.field_9236) {
            return false;
        }
        int waystoneID = Math.floorDiv(id, 2);
        if (waystoneID >= this.filteredWaystones.size()) {
            return false;
        }
        String waystone = this.filteredWaystones.get(waystoneID);
        if (waystone == null) {
            return false;
        }
        class_2540 data = PacketByteBufs.create();
        class_2487 tag = new class_2487();
        tag.method_10582("waystone_hash", waystone);
        data.method_10794(tag);
        if (id % 2 != 0) {
            this.sortedWaystones.remove(waystone);
            this.filteredWaystones.remove(waystone);
            this.onForget(waystone);
            ((PlayerEntityMixinAccess)player).forgetWaystone(waystone);
            this.updateWaystones(player);
            ClientPlayNetworking.send((class_2960)WaystonePacketHandler.FORGET_WAYSTONE, (class_2540)data);
        } else {
            if (Utils.canTeleport(player, waystone, false)) {
                ClientPlayNetworking.send((class_2960)WaystonePacketHandler.TELEPORT_TO_WAYSTONE, (class_2540)data);
            }
            this.closeScreen();
        }
        return true;
    }

    protected void closeScreen() {
        if (this.player == null) {
            return;
        }
        if (this.player.field_6002.field_9236) {
            this.closeOnClient();
        } else {
            ((ServerPlayerEntityAccessor)this.player).getNetworkHandler().method_14364((class_2596)new class_2645(this.field_7763));
            this.player.field_7512.method_7595(this.player);
            this.player.field_7512 = this.player.field_7498;
        }
    }

    protected void closeOnClient() {
        ((ClientPlayerEntityAccessor)this.player).getNetworkHandler().method_2883((class_2596)new class_2815(this.field_7763));
        this.method_34254(class_1799.field_8037);
        this.player.field_7512 = this.player.field_7498;
        class_310.method_1551().method_1507(null);
    }

    public abstract void onForget(String var1);

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public int getWaystonesCount() {
        return this.filteredWaystones.size();
    }

    public ArrayList<String> getSearchedWaystones() {
        return this.filteredWaystones;
    }

    public void setFilter(String filter) {
        this.filter = filter.toLowerCase();
    }

    public void filterWaystones() {
        this.filteredWaystones.clear();
        SearchType searchType = ((PlayerEntityMixinAccess)this.player).getSearchType();
        for (String waystone : this.sortedWaystones) {
            String name = FabricWaystones.WAYSTONE_STORAGE.getName(waystone).toLowerCase();
            if (!"".equals(this.filter) && !searchType.match(name, this.filter)) continue;
            this.filteredWaystones.add(waystone);
        }
    }

    public class_1799 method_7601(class_1657 player, int index) {
        return class_1799.field_8037;
    }

    public void toggleSearchType() {
        PlayerEntityMixinAccess playerAccess = (PlayerEntityMixinAccess)this.player;
        SearchType searchType = playerAccess.getSearchType();
        SearchType[] searchValues = SearchType.values();
        playerAccess.setSearchType(searchValues[(searchType.ordinal() + 1) % searchValues.length]);
        this.filterWaystones();
    }

    public class_2561 getSearchTypeTooltip() {
        return class_2561.method_43471((String)("fwaystones.gui." + ((PlayerEntityMixinAccess)this.player).getSearchType().name().toLowerCase()));
    }
}

