/*
 * Decompiled with CFR 0.152.
 */
package wraith.fwaystones.mixin;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1282;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wraith.fwaystones.FabricWaystones;
import wraith.fwaystones.access.PlayerEntityMixinAccess;
import wraith.fwaystones.block.WaystoneBlockEntity;
import wraith.fwaystones.integration.event.WaystoneEvents;
import wraith.fwaystones.util.SearchType;
import wraith.fwaystones.util.WaystonePacketHandler;

@Mixin(value={class_1657.class})
public class PlayerEntityMixin
implements PlayerEntityMixinAccess {
    private final Set<String> discoveredWaystones = ConcurrentHashMap.newKeySet();
    private boolean viewDiscoveredWaystones = true;
    private boolean viewGlobalWaystones = true;
    private boolean autofocusWaystoneFields = true;
    private SearchType waystoneSearchType = SearchType.CONTAINS;
    private int teleportCooldown = 0;

    private class_1657 _this() {
        return (class_1657)this;
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    public void tick(CallbackInfo ci) {
        if (this.teleportCooldown <= 0) {
            return;
        }
        this.teleportCooldown = Math.max(0, this.teleportCooldown - 1);
    }

    @Inject(method={"applyDamage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;applyArmorToDamage(Lnet/minecraft/entity/damage/DamageSource;F)F")})
    public void applyDamage(class_1282 source, float amount, CallbackInfo ci) {
        if (source == class_1282.field_5849) {
            return;
        }
        this.setTeleportCooldown(FabricWaystones.CONFIG.teleportation_cooldown.cooldown_ticks_when_hurt());
    }

    @Override
    public int getTeleportCooldown() {
        return this.teleportCooldown;
    }

    @Override
    public void setTeleportCooldown(int cooldown) {
        if (cooldown > 0) {
            this.teleportCooldown = cooldown;
        }
    }

    @Override
    public void discoverWaystone(WaystoneBlockEntity waystone) {
        this.discoverWaystone(waystone.getHash());
    }

    @Override
    public void discoverWaystone(String hash) {
        this.discoverWaystone(hash, true);
    }

    @Override
    public void discoverWaystone(String hash, boolean sync) {
        ((WaystoneEvents.UpdateWaystone)WaystoneEvents.DISCOVER_WAYSTONE_EVENT.invoker()).onUpdate(hash);
        this.discoveredWaystones.add(hash);
        if (sync) {
            this.syncData();
        }
    }

    @Override
    public boolean hasDiscoveredWaystone(WaystoneBlockEntity waystone) {
        return this.discoveredWaystones.contains(waystone.getHash());
    }

    @Override
    public void forgetWaystone(WaystoneBlockEntity waystone) {
        this.forgetWaystone(waystone.getHash());
    }

    @Override
    public void forgetWaystone(String hash) {
        this.forgetWaystone(hash, true);
    }

    @Override
    public void forgetWaystone(String hash, boolean sync) {
        WaystoneBlockEntity waystone = FabricWaystones.WAYSTONE_STORAGE.getWaystoneEntity(hash);
        class_1657 player = this._this();
        if (waystone != null) {
            if (waystone.isGlobal()) {
                return;
            }
            MinecraftServer server = player.method_5682();
            if (server != null && !server.method_3816() || player.method_5667().equals(waystone.getOwner())) {
                waystone.setOwner(null);
            }
        }
        ((WaystoneEvents.RemoveWaystone)WaystoneEvents.REMOVE_WAYSTONE_EVENT.invoker()).onRemove(hash);
        this.discoveredWaystones.remove(hash);
        if (sync) {
            this.syncData();
        }
    }

    @Override
    public void syncData() {
        class_1657 class_16572 = this._this();
        if (!(class_16572 instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayerEntity = (class_3222)class_16572;
        class_2540 packet = PacketByteBufs.create();
        packet.method_10794(this.toTagW(new class_2487()));
        ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_2960)WaystonePacketHandler.SYNC_PLAYER, (class_2540)packet);
    }

    @Override
    public Set<String> getDiscoveredWaystones() {
        return this.discoveredWaystones;
    }

    @Override
    public int getDiscoveredCount() {
        return this.discoveredWaystones.size();
    }

    @Override
    public ArrayList<String> getWaystonesSorted() {
        ArrayList<String> waystones = new ArrayList<String>();
        HashSet<String> toRemove = new HashSet<String>();
        for (String hash : this.discoveredWaystones) {
            if (FabricWaystones.WAYSTONE_STORAGE.containsHash(hash)) {
                waystones.add(FabricWaystones.WAYSTONE_STORAGE.getWaystoneEntity(hash).getWaystoneName());
                continue;
            }
            toRemove.add(hash);
        }
        for (String remove : toRemove) {
            this.discoveredWaystones.remove(remove);
        }
        waystones.sort(String::compareTo);
        return waystones;
    }

    @Override
    public ArrayList<String> getHashesSorted() {
        ArrayList<String> waystones = new ArrayList<String>();
        HashSet<String> toRemove = new HashSet<String>();
        for (String hash : this.discoveredWaystones) {
            if (FabricWaystones.WAYSTONE_STORAGE.containsHash(hash)) {
                waystones.add(hash);
                continue;
            }
            toRemove.add(hash);
        }
        for (String remove : toRemove) {
            this.discoveredWaystones.remove(remove);
        }
        waystones.sort(Comparator.comparing(a -> FabricWaystones.WAYSTONE_STORAGE.getWaystoneEntity((String)a).getWaystoneName()));
        return waystones;
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="RETURN")})
    public void writeCustomDataToNbt(class_2487 tag, CallbackInfo ci) {
        this.toTagW(tag);
    }

    @Override
    public class_2487 toTagW(class_2487 tag) {
        class_2487 customTag = new class_2487();
        class_2499 waystones = new class_2499();
        for (String waystone : this.discoveredWaystones) {
            waystones.add((Object)class_2519.method_23256((String)waystone));
        }
        customTag.method_10566("discovered_waystones", (class_2520)waystones);
        customTag.method_10556("view_discovered_waystones", this.viewDiscoveredWaystones);
        customTag.method_10556("view_global_waystones", this.viewGlobalWaystones);
        customTag.method_10556("autofocus_waystone_fields", this.autofocusWaystoneFields);
        customTag.method_10582("waystone_search_type", this.waystoneSearchType.name());
        tag.method_10566("fwaystones", (class_2520)customTag);
        return tag;
    }

    @Override
    public void learnWaystones(class_1657 player) {
        this.discoveredWaystones.clear();
        ((PlayerEntityMixinAccess)player).getDiscoveredWaystones().forEach(hash -> this.discoverWaystone((String)hash, false));
        this.syncData();
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="RETURN")})
    public void readCustomDataFromNbt(class_2487 tag, CallbackInfo ci) {
        this.fromTagW(tag);
    }

    @Override
    public void fromTagW(class_2487 tag) {
        if (!tag.method_10545("fwaystones")) {
            return;
        }
        if ((tag = tag.method_10562("fwaystones")).method_10545("discovered_waystones")) {
            HashSet<String> oldDiscovered = new HashSet<String>(this.discoveredWaystones);
            this.discoveredWaystones.clear();
            HashSet<Object> hashes = new HashSet();
            if (FabricWaystones.WAYSTONE_STORAGE != null) {
                hashes = FabricWaystones.WAYSTONE_STORAGE.getAllHashes();
            }
            tag.method_10554("discovered_waystones", 8).stream().map(class_2520::method_10714).filter(hashes::contains).forEach(hash -> {
                this.discoveredWaystones.add((String)hash);
                if (!oldDiscovered.contains(hash)) {
                    ((WaystoneEvents.UpdateWaystone)WaystoneEvents.DISCOVER_WAYSTONE_EVENT.invoker()).onUpdate((String)hash);
                }
            });
        }
        if (tag.method_10545("view_global_waystones")) {
            this.viewGlobalWaystones = tag.method_10577("view_global_waystones");
        }
        if (tag.method_10545("view_discovered_waystones")) {
            this.viewDiscoveredWaystones = tag.method_10577("view_discovered_waystones");
        }
        if (tag.method_10545("autofocus_waystone_fields")) {
            this.autofocusWaystoneFields = tag.method_10577("autofocus_waystone_fields");
        }
        if (tag.method_10545("waystone_search_type")) {
            try {
                this.waystoneSearchType = SearchType.valueOf(tag.method_10558("waystone_search_type"));
            }
            catch (IllegalArgumentException e) {
                FabricWaystones.LOGGER.warn("Received invalid waystone search type: " + tag.method_10558("waystone_search_type"));
            }
        }
    }

    @Override
    public boolean shouldViewGlobalWaystones() {
        return this.viewGlobalWaystones;
    }

    @Override
    public boolean shouldViewDiscoveredWaystones() {
        return this.viewDiscoveredWaystones;
    }

    @Override
    public void toggleViewGlobalWaystones() {
        this.viewGlobalWaystones = !this.viewGlobalWaystones;
        this.syncData();
    }

    @Override
    public void toggleViewDiscoveredWaystones() {
        this.viewDiscoveredWaystones = !this.viewDiscoveredWaystones;
        this.syncData();
    }

    @Override
    public boolean hasDiscoveredWaystone(String hash) {
        return this.discoveredWaystones.contains(hash);
    }

    @Override
    public void discoverWaystones(HashSet<String> toLearn) {
        if (FabricWaystones.WAYSTONE_STORAGE == null) {
            return;
        }
        toLearn.forEach(hash -> this.discoverWaystone((String)hash, false));
        this.syncData();
    }

    @Override
    public void forgetWaystones(HashSet<String> toForget) {
        toForget.forEach(hash -> this.forgetWaystone((String)hash, false));
        this.syncData();
    }

    @Override
    public void forgetAllWaystones() {
        this.discoveredWaystones.clear();
        ((WaystoneEvents.ForgetAllWaystones)WaystoneEvents.FORGET_ALL_WAYSTONES_EVENT.invoker()).onForgetAll(this._this());
        this.syncData();
    }

    @Override
    public boolean autofocusWaystoneFields() {
        return this.autofocusWaystoneFields;
    }

    @Override
    public void toggleAutofocusWaystoneFields() {
        this.autofocusWaystoneFields = !this.autofocusWaystoneFields;
    }

    @Override
    public SearchType getSearchType() {
        return this.waystoneSearchType;
    }

    @Override
    public void setSearchType(SearchType searchType) {
        this.waystoneSearchType = searchType;
    }
}

