/*
 * Decompiled with CFR 0.152.
 */
package amymialee.piercingpaxels.items;

import amymialee.piercingpaxels.PiercingPaxels;
import amymialee.piercingpaxels.compat.techreborn.TechRebornPaxels;
import amymialee.piercingpaxels.registry.PiercingItems;
import amymialee.piercingpaxels.screens.PaxelScreenHandler;
import amymialee.piercingpaxels.util.PaxelTooltipData;
import com.google.common.collect.BiMap;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.mininglevel.v1.MiningLevelManager;
import net.fabricmc.fabric.mixin.content.registry.AxeItemAccessor;
import net.fabricmc.fabric.mixin.content.registry.HoeItemAccessor;
import net.fabricmc.fabric.mixin.content.registry.ShovelItemAccessor;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1262;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_174;
import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_239;
import net.minecraft.class_2465;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_3922;
import net.minecraft.class_3965;
import net.minecraft.class_5632;
import net.minecraft.class_5712;
import net.minecraft.class_5953;
import net.minecraft.class_5955;
import org.jetbrains.annotations.Nullable;

public class PaxelItem
extends class_1766 {
    public PaxelItem(class_1832 material, float attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(attackDamage, attackSpeed, material, PiercingPaxels.PAXEL_MINEABLE, settings.method_7898(material.method_8025() * 3));
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (user.method_5715() && !world.field_9236 && user instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)user;
            this.openMenu(serverPlayer, stack);
            return class_1271.method_22427((Object)user.method_5998(hand));
        }
        class_1799 upgradeActive = PaxelItem.getUpgrade(stack, 0);
        if (upgradeActive != null && !upgradeActive.method_7960()) {
            user.method_6019(hand);
            return class_1271.method_22428((Object)user.method_5998(hand));
        }
        return class_1271.method_22430((Object)user.method_5998(hand));
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        block16: {
            class_3965 blockHitResult;
            class_239 hitResult;
            class_3222 player;
            if (!(user instanceof class_3222) || (player = (class_3222)user).method_5715() || !this.isNotBroken(stack) || player.field_7512 != player.field_7498 || !((hitResult = user.method_5745(5.0, 1.0f, false)) instanceof class_3965) || world.method_8320((blockHitResult = (class_3965)hitResult).method_17777()).method_26215()) break block16;
            class_1799 upgradeActive = PaxelItem.getUpgrade(stack, 0);
            class_1799 upgradePassive = PaxelItem.getUpgrade(stack, 1);
            if (upgradeActive != null) {
                class_2350 direction = blockHitResult.method_17780();
                if (upgradeActive.method_31574(PiercingItems.ACTIVE_WALL)) {
                    for (int i = -1; i <= 1; ++i) {
                        for (int j = -1; j <= 1; ++j) {
                            class_2338 pos = null;
                            switch (direction.method_10166()) {
                                case field_11048: {
                                    pos = blockHitResult.method_17777().method_10069(0, i, j);
                                    break;
                                }
                                case field_11052: {
                                    pos = blockHitResult.method_17777().method_10069(i, 0, j);
                                    break;
                                }
                                case field_11051: {
                                    pos = blockHitResult.method_17777().method_10069(i, j, 0);
                                }
                            }
                            class_2680 state = world.method_8320(pos);
                            if (pos == null || !this.method_7856(state) || state.method_26214((class_1922)world, pos) == -1.0f) continue;
                            player.field_13974.method_14266(pos);
                            if (upgradePassive != null && upgradePassive.method_31574(PiercingItems.PASSIVE_SILENCE)) continue;
                            world.method_20290(2001, pos, class_2248.method_9507((class_2680)state));
                            world.method_43276(class_5712.field_28165, pos, class_5712.class_7397.method_43286((class_1297)user, (class_2680)state));
                        }
                    }
                } else if (upgradeActive.method_31574(PiercingItems.ACTIVE_TUNNEL)) {
                    for (int i = 0; i < 3; ++i) {
                        for (int j = -1; j <= 1; ++j) {
                            class_2338 pos = direction.method_10166().method_10179() ? blockHitResult.method_17777().method_10081(direction.method_10163().method_35862(-i)).method_10069(0, j, 0) : blockHitResult.method_17777().method_10081(direction.method_10163().method_35862(-i));
                            class_2680 state = world.method_8320(pos);
                            if (pos == null || !this.method_7856(state) || state.method_26214((class_1922)world, pos) == -1.0f) continue;
                            player.field_13974.method_14266(pos);
                            if (upgradePassive != null && upgradePassive.method_31574(PiercingItems.PASSIVE_SILENCE)) continue;
                            world.method_20290(2001, pos, class_2248.method_9507((class_2680)state));
                            world.method_43276(class_5712.field_28165, pos, class_5712.class_7397.method_43286((class_1297)user, (class_2680)state));
                        }
                    }
                } else if (upgradeActive.method_31574(PiercingItems.ACTIVE_HOLE)) {
                    for (int i = 0; i < 8; ++i) {
                        class_2338 pos = blockHitResult.method_17777().method_10081(direction.method_10163().method_35862(-i));
                        class_2680 state = world.method_8320(pos);
                        if (pos == null || !this.method_7856(state) || state.method_26214((class_1922)world, pos) == -1.0f) continue;
                        player.field_13974.method_14266(pos);
                        if (upgradePassive != null && upgradePassive.method_31574(PiercingItems.PASSIVE_SILENCE)) continue;
                        world.method_20290(2001, pos, class_2248.method_9507((class_2680)state));
                        world.method_43276(class_5712.field_28165, pos, class_5712.class_7397.method_43286((class_1297)user, (class_2680)state));
                    }
                }
            }
        }
        return stack;
    }

    public int method_7881(class_1799 stack) {
        class_1799 upgradeActive = PaxelItem.getUpgrade(stack, 0);
        if (upgradeActive != null && !upgradeActive.method_7960()) {
            float time = (16.0f - this.field_7940) * 2.0f;
            int efficiency = class_1890.method_8225((class_1887)class_1893.field_9131, (class_1799)stack);
            if (efficiency > 0) {
                time -= (float)(efficiency + 1);
            }
            return Math.max((int)time, 1);
        }
        return 0;
    }

    public class_1839 method_7853(class_1799 stack) {
        class_1799 upgradeActive = PaxelItem.getUpgrade(stack, 0);
        if (upgradeActive != null) {
            return class_1839.field_8953;
        }
        return class_1839.field_8952;
    }

    public void method_33261(class_1542 entity) {
        class_1799 paxel = entity.method_6983();
        for (int i = 0; i < 4; ++i) {
            class_1799 upgrade = PaxelItem.getUpgrade(paxel, i);
            entity.method_5775(upgrade);
        }
        super.method_33261(entity);
    }

    protected boolean isNotBroken(class_1799 stack) {
        class_1799 upgradePassive = PaxelItem.getUpgrade(stack, 3);
        return upgradePassive != null && upgradePassive.method_31574(PiercingItems.UPGRADE_UNBREAKABILITY) || stack.method_7919() < stack.method_7936();
    }

    protected boolean damagePaxel(class_1799 stack, class_1309 user) {
        class_1799 upgradePassive = PaxelItem.getUpgrade(stack, 3);
        if (upgradePassive == null || !upgradePassive.method_31574(PiercingItems.UPGRADE_UNBREAKABILITY)) {
            class_3222 player;
            return stack.method_7970(1, user.method_6051(), user instanceof class_3222 ? (player = (class_3222)user) : null);
        }
        return false;
    }

    public float method_7865(class_1799 stack, class_2680 state) {
        return this.isNotBroken(stack) ? this.field_7940 : 0.01f;
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (!this.isNotBroken(stack) || this.damagePaxel(stack, attacker)) {
            attacker.method_20235(class_1304.field_6173);
        }
        return true;
    }

    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        if (!(world.field_9236 || state.method_26214((class_1922)world, pos) == 0.0f || this.isNotBroken(stack) && !this.damagePaxel(stack, miner))) {
            miner.method_20235(class_1304.field_6173);
        }
        return true;
    }

    public boolean method_7856(class_2680 state) {
        int i = this.method_8022().method_8024();
        return i >= MiningLevelManager.getRequiredMiningLevel((class_2680)state);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        class_2371 stacks = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
        if (stack.method_7985() && stack.method_7969() != null) {
            class_1262.method_5429((class_2487)stack.method_7969(), (class_2371)stacks);
        }
        class_2371 filteredStacks = class_2371.method_10211();
        stacks.stream().filter(a -> !a.method_7960()).forEach(arg_0 -> filteredStacks.add(arg_0));
        if (filteredStacks.size() == 0) {
            class_1814 rarity = class_1814.values()[Math.max(0, stack.method_7932().ordinal() - 1)];
            tooltip.add((class_2561)class_2561.method_43471((String)"item.piercingpaxels.paxel.empty_tooltip").method_27692(rarity.field_8908));
        }
        super.method_7851(stack, world, tooltip, context);
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        class_2371 stacks = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
        if (stack.method_7985() && stack.method_7969() != null) {
            class_1262.method_5429((class_2487)stack.method_7969(), (class_2371)stacks);
        }
        class_2371 filteredStacks = class_2371.method_10211();
        stacks.stream().filter(a -> !a.method_7960()).forEach(arg_0 -> filteredStacks.add(arg_0));
        return Optional.of(new PaxelTooltipData(stack.method_7932(), (class_2371<class_1799>)filteredStacks));
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 world = context.method_8045();
        class_2338 blockPos = context.method_8037();
        class_1657 playerEntity = context.method_8036();
        class_2680 blockState = world.method_8320(blockPos);
        class_1799 itemStack = context.method_8041();
        class_1799 upgradeUsage = PaxelItem.getUpgrade(itemStack, 2);
        if (upgradeUsage != null) {
            if (upgradeUsage.method_31574(PiercingItems.USAGE_AXE)) {
                Optional<Object> hasUsed = Optional.empty();
                Optional<class_2680> strip = this.getStrippedState(blockState);
                if (strip.isPresent()) {
                    world.method_8396(playerEntity, blockPos, class_3417.field_14675, class_3419.field_15245, 1.0f, 1.0f);
                    hasUsed = strip;
                } else {
                    Optional reduction = class_5955.method_34735((class_2680)blockState);
                    if (reduction.isPresent()) {
                        world.method_8396(playerEntity, blockPos, class_3417.field_29541, class_3419.field_15245, 1.0f, 1.0f);
                        world.method_8444(playerEntity, 3005, blockPos, 0);
                        hasUsed = reduction;
                    } else {
                        Optional<class_2680> unWax = Optional.ofNullable((class_2248)((BiMap)class_5953.field_29561.get()).get((Object)blockState.method_26204())).map(block -> block.method_34725(blockState));
                        if (unWax.isPresent()) {
                            world.method_8396(playerEntity, blockPos, class_3417.field_29542, class_3419.field_15245, 1.0f, 1.0f);
                            world.method_8444(playerEntity, 3004, blockPos, 0);
                            hasUsed = unWax;
                        }
                    }
                }
                if (hasUsed.isPresent()) {
                    if (playerEntity instanceof class_3222) {
                        class_174.field_24478.method_23889((class_3222)playerEntity, blockPos, itemStack);
                    }
                    world.method_8652(blockPos, (class_2680)hasUsed.get(), 11);
                    world.method_43276(class_5712.field_28733, blockPos, class_5712.class_7397.method_43286((class_1297)playerEntity, (class_2680)((class_2680)hasUsed.get())));
                    return class_1269.method_29236((boolean)world.field_9236);
                }
            } else if (upgradeUsage.method_31574(PiercingItems.USAGE_SHOVEL)) {
                if (context.method_8038() != class_2350.field_11033) {
                    class_2680 blockState2 = (class_2680)ShovelItemAccessor.getPathStates().get(blockState.method_26204());
                    class_2680 blockState3 = null;
                    if (blockState2 != null && world.method_8320(blockPos.method_10084()).method_26215()) {
                        world.method_8396(playerEntity, blockPos, class_3417.field_14616, class_3419.field_15245, 1.0f, 1.0f);
                        blockState3 = blockState2;
                    } else if (blockState.method_26204() instanceof class_3922 && ((Boolean)blockState.method_11654((class_2769)class_3922.field_17352)).booleanValue()) {
                        if (!world.method_8608()) {
                            world.method_8444(null, 1009, blockPos, 0);
                        }
                        class_3922.method_29288((class_1297)context.method_8036(), (class_1936)world, (class_2338)blockPos, (class_2680)blockState);
                        blockState3 = (class_2680)blockState.method_11657((class_2769)class_3922.field_17352, (Comparable)Boolean.valueOf(false));
                    }
                    if (blockState3 != null) {
                        if (!world.field_9236) {
                            world.method_8652(blockPos, blockState3, 11);
                            world.method_43276(class_5712.field_28733, blockPos, class_5712.class_7397.method_43286((class_1297)playerEntity, (class_2680)blockState3));
                        }
                        return class_1269.method_29236((boolean)world.field_9236);
                    }
                    return class_1269.field_5811;
                }
            } else if (upgradeUsage.method_31574(PiercingItems.USAGE_HOE)) {
                blockPos = context.method_8037();
                Pair pair = (Pair)HoeItemAccessor.getTillingActions().get(world.method_8320(blockPos).method_26204());
                if (pair == null) {
                    return class_1269.field_5811;
                }
                Predicate predicate = (Predicate)pair.getFirst();
                Consumer consumer = (Consumer)pair.getSecond();
                if (predicate.test(context)) {
                    world.method_8396(playerEntity, blockPos, class_3417.field_14846, class_3419.field_15245, 1.0f, 1.0f);
                    if (!world.field_9236) {
                        consumer.accept(context);
                    }
                    return class_1269.method_29236((boolean)world.field_9236);
                }
            }
            if (FabricLoader.getInstance().isModLoaded("techreborn")) {
                TechRebornPaxels.paxelUsages(upgradeUsage, context);
            }
        }
        return class_1269.field_5811;
    }

    public static class_1799 getUpgrade(class_1799 stack, int slot) {
        if (slot > 3 || slot < 0) {
            return null;
        }
        class_2371 stacks = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
        if (stack.method_7985() && stack.method_7969() != null) {
            class_1262.method_5429((class_2487)stack.method_7969(), (class_2371)stacks);
            return (class_1799)stacks.get(slot);
        }
        return null;
    }

    public boolean method_31567(class_1799 stack) {
        class_1799 upgradePassive = PaxelItem.getUpgrade(stack, 3);
        if (upgradePassive != null && upgradePassive.method_31574(PiercingItems.UPGRADE_UNBREAKABILITY)) {
            return false;
        }
        return super.method_31567(stack);
    }

    public int method_31571(class_1799 stack) {
        if (stack.method_7932().field_8908.method_532() != null) {
            return stack.method_7932().field_8908.method_532();
        }
        return super.method_31571(stack);
    }

    public void openMenu(class_3222 player, final class_1799 stack) {
        class_3908 menu = new class_3908(){

            public class_2561 method_5476() {
                return stack.method_7964();
            }

            public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
                return new PaxelScreenHandler(syncId, playerInventory, stack);
            }
        };
        player.method_17355(menu);
    }

    private Optional<class_2680> getStrippedState(class_2680 state) {
        return Optional.ofNullable((class_2248)AxeItemAccessor.getStrippedBlocks().get(state.method_26204())).map(block -> (class_2680)block.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459))));
    }
}

