/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.linkedstorage.network;

import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.kyrptonaught.linkedstorage.inventory.LinkedContainer;
import net.kyrptonaught.linkedstorage.network.UpdateViewerList;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ChannelViewers {
    private static final ConcurrentHashMap<String, Set<UUID>> viewers = new ConcurrentHashMap();

    public static Boolean getViewersFor(String channel) {
        if (!viewers.containsKey(channel)) {
            return false;
        }
        return viewers.get(channel).size() > 0;
    }

    static void addViewerFor(String channel, UUID uuid) {
        if (!viewers.containsKey(channel)) {
            viewers.put(channel, ConcurrentHashMap.newKeySet());
        }
        viewers.get(channel).add(uuid);
    }

    public static void addViewerFor(String channel, class_1657 player) {
        ChannelViewers.addViewerFor(channel, player.method_5667());
        if (!player.field_6002.field_9236) {
            UpdateViewerList.sendPacket(player.method_5682(), channel, player.method_5667(), true);
        }
    }

    static void removeViewerFor(String channel, UUID player) {
        ((Set)viewers.getOrDefault(channel, ConcurrentHashMap.newKeySet())).remove(player);
    }

    private static void removeViewerForServer(String channel, UUID player, MinecraftServer server) {
        ChannelViewers.removeViewerFor(channel, player);
        UpdateViewerList.sendPacket(server, channel, player, false);
    }

    public static void registerChannelWatcher() {
        ServerTickEvents.START_SERVER_TICK.register(server -> {
            for (String channel : viewers.keySet()) {
                for (UUID uuid : viewers.get(channel)) {
                    class_3222 player = server.method_3760().method_14602(uuid);
                    if (player != null && player.field_7512 instanceof LinkedContainer) continue;
                    ChannelViewers.removeViewerForServer(channel, uuid, server);
                }
            }
        });
    }
}

