/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.linkedstorage.block;

import com.google.common.base.Preconditions;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.kyrptonaught.linkedstorage.LinkedStorageMod;
import net.kyrptonaught.linkedstorage.block.OpenableBlockEntity;
import net.kyrptonaught.linkedstorage.block.StorageBlock;
import net.kyrptonaught.linkedstorage.inventory.LinkedInventory;
import net.kyrptonaught.linkedstorage.network.ChannelViewers;
import net.kyrptonaught.linkedstorage.util.DyeChannel;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class StorageBlockEntity
extends OpenableBlockEntity {
    private DyeChannel dyeChannel = DyeChannel.defaultChannel();
    private LinkedInventory linkedInventory;

    StorageBlockEntity(class_2338 pos, class_2680 state) {
        super(StorageBlock.blockEntity, pos, state);
    }

    StorageBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void method_11014(class_2487 compoundTag_1) {
        super.method_11014(compoundTag_1);
        this.dyeChannel = DyeChannel.fromTag(compoundTag_1);
        this.method_5431();
    }

    public void method_11007(class_2487 compoundTag_1) {
        super.method_11007(compoundTag_1);
        this.dyeChannel.toTag(compoundTag_1);
    }

    LinkedInventory getLinkedInventory() {
        if (this.linkedInventory == null) {
            this.updateInventory();
        }
        return this.linkedInventory;
    }

    private void updateInventory() {
        if (!this.field_11863.field_9236) {
            this.linkedInventory = LinkedStorageMod.getInventory(this.dyeChannel);
        }
    }

    public void setDye(int slot, int dye) {
        this.dyeChannel.setSlot(slot, (byte)dye);
        this.updateInventory();
        this.method_5431();
        if (!this.field_11863.field_9236) {
            this.sync();
        }
    }

    public void setChannel(DyeChannel channel) {
        this.dyeChannel = channel;
        this.updateInventory();
        this.method_5431();
        if (!this.field_11863.field_9236) {
            this.sync();
        }
    }

    public DyeChannel getChannel() {
        return this.dyeChannel;
    }

    public final class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public final class_2487 method_16887() {
        class_2487 nbt = super.method_16887();
        this.method_11007(nbt);
        return nbt;
    }

    public void sync() {
        Preconditions.checkNotNull((Object)this.field_11863);
        if (!(this.field_11863 instanceof class_3218)) {
            throw new IllegalStateException("Cannot call sync() on the logical client! Did you check world.isClient first?");
        }
        ((class_3218)this.field_11863).method_14178().method_14128(this.method_11016());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int countViewers() {
        return ChannelViewers.getViewersFor(this.dyeChannel.getChannelName()) != false ? 1 : 0;
    }
}

