/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.Sounds;
import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.config.Config;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.misc.VehicleInventoryDescription;
import immersive_aircraft.item.upgrade.AircraftStat;
import immersive_aircraft.network.c2s.EnginePowerMessage;
import immersive_aircraft.util.InterpolatedFloat;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2609;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3414;

public abstract class EngineAircraft
extends AircraftEntity {
    static final class_2940<Float> ENGINE = class_2945.method_12791(EngineAircraft.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> UTILIZATION = class_2945.method_12791(EngineAircraft.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Boolean> LOW_ON_FUEL = class_2945.method_12791(EngineAircraft.class, (class_2941)class_2943.field_13323);
    public final InterpolatedFloat engineRotation = new InterpolatedFloat();
    public final InterpolatedFloat enginePower = new InterpolatedFloat(20.0f);
    public float engineSpinUpStrength = 0.0f;
    public float engineSound = 0.0f;
    FuelState lastFuelState = FuelState.NEVER;
    public static final int TARGET_FUEL = 1000;
    public static final int LOW_FUEL = 900;
    private final int[] fuel = new int[this.getInventoryDescription().getSlots(VehicleInventoryDescription.SlotType.BOILER).size()];
    public static Map<class_1792, Integer> cachedFuels;

    public GUI_STYLE getGuiStyle() {
        return GUI_STYLE.ENGINE;
    }

    public EngineAircraft(class_1299<? extends AircraftEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    class_3414 getEngineStartSound() {
        return Sounds.ENGINE_START.get();
    }

    class_3414 getEngineSound() {
        return Sounds.PROPELLER.get();
    }

    float getEnginePitch() {
        return 1.0f;
    }

    float getStabilizer() {
        return 0.0f;
    }

    float getBaseFuelConsumption() {
        return 0.75f;
    }

    float getEngineReactionSpeed() {
        return 20.0f;
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ENGINE, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(UTILIZATION, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(LOW_ON_FUEL, (Object)false);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        this.enginePower.setSteps(this.getEngineReactionSpeed() / this.getTotalUpgrade(AircraftStat.ACCELERATION));
        this.enginePower.update(this.getEngineTarget() * (this.field_5957 ? 0.1f : 1.0f));
        this.engineSpinUpStrength = Math.max(0.0f, this.engineSpinUpStrength + this.enginePower.getDiff() - 0.01f);
        if (this.field_6002.method_8608()) {
            this.engineRotation.update((this.engineRotation.getValue() + this.getEnginePower()) % 1000.0f);
        }
        if (!this.method_5782() && this.getEngineTarget() > 0.0f) {
            this.setEngineTarget(0.0f);
        }
        if (this.field_6002.field_9236) {
            this.engineSound += this.getEnginePower() * 0.25f;
            if (this.engineSound > 1.0f) {
                this.engineSound -= 1.0f;
                if (this.isFuelLow()) {
                    this.engineSound -= (float)this.field_5974.method_43048(2);
                }
                this.field_6002.method_8486(this.method_23317(), this.method_23318(), this.method_23321(), this.getEngineSound(), this.method_5634(), Math.min(1.0f, 0.25f + this.engineSpinUpStrength), (this.field_5974.method_43057() * 0.1f + 0.95f) * this.getEnginePitch(), false);
            }
        }
        if (this.fuel.length > 0 && !this.field_6002.field_9236) {
            for (float consumption = this.getFuelConsumption(); consumption > 0.0f && (consumption >= 1.0f || this.field_5974.method_43057() < consumption); consumption -= 1.0f) {
                for (int i = 0; i < this.fuel.length; ++i) {
                    if (this.fuel[i] <= 0) continue;
                    int n = i;
                    this.fuel[n] = this.fuel[n] - 1;
                }
            }
        }
        if (this.method_5782()) {
            this.refuel();
            class_1297 i = this.method_5642();
            if (i instanceof class_3222) {
                class_3222 player = (class_3222)i;
                float utilization = this.getFuelUtilization();
                if (utilization > 0.0f && this.isFuelLow()) {
                    if (this.lastFuelState != FuelState.LOW) {
                        player.method_7353((class_2561)class_2561.method_43471((String)("immersive_aircraft." + this.getFuelType() + ".low")), true);
                        this.lastFuelState = FuelState.LOW;
                    }
                } else if (utilization > 0.0f) {
                    this.lastFuelState = FuelState.FUELED;
                } else if (this.lastFuelState != FuelState.EMPTY) {
                    player.method_7353((class_2561)class_2561.method_43471((String)("immersive_aircraft." + this.getFuelType() + "." + (this.lastFuelState == FuelState.FUELED ? "out" : "none"))), true);
                    this.lastFuelState = FuelState.EMPTY;
                }
            }
        } else {
            this.lastFuelState = FuelState.NEVER;
        }
    }

    protected boolean isFuelLow() {
        if (this.field_6002.field_9236) {
            return (Boolean)this.field_6011.method_12789(LOW_ON_FUEL);
        }
        boolean low = true;
        for (int i : this.fuel) {
            if (i <= 900) continue;
            low = false;
            break;
        }
        this.field_6011.method_12778(LOW_ON_FUEL, (Object)low);
        return low;
    }

    String getFuelType() {
        return "fuel";
    }

    float getFuelConsumption() {
        return this.getEngineTarget() * this.getTotalUpgrade(AircraftStat.FUEL) * this.getBaseFuelConsumption() * Config.getInstance().fuelConsumption;
    }

    private void refuel(int i) {
        while (this.fuel[i] <= 1000) {
            List<VehicleInventoryDescription.Slot> slots = this.getInventoryDescription().getSlots(VehicleInventoryDescription.SlotType.BOILER);
            class_1799 stack = this.inventory.method_5438(slots.get((int)i).index);
            int time = EngineAircraft.getFuelTime(stack);
            if (time <= 0) break;
            int n = i;
            this.fuel[n] = this.fuel[n] + time;
            class_1792 item = stack.method_7909();
            stack.method_7934(1);
            if (!stack.method_7960()) continue;
            class_1792 item2 = item.method_7858();
            this.inventory.method_5447(slots.get((int)i).index, item2 == null ? class_1799.field_8037 : new class_1799((class_1935)item2));
        }
    }

    private void refuel() {
        for (int i = 0; i < this.fuel.length; ++i) {
            this.refuel(i);
        }
    }

    @Override
    void updateController() {
        this.method_36456(this.method_36454() - this.getProperties().getYawSpeed() * this.pressingInterpolatedX.getSmooth());
        if (!this.field_5952) {
            this.method_36457(this.method_36455() + this.getProperties().getPitchSpeed() * this.pressingInterpolatedZ.getSmooth());
        }
        this.method_36457(this.method_36455() * (1.0f - this.getStabilizer()));
    }

    @Override
    void updateVelocity() {
        super.updateVelocity();
        if (this.field_5952) {
            this.method_36457((this.method_36455() + this.getProperties().getGroundPitch()) * 0.9f - this.getProperties().getGroundPitch());
        }
    }

    public float getEnginePower() {
        return (float)((double)this.enginePower.getSmooth() * Math.sqrt(this.getFuelUtilization()));
    }

    public float getEngineTarget() {
        return ((Float)this.field_6011.method_12789(ENGINE)).floatValue();
    }

    public void setEngineTarget(float engineTarget) {
        if (this.getFuelUtilization() > 0.0f || engineTarget == 0.0f) {
            if (this.field_6002.field_9236) {
                if (this.getEngineTarget() != engineTarget) {
                    NetworkHandler.sendToServer(new EnginePowerMessage(engineTarget));
                }
                if (this.getFuelUtilization() > 0.0f && (double)this.getEngineTarget() == 0.0 && engineTarget > 0.0f) {
                    this.field_6002.method_8486(this.method_23317(), this.method_23318(), this.method_23321(), this.getEngineStartSound(), this.method_5634(), 1.0f, this.getEnginePitch(), false);
                }
            }
            this.field_6011.method_12778(ENGINE, (Object)Float.valueOf(engineTarget));
        }
    }

    public static int getFuelTime(class_1799 fuel) {
        if (fuel.method_7960()) {
            return 0;
        }
        class_1792 item = fuel.method_7909();
        if (cachedFuels == null) {
            cachedFuels = class_2609.method_11196();
        }
        if (Config.getInstance().acceptVanillaFuel && cachedFuels.containsKey(item)) {
            return cachedFuels.get(item);
        }
        return Config.getInstance().fuelList.getOrDefault(class_2378.field_11142.method_10221((Object)item).toString(), 0);
    }

    public float getFuelUtilization() {
        class_1657 player;
        class_1297 object;
        if (Config.getInstance().fuelConsumption == 0.0f) {
            return 1.0f;
        }
        if (!Config.getInstance().burnFuelInCreative && (object = this.method_5642()) instanceof class_1657 && (player = (class_1657)object).method_7337()) {
            return 1.0f;
        }
        if (this.field_6002.field_9236) {
            return ((Float)this.field_6011.method_12789(UTILIZATION)).floatValue();
        }
        int running = 0;
        for (int i : this.fuel) {
            if (i <= 0) continue;
            ++running;
        }
        float f = (float)running / (float)this.fuel.length * (this.isFuelLow() ? 0.75f : 1.0f);
        this.field_6011.method_12778(UTILIZATION, (Object)Float.valueOf(f));
        return f;
    }

    public static enum GUI_STYLE {
        NONE,
        ENGINE;

    }

    static enum FuelState {
        NEVER,
        EMPTY,
        FUELED,
        LOW;

    }
}

