/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.Items;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.AirplaneEntity;
import immersive_aircraft.entity.misc.Trail;
import immersive_aircraft.entity.misc.VehicleInventoryDescription;
import java.util.List;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_4581;

public class BiplaneEntity
extends AirplaneEntity {
    private static final VehicleInventoryDescription inventoryDescription = new VehicleInventoryDescription().addSlot(VehicleInventoryDescription.SlotType.BOILER, 17, 30).addSlot(VehicleInventoryDescription.SlotType.BOOSTER, 17, 56).addSlot(VehicleInventoryDescription.SlotType.WEAPON, 50, 14).addSlot(VehicleInventoryDescription.SlotType.BANNER, 72, 14).addSlot(VehicleInventoryDescription.SlotType.UPGRADE, 50, 36).addSlot(VehicleInventoryDescription.SlotType.UPGRADE, 72, 36).addSlot(VehicleInventoryDescription.SlotType.UPGRADE, 50, 58).addSlot(VehicleInventoryDescription.SlotType.UPGRADE, 72, 58).addSlots(VehicleInventoryDescription.SlotType.INVENTORY, 98, 8, 4, 4).build();
    final List<List<class_243>> PASSENGER_POSITIONS = List.of(List.of(new class_243(0.0, (double)0.05f, (double)-0.6f)));
    private final List<Trail> trails = List.of(new Trail(40), new Trail(40));

    @Override
    public VehicleInventoryDescription getInventoryDescription() {
        return inventoryDescription;
    }

    public BiplaneEntity(class_1299<? extends AircraftEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    float getBaseFuelConsumption() {
        return 1.25f;
    }

    @Override
    protected List<List<class_243>> getPassengerPositions() {
        return this.PASSENGER_POSITIONS;
    }

    @Override
    public List<Trail> getTrails() {
        return this.trails;
    }

    private void trail(class_1159 transform, int index, float x, float y, float z) {
        class_1162 p0 = this.transformPosition(transform, x, y - 0.15f, z);
        class_1162 p1 = this.transformPosition(transform, x, y + 0.15f, z);
        float trailStrength = Math.max(0.0f, Math.min(1.0f, (float)(Math.sqrt(this.method_18798().method_1033()) * (double)(0.5f + this.pressingInterpolatedX.getSmooth() * x * 0.025f) - 0.25)));
        this.trails.get(index).add(p0, p1, trailStrength);
    }

    @Override
    public class_1792 asItem() {
        return Items.BIPLANE.get();
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.field_6002.field_9236) {
            if (this.isWithinParticleRange()) {
                class_1159 transform = this.getVehicleTransform();
                class_4581 normalTransform = this.getVehicleNormalTransform();
                this.trail(transform, 0, -3.75f, 0.25f, 0.6f);
                this.trail(transform, 1, 3.75f, 0.25f, 0.6f);
                float power = this.getEnginePower();
                if ((double)power > 0.05) {
                    class_1162 p = this.transformPosition(transform, 0.325f * (this.field_6012 % 4 == 0 ? -1.0f : 1.0f), 0.5f, 0.8f);
                    class_1160 vel = this.transformVector(normalTransform, 0.2f * (this.field_6012 % 4 == 0 ? -1.0f : 1.0f), 0.0f, 0.0f);
                    class_243 velocity = this.method_18798();
                    this.field_6002.method_8406((class_2394)class_2398.field_11251, (double)p.method_4953(), (double)p.method_4956(), (double)p.method_4957(), (double)vel.method_4943() + velocity.field_1352, (double)vel.method_4945() + velocity.field_1351, (double)vel.method_4947() + velocity.field_1350);
                }
            } else {
                this.trails.get(0).add(ZERO_VEC4, ZERO_VEC4, 0.0f);
                this.trails.get(1).add(ZERO_VEC4, ZERO_VEC4, 0.0f);
            }
        }
    }
}

