/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.Items;
import immersive_aircraft.Sounds;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.Rotorcraft;
import immersive_aircraft.entity.misc.AircraftProperties;
import immersive_aircraft.entity.misc.Trail;
import immersive_aircraft.entity.misc.VehicleInventoryDescription;
import java.util.List;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3414;

public class AirshipEntity
extends Rotorcraft {
    private final AircraftProperties properties = new AircraftProperties(this).setYawSpeed(5.0f).setEngineSpeed(0.02f).setVerticalSpeed(0.025f).setGlideFactor(0.0f).setDriftDrag(0.01f).setLift(0.1f).setRollFactor(5.0f).setWindSensitivity(0.05f).setMass(3.0f);
    private static final VehicleInventoryDescription inventoryDescription = new VehicleInventoryDescription().addSlot(VehicleInventoryDescription.SlotType.BOILER, 17, 44).addSlot(VehicleInventoryDescription.SlotType.WEAPON, 50, 14).addSlot(VehicleInventoryDescription.SlotType.WEAPON, 72, 14).addSlot(VehicleInventoryDescription.SlotType.UPGRADE, 50, 36).addSlot(VehicleInventoryDescription.SlotType.UPGRADE, 72, 36).addSlot(VehicleInventoryDescription.SlotType.BANNER, 50, 58).addSlot(VehicleInventoryDescription.SlotType.DYE, 72, 58).addSlots(VehicleInventoryDescription.SlotType.INVENTORY, 98, 8, 4, 4).build();
    final List<List<class_243>> PASSENGER_POSITIONS = List.of(List.of(new class_243(0.0, (double)-0.1f, 0.0)), List.of(new class_243(0.0, (double)-0.1f, (double)0.4f), new class_243(0.0, (double)-0.1f, (double)-0.3f)));
    private final List<Trail> trails = List.of(new Trail(15, 0.5f));

    @Override
    public VehicleInventoryDescription getInventoryDescription() {
        return inventoryDescription;
    }

    public AirshipEntity(class_1299<? extends AircraftEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    float getEngineReactionSpeed() {
        return 50.0f;
    }

    @Override
    class_3414 getEngineSound() {
        return Sounds.PROPELLER_SMALL.get();
    }

    @Override
    public AircraftProperties getProperties() {
        return this.properties;
    }

    @Override
    float getGroundVelocityDecay() {
        return 0.5f;
    }

    @Override
    float getHorizontalVelocityDelay() {
        return 0.97f;
    }

    @Override
    float getVerticalVelocityDelay() {
        return 0.925f;
    }

    @Override
    float getStabilizer() {
        return 0.1f;
    }

    @Override
    public class_1792 asItem() {
        return Items.AIRSHIP.get();
    }

    @Override
    public List<Trail> getTrails() {
        return this.trails;
    }

    void trail(class_1159 transform) {
        this.trail(transform, 0);
    }

    void trail(class_1159 transform, int index) {
        class_1162 p0 = this.transformPosition(transform, -0.15f, 0.0f, 0.0f);
        class_1162 p1 = this.transformPosition(transform, 0.15f, 0.0f, 0.0f);
        float trailStrength = Math.max(0.0f, Math.min(1.0f, (float)(this.method_18798().method_1033() - (double)0.05f)));
        this.getTrails().get(index).add(p0, p1, trailStrength);
    }

    @Override
    protected List<List<class_243>> getPassengerPositions() {
        return this.PASSENGER_POSITIONS;
    }

    @Override
    protected float getGravity() {
        return this.field_5957 ? 0.04f : (1.0f - this.getEnginePower()) * super.getGravity();
    }

    @Override
    void updateController() {
        super.updateController();
        this.setEngineTarget(1.0f);
        this.method_18799(this.method_18798().method_1031(0.0, (double)(this.getEnginePower() * this.properties.getVerticalSpeed() * this.pressingInterpolatedY.getSmooth()), 0.0));
        class_243 direction = this.getDirection();
        float thrust = (float)(Math.pow(this.getEnginePower(), 5.0) * (double)this.properties.getEngineSpeed()) * this.pressingInterpolatedZ.getSmooth();
        this.method_18799(this.method_18798().method_1019(direction.method_1021((double)thrust)));
    }

    @Override
    public void method_5773() {
        super.method_5773();
        float power = this.getEnginePower();
        if (this.field_6002.field_9236) {
            if (this.isWithinParticleRange() && (double)power > 0.01) {
                class_1159 transform = this.getVehicleTransform();
                this.addTrails(transform);
                if (this.field_6012 % 2 == 0) {
                    class_1162 p = this.transformPosition(transform, (this.field_5974.method_43057() - 0.5f) * 0.4f, 0.8f, -0.8f);
                    class_243 velocity = this.method_18798();
                    this.field_6002.method_8406((class_2394)class_2398.field_11251, (double)p.method_4953(), (double)p.method_4956(), (double)p.method_4957(), velocity.field_1352, velocity.field_1351, velocity.field_1350);
                }
            } else {
                this.trails.get(0).add(ZERO_VEC4, ZERO_VEC4, 0.0f);
            }
        }
    }

    protected void addTrails(class_1159 transform) {
        class_1159 tr = transform.method_22673();
        tr.method_31544(0.0f, 0.4f, -1.2f);
        tr.method_22670(class_1160.field_20707.method_23214(this.engineRotation.getSmooth() * 50.0f));
        this.trail(tr);
    }
}

