/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.bases.McdwSpear;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.IMeleeWeaponID;
import chronosacaria.mcdw.registries.ItemsRegistry;
import java.util.EnumMap;
import java.util.HashMap;
import net.minecraft.class_1832;
import net.minecraft.class_1834;

public enum SpearsID implements IMeleeWeaponID
{
    SPEAR_SPEAR((class_1832)class_1834.field_8923, 4, -2.5f, "minecraft:iron_ingot"),
    SPEAR_WHISPERING_SPEAR((class_1832)class_1834.field_8923, 5, -2.5f, "minecraft:iron_ingot"),
    SPEAR_FORTUNE((class_1832)class_1834.field_8923, 5, -2.5f, "minecraft:iron_ingot");

    private final class_1832 material;
    private final int damage;
    private final float attackSpeed;
    private final String[] repairIngredient;

    private SpearsID(class_1832 material, int damage, float attackSpeed, String ... repairIngredient) {
        this.material = material;
        this.damage = damage;
        this.attackSpeed = attackSpeed;
        this.repairIngredient = repairIngredient;
    }

    public static HashMap<SpearsID, Boolean> getEnabledItems() {
        return Mcdw.CONFIG.mcdwEnableItemsConfig.SPEARS_ENABLED;
    }

    public static EnumMap<SpearsID, McdwSpear> getItemsEnum() {
        return ItemsRegistry.SPEAR_ITEMS;
    }

    public static HashMap<SpearsID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.SPEAR_SPAWN_RATES;
    }

    public static HashMap<SpearsID, IMeleeWeaponID.MeleeStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.spearStats;
    }

    @Override
    public Boolean isEnabled() {
        return SpearsID.getEnabledItems().get(this);
    }

    public McdwSpear getItem() {
        return SpearsID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return SpearsID.getSpawnRates().get(this);
    }

    public HashMap<SpearsID, IMeleeWeaponID.MeleeStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.spearStats;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats() {
        return SpearsID.getWeaponStats().get(this);
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.spearStats.get(this);
    }

    @Override
    public class_1832 getMaterial() {
        return this.material;
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    public McdwSpear makeWeapon() {
        McdwSpear mcdwSpear = new McdwSpear(ItemsRegistry.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().damage, this.getWeaponItemStats().attackSpeed, this.getWeaponItemStats().repairIngredient);
        SpearsID.getItemsEnum().put(this, mcdwSpear);
        return mcdwSpear;
    }
}

