/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.bases.McdwShortbow;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.IRangedWeaponID;
import chronosacaria.mcdw.registries.ItemsRegistry;
import java.util.EnumMap;
import java.util.HashMap;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.projectile_damage.api.IProjectileWeapon;

public enum ShortbowsID implements IRangedWeaponID
{
    BOW_LOVE_SPELL_BOW((class_1832)class_1834.field_8923, 3.0, 9, 8.0f, "minecraft:iron_ingot"),
    BOW_MECHANICAL_SHORTBOW((class_1832)class_1834.field_8923, 4.0, 9, 9.0f, "minecraft:iron_ingot"),
    BOW_PURPLE_STORM((class_1832)class_1834.field_8923, 3.0, 9, 8.0f, "minecraft:iron_ingot"),
    BOW_SHORTBOW((class_1832)class_1834.field_8923, 3.0, 9, 8.0f, "minecraft:planks");

    public final class_1832 material;
    public final double projectileDamage;
    public final int drawSpeed;
    public final float range;
    private final String[] repairIngredient;

    private ShortbowsID(class_1832 material, double projectileDamage, int drawSpeed, float range, String ... repairIngredient) {
        this.material = material;
        this.projectileDamage = FabricLoader.getInstance().isModLoaded("projectile_damage") ? projectileDamage : 0.0;
        this.drawSpeed = drawSpeed;
        this.range = range;
        this.repairIngredient = repairIngredient;
    }

    public static HashMap<ShortbowsID, Boolean> getEnabledItems() {
        return Mcdw.CONFIG.mcdwEnableItemsConfig.SHORTBOWS_ENABLED;
    }

    public static EnumMap<ShortbowsID, McdwShortbow> getItemsEnum() {
        return ItemsRegistry.SHORTBOW_ITEMS;
    }

    public static HashMap<ShortbowsID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.SHORTBOW_SPAWN_RATES;
    }

    public static HashMap<ShortbowsID, IRangedWeaponID.RangedStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.shortbowStats;
    }

    @Override
    public Boolean isEnabled() {
        return ShortbowsID.getEnabledItems().get(this);
    }

    public McdwShortbow getItem() {
        return ShortbowsID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return ShortbowsID.getSpawnRates().get(this);
    }

    public HashMap<ShortbowsID, IRangedWeaponID.RangedStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.shortbowStats;
    }

    @Override
    public IRangedWeaponID.RangedStats getWeaponItemStats() {
        return ShortbowsID.getWeaponStats().get(this);
    }

    @Override
    public IRangedWeaponID.RangedStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.shortbowStats.get(this);
    }

    @Override
    public class_1832 getMaterial() {
        return this.material;
    }

    @Override
    public double getProjectileDamage() {
        if (FabricLoader.getInstance().isModLoaded("projectile_damage")) {
            return this.projectileDamage;
        }
        return 0.0;
    }

    @Override
    public int getDrawSpeed() {
        return this.drawSpeed;
    }

    @Override
    public float getRange() {
        return this.range;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    public McdwShortbow makeWeapon() {
        McdwShortbow mcdwShortbow = new McdwShortbow(ItemsRegistry.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().drawSpeed, this.getWeaponItemStats().range, this.getWeaponItemStats().repairIngredient);
        if (FabricLoader.getInstance().isModLoaded("projectile_damage")) {
            ((IProjectileWeapon)mcdwShortbow).setProjectileDamage(this.getWeaponItemStats().projectileDamage);
            ((IProjectileWeapon)mcdwShortbow).setCustomLaunchVelocity(Double.valueOf((double)(this.getWeaponItemStats().range / 15.0f) * 3.0));
        }
        ShortbowsID.getItemsEnum().put(this, mcdwShortbow);
        return mcdwShortbow;
    }
}

