/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.bases.McdwShield;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.IShieldID;
import chronosacaria.mcdw.registries.ItemsRegistry;
import java.util.EnumMap;
import java.util.HashMap;
import net.minecraft.class_1832;
import net.minecraft.class_1834;

public enum ShieldsID implements IShieldID
{
    SHIELD_ROYAL_GUARD((class_1832)class_1834.field_8930, "minecraft:iron_ingot", "minecraft:gold_ingot"),
    SHIELD_TOWER_GUARD((class_1832)class_1834.field_8930, "minecraft:iron_ingot", "minecraft:gold_ingot", "minecraft:copper_ingot"),
    SHIELD_VANGUARD((class_1832)class_1834.field_8930, "minecraft:planks", "minecraft:iron_ingot");

    private final class_1832 material;
    private final String[] repairIngredient;

    private ShieldsID(class_1832 material, String ... repairIngredient) {
        this.material = material;
        this.repairIngredient = repairIngredient;
    }

    public static HashMap<ShieldsID, Boolean> getEnabledItems() {
        return Mcdw.CONFIG.mcdwEnableItemsConfig.SHIELDS_ENABLED;
    }

    public static EnumMap<ShieldsID, McdwShield> getItemsEnum() {
        return ItemsRegistry.SHIELD_ITEMS;
    }

    public static HashMap<ShieldsID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.SHIELD_SPAWN_RATES;
    }

    public static HashMap<ShieldsID, IShieldID.ShieldStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.shieldStats;
    }

    @Override
    public Boolean isEnabled() {
        return ShieldsID.getEnabledItems().get(this);
    }

    public McdwShield getItem() {
        return ShieldsID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return ShieldsID.getSpawnRates().get(this);
    }

    @Override
    public HashMap<ShieldsID, IShieldID.ShieldStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.shieldStats;
    }

    @Override
    public IShieldID.ShieldStats getWeaponItemStats() {
        return ShieldsID.getWeaponStats().get(this);
    }

    @Override
    public IShieldID.ShieldStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return this.getWeaponStats(mcdwNewStatsConfig).get(this);
    }

    @Override
    public class_1832 getMaterial() {
        return this.material;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    public McdwShield makeWeapon() {
        McdwShield mcdwShield = new McdwShield(ItemsRegistry.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().repairIngredient);
        ShieldsID.getItemsEnum().put(this, mcdwShield);
        return mcdwShield;
    }
}

