/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.bases.McdwScythe;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.IMeleeWeaponID;
import chronosacaria.mcdw.registries.ItemsRegistry;
import java.util.EnumMap;
import java.util.HashMap;
import net.minecraft.class_1832;
import net.minecraft.class_1834;

public enum ScythesID implements IMeleeWeaponID
{
    SICKLE_FROST_SCYTHE((class_1832)class_1834.field_8930, 4, -2.9f, "minecraft:diamond"),
    SICKLE_JAILORS_SCYTHE((class_1832)class_1834.field_8923, 4, -2.9f, "minecraft:iron_ingot"),
    SICKLE_SKULL_SCYTHE((class_1832)class_1834.field_8930, 4, -2.9f, "minecraft:diamond"),
    SICKLE_SOUL_SCYTHE((class_1832)class_1834.field_8930, 3, -2.9f, "minecraft:diamond");

    private final class_1832 material;
    private final int damage;
    private final float attackSpeed;
    private final String[] repairIngredient;

    private ScythesID(class_1832 material, int damage, float attackSpeed, String ... repairIngredient) {
        this.material = material;
        this.damage = damage;
        this.attackSpeed = attackSpeed;
        this.repairIngredient = repairIngredient;
    }

    public static HashMap<ScythesID, Boolean> getEnabledItems() {
        return Mcdw.CONFIG.mcdwEnableItemsConfig.SCYTHES_ENABLED;
    }

    public static EnumMap<ScythesID, McdwScythe> getItemsEnum() {
        return ItemsRegistry.SCYTHE_ITEMS;
    }

    public static HashMap<ScythesID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.SCYTHE_SPAWN_RATES;
    }

    public static HashMap<ScythesID, IMeleeWeaponID.MeleeStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.scytheStats;
    }

    @Override
    public Boolean isEnabled() {
        return ScythesID.getEnabledItems().get(this);
    }

    public McdwScythe getItem() {
        return ScythesID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return ScythesID.getSpawnRates().get(this);
    }

    public HashMap<ScythesID, IMeleeWeaponID.MeleeStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.scytheStats;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats() {
        return ScythesID.getWeaponStats().get(this);
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.scytheStats.get(this);
    }

    @Override
    public class_1832 getMaterial() {
        return this.material;
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    public McdwScythe makeWeapon() {
        McdwScythe mcdwScythe = new McdwScythe(ItemsRegistry.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().damage, this.getWeaponItemStats().attackSpeed, this.getWeaponItemStats().repairIngredient);
        ScythesID.getItemsEnum().put(this, mcdwScythe);
        return mcdwScythe;
    }
}

