/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.bases.McdwLongbow;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.IRangedWeaponID;
import chronosacaria.mcdw.registries.ItemsRegistry;
import java.util.EnumMap;
import java.util.HashMap;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.projectile_damage.api.IProjectileWeapon;

public enum LongbowsID implements IRangedWeaponID
{
    BOW_GUARDIAN_BOW((class_1832)class_1834.field_8930, 8.0, 30, 19.0f, "minecraft:diamond"),
    BOW_LONGBOW((class_1832)class_1834.field_8923, 7.0, 25, 17.0f, "minecraft:planks"),
    BOW_RED_SNAKE((class_1832)class_1834.field_8930, 7.0, 30, 18.0f, "minecraft:diamond");

    public final class_1832 material;
    public final double projectileDamage;
    public final int drawSpeed;
    public final float range;
    private final String[] repairIngredient;

    private LongbowsID(class_1832 material, double projectileDamage, int drawSpeed, float range, String ... repairIngredient) {
        this.material = material;
        this.projectileDamage = FabricLoader.getInstance().isModLoaded("projectile_damage") ? projectileDamage : 0.0;
        this.drawSpeed = drawSpeed;
        this.range = range;
        this.repairIngredient = repairIngredient;
    }

    public static HashMap<LongbowsID, Boolean> getEnabledItems() {
        return Mcdw.CONFIG.mcdwEnableItemsConfig.LONGBOWS_ENABLED;
    }

    public static EnumMap<LongbowsID, McdwLongbow> getItemsEnum() {
        return ItemsRegistry.LONGBOW_ITEMS;
    }

    public static HashMap<LongbowsID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.LONGBOW_SPAWN_RATES;
    }

    public static HashMap<LongbowsID, IRangedWeaponID.RangedStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.longbowStats;
    }

    @Override
    public Boolean isEnabled() {
        return LongbowsID.getEnabledItems().get(this);
    }

    public McdwLongbow getItem() {
        return LongbowsID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return LongbowsID.getSpawnRates().get(this);
    }

    public HashMap<LongbowsID, IRangedWeaponID.RangedStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.longbowStats;
    }

    @Override
    public IRangedWeaponID.RangedStats getWeaponItemStats() {
        return LongbowsID.getWeaponStats().get(this);
    }

    @Override
    public IRangedWeaponID.RangedStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.longbowStats.get(this);
    }

    @Override
    public class_1832 getMaterial() {
        return this.material;
    }

    @Override
    public double getProjectileDamage() {
        if (FabricLoader.getInstance().isModLoaded("projectile_damage")) {
            return this.projectileDamage;
        }
        return 0.0;
    }

    @Override
    public int getDrawSpeed() {
        return this.drawSpeed;
    }

    @Override
    public float getRange() {
        return this.range;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    public McdwLongbow makeWeapon() {
        McdwLongbow mcdwLongbow = new McdwLongbow(ItemsRegistry.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().drawSpeed, this.getWeaponItemStats().range, this.getWeaponItemStats().repairIngredient);
        if (FabricLoader.getInstance().isModLoaded("projectile_damage")) {
            ((IProjectileWeapon)mcdwLongbow).setProjectileDamage(this.getWeaponItemStats().projectileDamage);
            ((IProjectileWeapon)mcdwLongbow).setCustomLaunchVelocity(Double.valueOf((double)(this.getWeaponItemStats().range / 15.0f) * 3.0));
        }
        LongbowsID.getItemsEnum().put(this, mcdwLongbow);
        return mcdwLongbow;
    }
}

