/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.bases.McdwGlaive;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.IMeleeWeaponID;
import chronosacaria.mcdw.registries.ItemsRegistry;
import java.util.EnumMap;
import java.util.HashMap;
import net.minecraft.class_1832;
import net.minecraft.class_1834;

public enum GlaivesID implements IMeleeWeaponID
{
    SPEAR_CACKLING_BROOM((class_1832)class_1834.field_8923, 5, -3.0f, "minecraft:iron_ingot"),
    SPEAR_GLAIVE((class_1832)class_1834.field_8923, 5, -3.0f, "minecraft:iron_ingot"),
    SPEAR_GRAVE_BANE((class_1832)class_1834.field_8923, 6, -3.0f, "minecraft:iron_ingot"),
    SPEAR_VENOM_GLAIVE((class_1832)class_1834.field_8923, 6, -3.0f, "minecraft:iron_ingot");

    private final class_1832 material;
    private final int damage;
    private final float attackSpeed;
    private final String[] repairIngredient;

    private GlaivesID(class_1832 material, int damage, float attackSpeed, String ... repairIngredient) {
        this.material = material;
        this.damage = damage;
        this.attackSpeed = attackSpeed;
        this.repairIngredient = repairIngredient;
    }

    public static HashMap<GlaivesID, Boolean> getEnabledItems() {
        return Mcdw.CONFIG.mcdwEnableItemsConfig.GLAIVES_ENABLED;
    }

    public static EnumMap<GlaivesID, McdwGlaive> getItemsEnum() {
        return ItemsRegistry.GLAIVE_ITEMS;
    }

    public static HashMap<GlaivesID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.GLAIVE_SPAWN_RATES;
    }

    public static HashMap<GlaivesID, IMeleeWeaponID.MeleeStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.glaiveStats;
    }

    @Override
    public Boolean isEnabled() {
        return GlaivesID.getEnabledItems().get(this);
    }

    public McdwGlaive getItem() {
        return GlaivesID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return GlaivesID.getSpawnRates().get(this);
    }

    public HashMap<GlaivesID, IMeleeWeaponID.MeleeStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.glaiveStats;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats() {
        return GlaivesID.getWeaponStats().get(this);
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.glaiveStats.get(this);
    }

    @Override
    public class_1832 getMaterial() {
        return this.material;
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    public McdwGlaive makeWeapon() {
        McdwGlaive mcdwGlaive = new McdwGlaive(ItemsRegistry.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().damage, this.getWeaponItemStats().attackSpeed, this.getWeaponItemStats().repairIngredient);
        GlaivesID.getItemsEnum().put(this, mcdwGlaive);
        return mcdwGlaive;
    }
}

