/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.bases.McdwGauntlet;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.IMeleeWeaponID;
import chronosacaria.mcdw.registries.ItemsRegistry;
import java.util.EnumMap;
import java.util.HashMap;
import net.minecraft.class_1832;
import net.minecraft.class_1834;

public enum GauntletsID implements IMeleeWeaponID
{
    GAUNTLET_GAUNTLET((class_1832)class_1834.field_8923, 0, -1.5f, "minecraft:iron_ingot"),
    GAUNTLET_MAULERS((class_1832)class_1834.field_8930, 1, -1.5f, "minecraft:diamond"),
    GAUNTLET_SOUL_FISTS((class_1832)class_1834.field_22033, 0, -1.5f, "minecraft:netherite_scrap");

    private final class_1832 material;
    private final int damage;
    private final float attackSpeed;
    private final String[] repairIngredient;

    private GauntletsID(class_1832 material, int damage, float attackSpeed, String ... repairIngredient) {
        this.material = material;
        this.damage = damage;
        this.attackSpeed = attackSpeed;
        this.repairIngredient = repairIngredient;
    }

    public static HashMap<GauntletsID, Boolean> getEnabledItems() {
        return Mcdw.CONFIG.mcdwEnableItemsConfig.GAUNTLETS_ENABLED;
    }

    public static EnumMap<GauntletsID, McdwGauntlet> getItemsEnum() {
        return ItemsRegistry.GAUNTLET_ITEMS;
    }

    public static HashMap<GauntletsID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.GAUNTLET_SPAWN_RATES;
    }

    public static HashMap<GauntletsID, IMeleeWeaponID.MeleeStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.gauntletStats;
    }

    @Override
    public Boolean isEnabled() {
        return GauntletsID.getEnabledItems().get(this);
    }

    public McdwGauntlet getItem() {
        return GauntletsID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return GauntletsID.getSpawnRates().get(this);
    }

    public HashMap<GauntletsID, IMeleeWeaponID.MeleeStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.gauntletStats;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats() {
        return GauntletsID.getWeaponStats().get(this);
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.gauntletStats.get(this);
    }

    @Override
    public class_1832 getMaterial() {
        return this.material;
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    public McdwGauntlet makeWeapon() {
        McdwGauntlet mcdwGauntlet = new McdwGauntlet(ItemsRegistry.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().damage, this.getWeaponItemStats().attackSpeed, this.getWeaponItemStats().repairIngredient);
        GauntletsID.getItemsEnum().put(this, mcdwGauntlet);
        return mcdwGauntlet;
    }
}

