/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.bases.McdwCrossbow;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.IRangedWeaponID;
import chronosacaria.mcdw.registries.ItemsRegistry;
import java.util.EnumMap;
import java.util.HashMap;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.projectile_damage.api.IProjectileWeapon;

public enum CrossbowsID implements IRangedWeaponID
{
    CROSSBOW_AUTO_CROSSBOW((class_1832)class_1834.field_8923, 9.0, 28, 8.0f, "minecraft:iron_ingot"),
    CROSSBOW_AZURE_SEEKER((class_1832)class_1834.field_8923, 10.0, 28, 8.4f, "minecraft:iron_ingot"),
    CROSSBOW_BABY_CROSSBOW((class_1832)class_1834.field_8923, 8.0, 23, 7.2f, "minecraft:iron_ingot"),
    CROSSBOW_BURST_CROSSBOW((class_1832)class_1834.field_8923, 9.0, 28, 8.0f, "minecraft:iron_ingot"),
    CROSSBOW_BUTTERFLY_CROSSBOW((class_1832)class_1834.field_8923, 10.0, 28, 8.9f, "minecraft:iron_ingot"),
    CROSSBOW_COG_CROSSBOW((class_1832)class_1834.field_8923, 10.0, 28, 8.4f, "minecraft:iron_ingot"),
    CROSSBOW_CORRUPTED_CROSSBOW((class_1832)class_1834.field_22033, 16.0, 22, 14.0f, "minecraft:netherite_scrap"),
    CROSSBOW_DOOM_CROSSBOW((class_1832)class_1834.field_22033, 9.0, 26, 8.0f, "minecraft:netherite_scrap"),
    CROSSBOW_DUAL_CROSSBOW((class_1832)class_1834.field_8923, 8.0, 24, 7.0f, "minecraft:iron_ingot"),
    CROSSBOW_EXPLODING_CROSSBOW((class_1832)class_1834.field_8923, 9.0, 28, 8.0f, "minecraft:iron_ingot"),
    CROSSBOW_FERAL_SOUL_CROSSBOW((class_1832)class_1834.field_8923, 10.0, 28, 9.2f, "minecraft:iron_ingot"),
    CROSSBOW_FIREBOLT_THROWER((class_1832)class_1834.field_8923, 9.0, 28, 7.9f, "minecraft:iron_ingot"),
    CROSSBOW_HARPOON_CROSSBOW((class_1832)class_1834.field_8923, 12.0, 28, 11.0f, "minecraft:iron_ingot"),
    CROSSBOW_HARP_CROSSBOW((class_1832)class_1834.field_8923, 10.0, 28, 8.6f, "minecraft:iron_ingot"),
    CROSSBOW_HEAVY_CROSSBOW((class_1832)class_1834.field_8923, 9.0, 28, 8.0f, "minecraft:iron_ingot"),
    CROSSBOW_IMPLODING_CROSSBOW((class_1832)class_1834.field_8923, 9.0, 28, 8.0f, "minecraft:iron_ingot"),
    CROSSBOW_LIGHTNING_HARP_CROSSBOW((class_1832)class_1834.field_8930, 16.0, 28, 14.2f, "minecraft:diamond"),
    CROSSBOW_NAUTICAL_CROSSBOW((class_1832)class_1834.field_8930, 16.0, 24, 14.0f, "minecraft:diamond"),
    CROSSBOW_PRIDE_OF_THE_PIGLINS((class_1832)class_1834.field_22033, 15.0, 20, 13.0f, "minecraft:netherite_scrap"),
    CROSSBOW_RAPID_CROSSBOW((class_1832)class_1834.field_8923, 9.0, 20, 8.2f, "minecraft:iron_ingot"),
    CROSSBOW_SCATTER_CROSSBOW((class_1832)class_1834.field_8923, 9.0, 28, 8.0f, "minecraft:iron_ingot"),
    CROSSBOW_SHADOW_CROSSBOW((class_1832)class_1834.field_8930, 14.0, 25, 12.0f, "minecraft:diamond"),
    CROSSBOW_SLAYER_CROSSBOW((class_1832)class_1834.field_8930, 10.0, 26, 8.8f, "minecraft:diamond"),
    CROSSBOW_SOUL_CROSSBOW((class_1832)class_1834.field_8923, 9.0, 28, 8.0f, "minecraft:iron_ingot"),
    CROSSBOW_SOUL_HUNTER_CROSSBOW((class_1832)class_1834.field_8930, 12.0, 28, 11.0f, "minecraft:diamond"),
    CROSSBOW_SPELLBOUND_CROSSBOW((class_1832)class_1834.field_8923, 10.0, 28, 8.9f, "minecraft:iron_ingot"),
    CROSSBOW_THE_SLICER((class_1832)class_1834.field_8923, 12.0, 28, 10.2f, "minecraft:iron_ingot"),
    CROSSBOW_VEILED_CROSSBOW((class_1832)class_1834.field_8930, 16.0, 22, 14.5f, "minecraft:diamond"),
    CROSSBOW_VOIDCALLER_CROSSBOW((class_1832)class_1834.field_8930, 14.0, 26, 12.5f, "minecraft:diamond");

    public final class_1832 material;
    public final double projectileDamage;
    public final int drawSpeed;
    public final float range;
    private final String[] repairIngredient;

    private CrossbowsID(class_1832 material, double projectileDamage, int drawSpeed, float range, String ... repairIngredient) {
        this.material = material;
        this.projectileDamage = FabricLoader.getInstance().isModLoaded("projectile_damage") ? projectileDamage : 0.0;
        this.drawSpeed = drawSpeed;
        this.range = range;
        this.repairIngredient = repairIngredient;
    }

    public static HashMap<CrossbowsID, Boolean> getEnabledItems() {
        return Mcdw.CONFIG.mcdwEnableItemsConfig.CROSSBOWS_ENABLED;
    }

    public static EnumMap<CrossbowsID, McdwCrossbow> getItemsEnum() {
        return ItemsRegistry.CROSSBOW_ITEMS;
    }

    public static HashMap<CrossbowsID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.CROSSBOW_SPAWN_RATES;
    }

    public static HashMap<CrossbowsID, IRangedWeaponID.RangedStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.crossbowStats;
    }

    @Override
    public Boolean isEnabled() {
        return CrossbowsID.getEnabledItems().get(this);
    }

    public McdwCrossbow getItem() {
        return CrossbowsID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return CrossbowsID.getSpawnRates().get(this);
    }

    public HashMap<CrossbowsID, IRangedWeaponID.RangedStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.crossbowStats;
    }

    @Override
    public IRangedWeaponID.RangedStats getWeaponItemStats() {
        return CrossbowsID.getWeaponStats().get(this);
    }

    @Override
    public IRangedWeaponID.RangedStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.crossbowStats.get(this);
    }

    @Override
    public class_1832 getMaterial() {
        return this.material;
    }

    @Override
    public double getProjectileDamage() {
        if (FabricLoader.getInstance().isModLoaded("projectile_damage")) {
            return this.projectileDamage;
        }
        return 0.0;
    }

    @Override
    public int getDrawSpeed() {
        return this.drawSpeed;
    }

    @Override
    public float getRange() {
        return this.range;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    public McdwCrossbow makeWeapon() {
        McdwCrossbow mcdwCrossbow = new McdwCrossbow(ItemsRegistry.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().drawSpeed, this.getWeaponItemStats().range, this.getWeaponItemStats().repairIngredient);
        if (FabricLoader.getInstance().isModLoaded("projectile_damage")) {
            ((IProjectileWeapon)mcdwCrossbow).setProjectileDamage(this.getWeaponItemStats().projectileDamage);
            ((IProjectileWeapon)mcdwCrossbow).setCustomLaunchVelocity(Double.valueOf((double)(this.getWeaponItemStats().range / 8.0f) * 3.15));
        }
        CrossbowsID.getItemsEnum().put(this, mcdwCrossbow);
        return mcdwCrossbow;
    }
}

