/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.bases.McdwBow;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.IRangedWeaponID;
import chronosacaria.mcdw.registries.ItemsRegistry;
import java.util.EnumMap;
import java.util.HashMap;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.projectile_damage.api.IProjectileWeapon;

public enum BowsID implements IRangedWeaponID
{
    BOW_ANCIENT_BOW((class_1832)class_1834.field_22033, 7.0, 14, 18.0f, "minecraft:netherite_scrap"),
    BOW_BONEBOW((class_1832)class_1834.field_8927, 5.0, 16, 12.0f, "minecraft:bone"),
    BOW_BUBBLE_BOW((class_1832)class_1834.field_8923, 5.0, 15, 12.0f, "minecraft:iron_ingot"),
    BOW_BUBBLE_BURSTER((class_1832)class_1834.field_8930, 5.0, 15, 13.0f, "minecraft:diamond"),
    BOW_BURST_GALE_BOW((class_1832)class_1834.field_8930, 6.0, 12, 16.0f, "minecraft:diamond"),
    BOW_CALL_OF_THE_VOID((class_1832)class_1834.field_22033, 6.0, 15, 16.0f, "minecraft:netherite_scrap"),
    BOW_ECHO_OF_THE_VALLEY((class_1832)class_1834.field_8930, 6.0, 11, 16.0f, "minecraft:diamond"),
    BOW_ELITE_POWER_BOW((class_1832)class_1834.field_8923, 6.0, 20, 15.0f, "minecraft:iron_ingot"),
    BOW_GREEN_MENACE((class_1832)class_1834.field_8930, 5.0, 17, 13.0f, "minecraft:diamond"),
    BOW_HAUNTED_BOW((class_1832)class_1834.field_22033, 6.0, 18, 16.0f, "minecraft:netherite_scrap"),
    BOW_HUNTERS_PROMISE((class_1832)class_1834.field_8923, 6.0, 15, 16.0f, "minecraft:iron_ingot"),
    BOW_HUNTING_BOW((class_1832)class_1834.field_8923, 6.0, 16, 15.0f, "minecraft:iron_ingot"),
    BOW_LOST_SOULS((class_1832)class_1834.field_22033, 6.0, 12, 17.0f, "minecraft:netherite_scrap"),
    BOW_MASTERS_BOW((class_1832)class_1834.field_8923, 6.0, 17, 16.0f, "minecraft:iron_ingot"),
    BOW_NOCTURNAL_BOW((class_1832)class_1834.field_8930, 6.0, 17, 14.0f, "minecraft:diamond"),
    BOW_PHANTOM_BOW((class_1832)class_1834.field_8930, 6.0, 20, 14.0f, "minecraft:diamond"),
    BOW_PINK_SCOUNDREL((class_1832)class_1834.field_8930, 5.0, 17, 13.0f, "minecraft:diamond"),
    BOW_POWER_BOW((class_1832)class_1834.field_8923, 6.0, 20, 14.0f, "minecraft:iron_ingot"),
    BOW_SABREWING((class_1832)class_1834.field_8930, 5.0, 10, 13.0f, "minecraft:diamond"),
    BOW_SHIVERING_BOW((class_1832)class_1834.field_8930, 6.0, 14, 15.0f, "minecraft:diamond"),
    BOW_SNOW_BOW((class_1832)class_1834.field_8923, 5.0, 16, 13.0f, "minecraft:iron_ingot"),
    BOW_SOUL_BOW((class_1832)class_1834.field_8923, 6.0, 14, 15.0f, "minecraft:iron_ingot"),
    BOW_TRICKBOW((class_1832)class_1834.field_8930, 5.0, 12, 12.0f, "minecraft:diamond"),
    BOW_TWIN_BOW((class_1832)class_1834.field_8930, 5.0, 12, 12.0f, "minecraft:diamond"),
    BOW_TWISTING_VINE_BOW((class_1832)class_1834.field_8923, 5.0, 15, 13.0f, "minecraft:iron_ingot"),
    BOW_VOID_BOW((class_1832)class_1834.field_8930, 6.0, 15, 16.0f, "minecraft:diamond"),
    BOW_WEB_BOW((class_1832)class_1834.field_8930, 5.0, 15, 12.0f, "minecraft:diamond"),
    BOW_WEEPING_VINE_BOW((class_1832)class_1834.field_8923, 5.0, 15, 13.0f, "minecraft:iron_ingot"),
    BOW_WIND_BOW((class_1832)class_1834.field_8930, 6.0, 11, 15.0f, "minecraft:diamond"),
    BOW_WINTERS_TOUCH((class_1832)class_1834.field_8930, 6.0, 15, 14.0f, "minecraft:diamond");

    public final class_1832 material;
    public final double projectileDamage;
    public final int drawSpeed;
    public final float range;
    private final String[] repairIngredient;

    private BowsID(class_1832 material, double projectileDamage, int drawSpeed, float range, String ... repairIngredient) {
        this.material = material;
        this.projectileDamage = FabricLoader.getInstance().isModLoaded("projectile_damage") ? projectileDamage : 0.0;
        this.drawSpeed = drawSpeed;
        this.range = range;
        this.repairIngredient = repairIngredient;
    }

    public static HashMap<BowsID, Boolean> getEnabledItems() {
        return Mcdw.CONFIG.mcdwEnableItemsConfig.BOWS_ENABLED;
    }

    public static EnumMap<BowsID, McdwBow> getItemsEnum() {
        return ItemsRegistry.BOW_ITEMS;
    }

    public static HashMap<BowsID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.BOW_SPAWN_RATES;
    }

    public static HashMap<BowsID, IRangedWeaponID.RangedStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.bowStats;
    }

    @Override
    public Boolean isEnabled() {
        return BowsID.getEnabledItems().get(this);
    }

    public McdwBow getItem() {
        return BowsID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return BowsID.getSpawnRates().get(this);
    }

    public HashMap<BowsID, IRangedWeaponID.RangedStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.bowStats;
    }

    @Override
    public IRangedWeaponID.RangedStats getWeaponItemStats() {
        return BowsID.getWeaponStats().get(this);
    }

    @Override
    public IRangedWeaponID.RangedStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.bowStats.get(this);
    }

    @Override
    public class_1832 getMaterial() {
        return this.material;
    }

    @Override
    public double getProjectileDamage() {
        if (FabricLoader.getInstance().isModLoaded("projectile_damage")) {
            return this.projectileDamage;
        }
        return 0.0;
    }

    @Override
    public int getDrawSpeed() {
        return this.drawSpeed;
    }

    @Override
    public float getRange() {
        return this.range;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    public McdwBow makeWeapon() {
        McdwBow mcdwBow = new McdwBow(ItemsRegistry.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().drawSpeed, this.getWeaponItemStats().range, this.getWeaponItemStats().repairIngredient);
        if (FabricLoader.getInstance().isModLoaded("projectile_damage")) {
            ((IProjectileWeapon)mcdwBow).setProjectileDamage(this.getWeaponItemStats().projectileDamage);
            ((IProjectileWeapon)mcdwBow).setCustomLaunchVelocity(Double.valueOf((double)(this.getWeaponItemStats().range / 15.0f) * 3.0));
        }
        BowsID.getItemsEnum().put(this, mcdwBow);
        return mcdwBow;
    }
}

