/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.bases;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.api.util.CleanlinessHelper;
import chronosacaria.mcdw.api.util.RarityHelper;
import chronosacaria.mcdw.enums.SwordsID;
import chronosacaria.mcdw.mixin.InsulatedAxeItemAccessor;
import chronosacaria.mcdw.registries.ItemsRegistry;
import com.google.common.collect.BiMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2465;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_5712;
import net.minecraft.class_5953;
import net.minecraft.class_5955;

public class McdwSword
extends class_1829 {
    String[] repairIngredient;

    public McdwSword(class_1832 material, int attackDamage, float attackSpeed, String[] repairIngredient) {
        super(material, attackDamage, attackSpeed, new class_1792.class_1793().method_7892(Mcdw.WEAPONS).method_7894(RarityHelper.fromToolMaterial(material)));
        this.repairIngredient = repairIngredient;
    }

    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return CleanlinessHelper.canRepairCheck(this.repairIngredient, ingredient);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 world = context.method_8045();
        class_2338 blockPos = context.method_8037();
        class_1657 playerEntity = context.method_8036();
        class_2680 blockState = world.method_8320(blockPos);
        Optional<class_2680> strippedState = this.getStrippedState(blockState);
        Optional decreasedOxidationState = class_5955.method_34735((class_2680)blockState);
        Optional<class_2680> blockStateOptional = Optional.ofNullable((class_2248)((BiMap)class_5953.field_29561.get()).get((Object)blockState.method_26204())).map(block -> block.method_34725(blockState));
        class_1799 itemStack = context.method_8041();
        Optional<Object> empty = Optional.empty();
        if (context.method_8041().method_31574((class_1792)SwordsID.SWORD_MECHANIZED_SAWBLADE.getItem())) {
            if (strippedState.isPresent()) {
                world.method_8396(playerEntity, blockPos, class_3417.field_14675, class_3419.field_15245, 1.0f, 1.0f);
                empty = strippedState;
            } else if (decreasedOxidationState.isPresent()) {
                world.method_8396(playerEntity, blockPos, class_3417.field_29541, class_3419.field_15245, 1.0f, 1.0f);
                world.method_8444(playerEntity, 3005, blockPos, 0);
                empty = decreasedOxidationState;
            } else if (blockStateOptional.isPresent()) {
                world.method_8396(playerEntity, blockPos, class_3417.field_29542, class_3419.field_15245, 1.0f, 1.0f);
                world.method_8444(playerEntity, 3004, blockPos, 0);
                empty = blockStateOptional;
            }
            if (empty.isPresent()) {
                if (playerEntity instanceof class_3222) {
                    class_174.field_24478.method_23889((class_3222)playerEntity, blockPos, itemStack);
                }
                world.method_8652(blockPos, (class_2680)empty.get(), 11);
                world.method_43276(class_5712.field_28733, blockPos, class_5712.class_7397.method_43286((class_1297)playerEntity, (class_2680)((class_2680)empty.get())));
                if (playerEntity != null) {
                    itemStack.method_7956(1, (class_1309)playerEntity, p -> p.method_20236(context.method_20287()));
                }
                return class_1269.method_29236((boolean)world.field_9236);
            }
            return class_1269.field_5811;
        }
        return class_1269.field_5811;
    }

    public float method_7865(class_1799 stack, class_2680 state) {
        if (stack.method_31574((class_1792)SwordsID.SWORD_MECHANIZED_SAWBLADE.getItem()) && state.method_26164(class_3481.field_33713)) {
            return 8.0f;
        }
        return super.method_7865(stack, state);
    }

    private Optional<class_2680> getStrippedState(class_2680 state) {
        return Optional.ofNullable(InsulatedAxeItemAccessor.getSTRIPPED_BLOCKS().get(state.method_26204())).map(block -> (class_2680)block.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459))));
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 tooltipContext) {
        super.method_7851(stack, world, tooltip, tooltipContext);
        int i = 1;
        String str = stack.method_7909().method_7876().toLowerCase(Locale.ROOT).substring(16);
        String translationKey = String.format("tooltip_info_item.mcdw.%s_", str);
        while (class_1074.method_4663((String)(translationKey + i))) {
            tooltip.add((class_2561)class_2561.method_43471((String)(translationKey + i)).method_27692(class_124.field_1056));
            ++i;
        }
        if (stack.method_7909() == ItemsRegistry.SWORD_ITEMS.get(SwordsID.SWORD_BEESTINGER)) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip_ench_item.mcdw.beestinger_1").method_27692(class_124.field_1080));
        }
        if (stack.method_7909() == ItemsRegistry.SWORD_ITEMS.get(SwordsID.SWORD_DIAMOND_SWORD_VAR)) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip_info_item.mcdw.diamond_sword_1").method_27692(class_124.field_1056));
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip_info_item.mcdw.diamond_sword_2").method_27692(class_124.field_1056));
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip_info_item.mcdw.diamond_sword_3").method_27692(class_124.field_1056));
        }
    }
}

