/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.api.util;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1887;

public final class EnchantmentRestriction {
    private static ArrayListMultimap<class_1887, Condition> permissions = ArrayListMultimap.create();
    private static ArrayList<TypeCondition> permissibleTargets = new ArrayList();
    private static ArrayListMultimap<class_1887, Condition> prohibitions = ArrayListMultimap.create();
    private static ArrayList<TypeCondition> prohibitedTargets = new ArrayList();

    public static void permit(class_1887 enchantment, Condition condition) {
        permissions.put((Object)enchantment, (Object)condition);
    }

    public static void permitTarget(TypeCondition typeCondition) {
        permissibleTargets.add(typeCondition);
    }

    public static void prohibit(class_1887 enchantment, Condition condition) {
        prohibitions.put((Object)enchantment, (Object)condition);
    }

    public static void prohibitTarget(TypeCondition typeCondition) {
        prohibitedTargets.add(typeCondition);
    }

    public static boolean isPermitted(class_1887 enchantment, class_1799 itemStack) {
        List conditions = permissions.get((Object)enchantment);
        for (Condition condition : conditions) {
            if (!condition.isAcceptableItem(itemStack)) continue;
            return true;
        }
        for (TypeCondition typeCondition : permissibleTargets) {
            if (!typeCondition.isAcceptableItem(enchantment, itemStack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isProhibited(class_1887 enchantment, class_1799 itemStack) {
        List conditions = prohibitions.get((Object)enchantment);
        for (Condition condition : conditions) {
            if (!condition.isAcceptableItem(itemStack)) continue;
            return true;
        }
        for (TypeCondition typeCondition : prohibitedTargets) {
            if (!typeCondition.isAcceptableItem(enchantment, itemStack)) continue;
            return true;
        }
        return false;
    }

    public static interface Condition {
        public boolean isAcceptableItem(class_1799 var1);
    }

    public static interface TypeCondition {
        public boolean isAcceptableItem(class_1887 var1, class_1799 var2);
    }
}

